/*
 * Decompiled with CFR 0.152.
 */
package com.zurrtum.create.client.ponder.foundation;

import com.zurrtum.create.catnip.math.Pointing;
import com.zurrtum.create.catnip.math.VecHelper;
import com.zurrtum.create.catnip.theme.Color;
import com.zurrtum.create.client.ponder.api.ParticleEmitter;
import com.zurrtum.create.client.ponder.api.PonderPalette;
import com.zurrtum.create.client.ponder.api.element.AnimatedSceneElement;
import com.zurrtum.create.client.ponder.api.element.ElementLink;
import com.zurrtum.create.client.ponder.api.element.EntityElement;
import com.zurrtum.create.client.ponder.api.element.InputElementBuilder;
import com.zurrtum.create.client.ponder.api.element.MinecartElement;
import com.zurrtum.create.client.ponder.api.element.ParrotElement;
import com.zurrtum.create.client.ponder.api.element.ParrotPose;
import com.zurrtum.create.client.ponder.api.element.TextElementBuilder;
import com.zurrtum.create.client.ponder.api.element.WorldSectionElement;
import com.zurrtum.create.client.ponder.api.level.PonderLevel;
import com.zurrtum.create.client.ponder.api.scene.DebugInstructions;
import com.zurrtum.create.client.ponder.api.scene.EffectInstructions;
import com.zurrtum.create.client.ponder.api.scene.OverlayInstructions;
import com.zurrtum.create.client.ponder.api.scene.SceneBuilder;
import com.zurrtum.create.client.ponder.api.scene.Selection;
import com.zurrtum.create.client.ponder.api.scene.SpecialInstructions;
import com.zurrtum.create.client.ponder.api.scene.WorldInstructions;
import com.zurrtum.create.client.ponder.foundation.PonderScene;
import com.zurrtum.create.client.ponder.foundation.element.ElementLinkImpl;
import com.zurrtum.create.client.ponder.foundation.element.EntityElementImpl;
import com.zurrtum.create.client.ponder.foundation.element.InputWindowElement;
import com.zurrtum.create.client.ponder.foundation.element.ParrotElementImpl;
import com.zurrtum.create.client.ponder.foundation.element.TextWindowElement;
import com.zurrtum.create.client.ponder.foundation.element.WorldSectionElementImpl;
import com.zurrtum.create.client.ponder.foundation.instruction.AnimateMinecartInstruction;
import com.zurrtum.create.client.ponder.foundation.instruction.AnimateParrotInstruction;
import com.zurrtum.create.client.ponder.foundation.instruction.AnimateWorldSectionInstruction;
import com.zurrtum.create.client.ponder.foundation.instruction.BlockEntityDataInstruction;
import com.zurrtum.create.client.ponder.foundation.instruction.ChaseAABBInstruction;
import com.zurrtum.create.client.ponder.foundation.instruction.CreateMinecartInstruction;
import com.zurrtum.create.client.ponder.foundation.instruction.CreateParrotInstruction;
import com.zurrtum.create.client.ponder.foundation.instruction.DelayInstruction;
import com.zurrtum.create.client.ponder.foundation.instruction.DisplayWorldSectionInstruction;
import com.zurrtum.create.client.ponder.foundation.instruction.EmitParticlesInstruction;
import com.zurrtum.create.client.ponder.foundation.instruction.FadeOutOfSceneInstruction;
import com.zurrtum.create.client.ponder.foundation.instruction.HighlightValueBoxInstruction;
import com.zurrtum.create.client.ponder.foundation.instruction.KeyframeInstruction;
import com.zurrtum.create.client.ponder.foundation.instruction.LineInstruction;
import com.zurrtum.create.client.ponder.foundation.instruction.MarkAsFinishedInstruction;
import com.zurrtum.create.client.ponder.foundation.instruction.MinecartElementImpl;
import com.zurrtum.create.client.ponder.foundation.instruction.MovePoiInstruction;
import com.zurrtum.create.client.ponder.foundation.instruction.OutlineSelectionInstruction;
import com.zurrtum.create.client.ponder.foundation.instruction.PonderInstruction;
import com.zurrtum.create.client.ponder.foundation.instruction.ReplaceBlocksInstruction;
import com.zurrtum.create.client.ponder.foundation.instruction.RotateSceneInstruction;
import com.zurrtum.create.client.ponder.foundation.instruction.ShowInputInstruction;
import com.zurrtum.create.client.ponder.foundation.instruction.TextInstruction;
import java.util.UUID;
import java.util.function.Consumer;
import java.util.function.Function;
import java.util.function.Supplier;
import java.util.function.UnaryOperator;
import net.fabricmc.api.EnvType;
import net.fabricmc.api.Environment;
import net.minecraft.class_1297;
import net.minecraft.class_1542;
import net.minecraft.class_1799;
import net.minecraft.class_1937;
import net.minecraft.class_2246;
import net.minecraft.class_2338;
import net.minecraft.class_2350;
import net.minecraft.class_238;
import net.minecraft.class_2382;
import net.minecraft.class_2390;
import net.minecraft.class_2394;
import net.minecraft.class_243;
import net.minecraft.class_2459;
import net.minecraft.class_2487;
import net.minecraft.class_2586;
import net.minecraft.class_2680;
import net.minecraft.class_2741;
import net.minecraft.class_2769;
import net.minecraft.class_2960;
import net.minecraft.class_7225;

@Environment(value=EnvType.CLIENT)
public class PonderSceneBuilder
implements SceneBuilder {
    private final OverlayInstructions overlay;
    private final WorldInstructions world;
    private final DebugInstructions debug;
    private final EffectInstructions effects;
    private final SpecialInstructions special;
    protected final PonderScene scene;

    public PonderSceneBuilder(PonderScene ponderScene) {
        this.scene = ponderScene;
        this.overlay = new PonderOverlayInstructions();
        this.special = new PonderSpecialInstructions();
        this.world = new PonderWorldInstructions();
        this.debug = new PonderDebugInstructions();
        this.effects = new PonderEffectInstructions();
    }

    @Override
    public OverlayInstructions overlay() {
        return this.overlay;
    }

    @Override
    public WorldInstructions world() {
        return this.world;
    }

    @Override
    public DebugInstructions debug() {
        return this.debug;
    }

    @Override
    public EffectInstructions effects() {
        return this.effects;
    }

    @Override
    public SpecialInstructions special() {
        return this.special;
    }

    @Override
    public PonderScene getScene() {
        return this.scene;
    }

    @Override
    public void title(String sceneId, String title) {
        this.scene.sceneId = class_2960.method_60655((String)this.scene.getNamespace(), (String)sceneId);
        this.scene.localization.registerSpecific(this.scene.sceneId, "header", title);
    }

    @Override
    public void configureBasePlate(int xOffset, int zOffset, int basePlateSize) {
        this.scene.basePlateOffsetX = xOffset;
        this.scene.basePlateOffsetZ = zOffset;
        this.scene.basePlateSize = basePlateSize;
    }

    @Override
    public void scaleSceneView(float factor) {
        this.scene.scaleFactor = factor;
    }

    @Override
    public void removeShadow() {
        this.scene.hidePlatformShadow = true;
    }

    @Override
    public void setSceneOffsetY(float yOffset) {
        this.scene.yOffset = yOffset;
    }

    @Override
    public void showBasePlate() {
        this.world.showSection(this.scene.getSceneBuildingUtil().select().cuboid(new class_2338(this.scene.getBasePlateOffsetX(), 0, this.scene.getBasePlateOffsetZ()), new class_2382(this.scene.getBasePlateSize() - 1, 0, this.scene.getBasePlateSize() - 1)), class_2350.field_11036);
    }

    @Override
    public void addInstruction(PonderInstruction instruction) {
        this.scene.schedule.add(instruction);
    }

    @Override
    public void addInstruction(Consumer<PonderScene> callback) {
        this.addInstruction(PonderInstruction.simple(callback));
    }

    @Override
    public void idle(int ticks) {
        this.addInstruction(new DelayInstruction(ticks));
    }

    @Override
    public void idleSeconds(int seconds) {
        this.idle(seconds * 20);
    }

    @Override
    public void markAsFinished() {
        this.addInstruction(new MarkAsFinishedInstruction());
    }

    @Override
    public void setNextUpEnabled(boolean isEnabled) {
        this.addInstruction((PonderScene scene) -> scene.setNextUpEnabled(isEnabled));
    }

    @Override
    public void rotateCameraY(float degrees) {
        this.addInstruction(new RotateSceneInstruction(0.0f, degrees, true));
    }

    @Override
    public void addKeyframe() {
        this.addInstruction(KeyframeInstruction.IMMEDIATE);
    }

    @Override
    public void addLazyKeyframe() {
        this.addInstruction(KeyframeInstruction.DELAYED);
    }

    @Environment(value=EnvType.CLIENT)
    public class PonderOverlayInstructions
    implements OverlayInstructions {
        @Override
        public TextElementBuilder showText(int duration) {
            TextWindowElement textWindowElement = new TextWindowElement();
            PonderSceneBuilder.this.addInstruction(new TextInstruction(textWindowElement, duration));
            return textWindowElement.builder(PonderSceneBuilder.this.scene);
        }

        @Override
        public TextElementBuilder showOutlineWithText(Selection selection, int duration) {
            TextWindowElement textWindowElement = new TextWindowElement();
            PonderSceneBuilder.this.addInstruction(new TextInstruction(textWindowElement, duration, selection));
            return textWindowElement.builder(PonderSceneBuilder.this.scene).pointAt(selection.getCenter());
        }

        @Override
        public InputElementBuilder showControls(class_243 sceneSpace, Pointing direction, int duration) {
            InputWindowElement inputWindowElement = new InputWindowElement(sceneSpace, direction);
            PonderSceneBuilder.this.addInstruction(new ShowInputInstruction(inputWindowElement, duration));
            return inputWindowElement.builder();
        }

        @Override
        public void chaseBoundingBoxOutline(PonderPalette color, Object slot, class_238 boundingBox, int duration) {
            PonderSceneBuilder.this.addInstruction(new ChaseAABBInstruction(color, slot, boundingBox, duration));
        }

        @Override
        public void showCenteredScrollInput(class_2338 pos, class_2350 side, int duration) {
            this.showScrollInput(PonderSceneBuilder.this.scene.getSceneBuildingUtil().vector().blockSurface(pos, side), side, duration);
        }

        @Override
        public void showScrollInput(class_243 location, class_2350 side, int duration) {
            class_2350.class_2351 axis = side.method_10166();
            float s = 0.0625f;
            float q = 0.25f;
            class_243 expands = new class_243(axis == class_2350.class_2351.field_11048 ? (double)s : (double)q, axis == class_2350.class_2351.field_11052 ? (double)s : (double)q, axis == class_2350.class_2351.field_11051 ? (double)s : (double)q);
            PonderSceneBuilder.this.addInstruction(new HighlightValueBoxInstruction(location, expands, duration));
        }

        @Override
        public void showRepeaterScrollInput(class_2338 pos, int duration) {
            float s = 0.0625f;
            float q = 0.16666667f;
            class_243 expands = new class_243((double)q, (double)s, (double)q);
            PonderSceneBuilder.this.addInstruction(new HighlightValueBoxInstruction(PonderSceneBuilder.this.scene.getSceneBuildingUtil().vector().blockSurface(pos, class_2350.field_11033).method_1031(0.0, 0.1875, 0.0), expands, duration));
        }

        @Override
        public void showFilterSlotInput(class_243 location, int duration) {
            float s = 0.1f;
            class_243 expands = new class_243((double)s, (double)s, (double)s);
            PonderSceneBuilder.this.addInstruction(new HighlightValueBoxInstruction(location, expands, duration));
        }

        @Override
        public void showFilterSlotInput(class_243 location, class_2350 side, int duration) {
            location = location.method_1019(class_243.method_24954((class_2382)side.method_62675()).method_1021(-0.0234375));
            class_243 expands = VecHelper.axisAlingedPlaneOf(side).method_1021(0.0859375);
            PonderSceneBuilder.this.addInstruction(new HighlightValueBoxInstruction(location, expands, duration));
        }

        @Override
        public void showLine(PonderPalette color, class_243 start, class_243 end, int duration) {
            PonderSceneBuilder.this.addInstruction(new LineInstruction(color, start, end, duration, false));
        }

        @Override
        public void showBigLine(PonderPalette color, class_243 start, class_243 end, int duration) {
            PonderSceneBuilder.this.addInstruction(new LineInstruction(color, start, end, duration, true));
        }

        @Override
        public void showOutline(PonderPalette color, Object slot, Selection selection, int duration) {
            PonderSceneBuilder.this.addInstruction(new OutlineSelectionInstruction(color, slot, selection, duration));
        }
    }

    @Environment(value=EnvType.CLIENT)
    public class PonderSpecialInstructions
    implements SpecialInstructions {
        @Override
        public ElementLink<ParrotElement> createBirb(class_243 location, Supplier<? extends ParrotPose> pose) {
            ElementLinkImpl<ParrotElement> link = new ElementLinkImpl<ParrotElement>(ParrotElement.class);
            ParrotElement parrot = ParrotElementImpl.create(location, pose);
            PonderSceneBuilder.this.addInstruction(new CreateParrotInstruction(10, class_2350.field_11033, parrot));
            PonderSceneBuilder.this.addInstruction(scene -> scene.linkElement(parrot, link));
            return link;
        }

        @Override
        public void changeBirbPose(ElementLink<ParrotElement> birb, Supplier<? extends ParrotPose> pose) {
            PonderSceneBuilder.this.addInstruction(scene -> scene.resolveOptional(birb).ifPresent(arg_0 -> PonderSpecialInstructions.lambda$changeBirbPose$1((Supplier)pose, arg_0)));
        }

        @Override
        public void movePointOfInterest(class_243 location) {
            PonderSceneBuilder.this.addInstruction(new MovePoiInstruction(location));
        }

        @Override
        public void movePointOfInterest(class_2338 location) {
            this.movePointOfInterest(VecHelper.getCenterOf((class_2382)location));
        }

        @Override
        public void rotateParrot(ElementLink<ParrotElement> link, double xRotation, double yRotation, double zRotation, int duration) {
            PonderSceneBuilder.this.addInstruction(AnimateParrotInstruction.rotate(link, new class_243(xRotation, yRotation, zRotation), duration));
        }

        @Override
        public void moveParrot(ElementLink<ParrotElement> link, class_243 offset, int duration) {
            PonderSceneBuilder.this.addInstruction(AnimateParrotInstruction.move(link, offset, duration));
        }

        @Override
        public ElementLink<MinecartElement> createCart(class_243 location, float angle, MinecartElement.MinecartConstructor type) {
            ElementLinkImpl<MinecartElement> link = new ElementLinkImpl<MinecartElement>(MinecartElement.class);
            MinecartElementImpl cart = new MinecartElementImpl(location, angle, type);
            PonderSceneBuilder.this.addInstruction(new CreateMinecartInstruction(10, class_2350.field_11033, cart));
            PonderSceneBuilder.this.addInstruction(scene -> scene.linkElement(cart, link));
            return link;
        }

        @Override
        public void rotateCart(ElementLink<MinecartElement> link, float yRotation, int duration) {
            PonderSceneBuilder.this.addInstruction(AnimateMinecartInstruction.rotate(link, yRotation, duration));
        }

        @Override
        public void moveCart(ElementLink<MinecartElement> link, class_243 offset, int duration) {
            PonderSceneBuilder.this.addInstruction(AnimateMinecartInstruction.move(link, offset, duration));
        }

        @Override
        public <T extends AnimatedSceneElement> void hideElement(ElementLink<T> link, class_2350 direction) {
            PonderSceneBuilder.this.addInstruction(new FadeOutOfSceneInstruction<T>(15, direction, link));
        }

        private static /* synthetic */ void lambda$changeBirbPose$1(Supplier pose, ParrotElement safeBirb) {
            safeBirb.setPose((ParrotPose)pose.get());
        }
    }

    @Environment(value=EnvType.CLIENT)
    public class PonderWorldInstructions
    implements WorldInstructions {
        @Override
        public class_7225.class_7874 getHolderLookupProvider() {
            return PonderSceneBuilder.this.scene.getWorld().method_30349();
        }

        @Override
        public void incrementBlockBreakingProgress(class_2338 pos) {
            PonderSceneBuilder.this.addInstruction(scene -> {
                PonderLevel world = scene.getWorld();
                int progress = world.getBlockBreakingProgressions().getOrDefault(pos, -1) + 1;
                if (progress == 9) {
                    world.addBlockDestroyEffects(pos, world.method_8320(pos));
                    world.method_22352(pos, false);
                    world.setBlockBreakingProgress(pos, 0);
                    scene.forEach(WorldSectionElement.class, WorldSectionElement::queueRedraw);
                } else {
                    world.setBlockBreakingProgress(pos, progress + 1);
                }
            });
        }

        @Override
        public void showSection(Selection selection, class_2350 fadeInDirection) {
            PonderSceneBuilder.this.addInstruction(new DisplayWorldSectionInstruction(15, fadeInDirection, selection, PonderSceneBuilder.this.scene::getBaseWorldSection));
        }

        @Override
        public void showSectionAndMerge(Selection selection, class_2350 fadeInDirection, ElementLink<WorldSectionElement> link) {
            PonderSceneBuilder.this.addInstruction(new DisplayWorldSectionInstruction(15, fadeInDirection, selection, () -> (WorldSectionElement)PonderSceneBuilder.this.scene.resolve(link)));
        }

        @Override
        public void glueBlockOnto(class_2338 position, class_2350 fadeInDirection, ElementLink<WorldSectionElement> link) {
            PonderSceneBuilder.this.addInstruction(new DisplayWorldSectionInstruction(15, fadeInDirection, PonderSceneBuilder.this.scene.getSceneBuildingUtil().select().position(position), () -> (WorldSectionElement)PonderSceneBuilder.this.scene.resolve(link), position));
        }

        @Override
        public ElementLink<WorldSectionElement> showIndependentSection(Selection selection, class_2350 fadeInDirection) {
            DisplayWorldSectionInstruction instruction = new DisplayWorldSectionInstruction(15, fadeInDirection, selection, null);
            PonderSceneBuilder.this.addInstruction(instruction);
            return instruction.createLink(PonderSceneBuilder.this.scene);
        }

        @Override
        public ElementLink<WorldSectionElement> showIndependentSectionImmediately(Selection selection) {
            DisplayWorldSectionInstruction instruction = new DisplayWorldSectionInstruction(0, class_2350.field_11033, selection, null);
            PonderSceneBuilder.this.addInstruction(instruction);
            return instruction.createLink(PonderSceneBuilder.this.scene);
        }

        @Override
        public void hideSection(Selection selection, class_2350 fadeOutDirection) {
            WorldSectionElementImpl worldSectionElement = new WorldSectionElementImpl(selection);
            ElementLinkImpl<WorldSectionElement> elementLink = new ElementLinkImpl<WorldSectionElement>(WorldSectionElement.class);
            PonderSceneBuilder.this.addInstruction(scene -> {
                scene.getBaseWorldSection().erase(selection);
                scene.linkElement(worldSectionElement, elementLink);
                scene.addElement(worldSectionElement);
                worldSectionElement.queueRedraw();
            });
            this.hideIndependentSection(elementLink, fadeOutDirection);
        }

        @Override
        public void hideIndependentSection(ElementLink<WorldSectionElement> link, class_2350 fadeOutDirection) {
            PonderSceneBuilder.this.addInstruction(new FadeOutOfSceneInstruction<WorldSectionElement>(15, fadeOutDirection, link));
        }

        @Override
        public void restoreBlocks(Selection selection) {
            PonderSceneBuilder.this.addInstruction(scene -> scene.getWorld().restoreBlocks(selection));
        }

        @Override
        public ElementLink<WorldSectionElement> makeSectionIndependent(Selection selection) {
            WorldSectionElementImpl worldSectionElement = new WorldSectionElementImpl(selection);
            ElementLinkImpl<WorldSectionElement> elementLink = new ElementLinkImpl<WorldSectionElement>(WorldSectionElement.class);
            PonderSceneBuilder.this.addInstruction(scene -> {
                scene.getBaseWorldSection().erase(selection);
                scene.linkElement(worldSectionElement, elementLink);
                scene.addElement(worldSectionElement);
                worldSectionElement.queueRedraw();
                worldSectionElement.resetAnimatedTransform();
                worldSectionElement.setVisible(true);
                worldSectionElement.forceApplyFade(1.0f);
            });
            return elementLink;
        }

        @Override
        public void rotateSection(ElementLink<WorldSectionElement> link, double xRotation, double yRotation, double zRotation, int duration) {
            PonderSceneBuilder.this.addInstruction(AnimateWorldSectionInstruction.rotate(link, new class_243(xRotation, yRotation, zRotation), duration));
        }

        @Override
        public void configureCenterOfRotation(ElementLink<WorldSectionElement> link, class_243 anchor) {
            PonderSceneBuilder.this.addInstruction(scene -> scene.resolveOptional(link).ifPresent(safe -> safe.setCenterOfRotation(anchor)));
        }

        @Override
        public void configureStabilization(ElementLink<WorldSectionElement> link, class_243 anchor) {
            PonderSceneBuilder.this.addInstruction(scene -> scene.resolveOptional(link).ifPresent(safe -> safe.stabilizeRotation(anchor)));
        }

        @Override
        public void moveSection(ElementLink<WorldSectionElement> link, class_243 offset, int duration) {
            PonderSceneBuilder.this.addInstruction(AnimateWorldSectionInstruction.move(link, offset, duration));
        }

        @Override
        public void setBlocks(Selection selection, class_2680 state, boolean spawnParticles) {
            PonderSceneBuilder.this.addInstruction(new ReplaceBlocksInstruction(selection, $ -> state, true, spawnParticles));
        }

        @Override
        public void destroyBlock(class_2338 pos) {
            this.setBlock(pos, class_2246.field_10124.method_9564(), true);
        }

        @Override
        public void setBlock(class_2338 pos, class_2680 state, boolean spawnParticles) {
            this.setBlocks(PonderSceneBuilder.this.scene.getSceneBuildingUtil().select().position(pos), state, spawnParticles);
        }

        @Override
        public void replaceBlocks(Selection selection, class_2680 state, boolean spawnParticles) {
            this.modifyBlocks(selection, $ -> state, spawnParticles);
        }

        @Override
        public void modifyBlock(class_2338 pos, UnaryOperator<class_2680> stateFunc, boolean spawnParticles) {
            this.modifyBlocks(PonderSceneBuilder.this.scene.getSceneBuildingUtil().select().position(pos), stateFunc, spawnParticles);
        }

        @Override
        public void cycleBlockProperty(class_2338 pos, class_2769<?> property) {
            this.modifyBlocks(PonderSceneBuilder.this.scene.getSceneBuildingUtil().select().position(pos), s -> s.method_28498(property) ? (class_2680)s.method_28493(property) : s, false);
        }

        @Override
        public void modifyBlocks(Selection selection, UnaryOperator<class_2680> stateFunc, boolean spawnParticles) {
            PonderSceneBuilder.this.addInstruction(new ReplaceBlocksInstruction(selection, stateFunc, false, spawnParticles));
        }

        @Override
        public void toggleRedstonePower(Selection selection) {
            this.modifyBlocks(selection, s -> {
                if (s.method_28498((class_2769)class_2741.field_12511)) {
                    s = (class_2680)s.method_11657((class_2769)class_2741.field_12511, (Comparable)Integer.valueOf((Integer)s.method_11654((class_2769)class_2741.field_12511) == 0 ? 15 : 0));
                }
                if (s.method_28498((class_2769)class_2741.field_12484)) {
                    s = (class_2680)s.method_28493((class_2769)class_2741.field_12484);
                }
                if (s.method_28498((class_2769)class_2459.field_11446)) {
                    s = (class_2680)s.method_28493((class_2769)class_2459.field_11446);
                }
                return s;
            }, false);
        }

        @Override
        public <T extends class_1297> void modifyEntities(Class<T> entityClass, Consumer<T> entityCallBack) {
            PonderSceneBuilder.this.addInstruction(scene -> scene.forEachWorldEntity(entityClass, entityCallBack));
        }

        @Override
        public <T extends class_1297> void modifyEntitiesInside(Class<T> entityClass, Selection area, Consumer<T> entityCallBack) {
            PonderSceneBuilder.this.addInstruction(scene -> scene.forEachWorldEntity(entityClass, e -> {
                if (area.test(e.method_24515())) {
                    entityCallBack.accept(e);
                }
            }));
        }

        @Override
        public void modifyEntity(ElementLink<EntityElement> link, Consumer<class_1297> entityCallBack) {
            PonderSceneBuilder.this.addInstruction(scene -> {
                EntityElement resolve = (EntityElement)scene.resolve(link);
                if (resolve != null) {
                    resolve.ifPresent(entityCallBack);
                }
            });
        }

        @Override
        public ElementLink<EntityElement> createEntity(Function<class_1937, class_1297> factory) {
            ElementLinkImpl<EntityElement> link = new ElementLinkImpl<EntityElement>(EntityElement.class, UUID.randomUUID());
            PonderSceneBuilder.this.addInstruction(scene -> {
                PonderLevel world = scene.getWorld();
                class_1297 entity = (class_1297)factory.apply(world);
                EntityElementImpl handle = new EntityElementImpl(entity);
                scene.addElement(handle);
                scene.linkElement(handle, link);
                world.method_8649(entity);
            });
            return link;
        }

        @Override
        public ElementLink<EntityElement> createItemEntity(class_243 location, class_243 motion, class_1799 stack) {
            return this.createEntity(world -> {
                class_1542 itemEntity = new class_1542(world, location.field_1352, location.field_1351, location.field_1350, stack);
                itemEntity.method_18799(motion);
                return itemEntity;
            });
        }

        @Override
        public void modifyBlockEntityNBT(Selection selection, Class<? extends class_2586> beType, Consumer<class_2487> consumer) {
            this.modifyBlockEntityNBT(selection, beType, consumer, false);
        }

        @Override
        public <T extends class_2586> void modifyBlockEntity(class_2338 position, Class<T> beType, Consumer<T> consumer) {
            PonderSceneBuilder.this.addInstruction(scene -> {
                class_2586 blockEntity = scene.getWorld().method_8321(position);
                if (beType.isInstance(blockEntity)) {
                    consumer.accept((class_2586)beType.cast(blockEntity));
                }
            });
        }

        @Override
        public void modifyBlockEntityNBT(Selection selection, Class<? extends class_2586> teType, Consumer<class_2487> consumer, boolean reDrawBlocks) {
            PonderSceneBuilder.this.addInstruction(new BlockEntityDataInstruction(selection, teType, nbt -> {
                consumer.accept((class_2487)nbt);
                return nbt;
            }, reDrawBlocks));
        }
    }

    @Environment(value=EnvType.CLIENT)
    public class PonderDebugInstructions
    implements DebugInstructions {
        @Override
        public void debugSchematic() {
            PonderSceneBuilder.this.addInstruction(scene -> scene.addElement(new WorldSectionElementImpl(scene.getSceneBuildingUtil().select().everywhere())));
        }

        @Override
        public void addInstructionInstance(PonderInstruction instruction) {
            PonderSceneBuilder.this.addInstruction(instruction);
        }

        @Override
        public void enqueueCallback(Consumer<PonderScene> callback) {
            PonderSceneBuilder.this.addInstruction(callback);
        }
    }

    @Environment(value=EnvType.CLIENT)
    public class PonderEffectInstructions
    implements EffectInstructions {
        @Override
        public void emitParticles(class_243 location, ParticleEmitter emitter, float amountPerCycle, int cycles) {
            PonderSceneBuilder.this.addInstruction(new EmitParticlesInstruction(location, emitter, amountPerCycle, cycles));
        }

        @Override
        public <T extends class_2394> ParticleEmitter simpleParticleEmitter(T data, class_243 motion) {
            return (w, x, y, z) -> w.method_8406(data, x, y, z, motion.field_1352, motion.field_1351, motion.field_1350);
        }

        @Override
        public <T extends class_2394> ParticleEmitter particleEmitterWithinBlockSpace(T data, class_243 motion) {
            return (w, x, y, z) -> w.method_8406(data, Math.floor(x) + (double)w.field_9229.method_43057(), Math.floor(y) + (double)w.field_9229.method_43057(), Math.floor(z) + (double)w.field_9229.method_43057(), motion.field_1352, motion.field_1351, motion.field_1350);
        }

        @Override
        public void indicateRedstone(class_2338 pos) {
            this.createRedstoneParticles(pos, 0xFF0000, 10);
        }

        @Override
        public void indicateSuccess(class_2338 pos) {
            this.createRedstoneParticles(pos, 8454058, 10);
        }

        @Override
        public void createRedstoneParticles(class_2338 pos, int color, int amount) {
            int rgb = new Color(color).getRGB();
            PonderSceneBuilder.this.addInstruction(new EmitParticlesInstruction(VecHelper.getCenterOf((class_2382)pos), PonderSceneBuilder.this.effects().particleEmitterWithinBlockSpace(new class_2390(rgb, 1.0f), class_243.field_1353), amount, 2));
        }
    }
}

