/*
 * Decompiled with CFR 0.152.
 */
package com.zurrtum.create.client.vanillin.visuals;

import com.zurrtum.create.client.flywheel.api.instance.Instance;
import com.zurrtum.create.client.flywheel.api.material.Material;
import com.zurrtum.create.client.flywheel.api.visual.DynamicVisual;
import com.zurrtum.create.client.flywheel.api.visual.SectionTrackedVisual;
import com.zurrtum.create.client.flywheel.api.visualization.VisualizationContext;
import com.zurrtum.create.client.flywheel.lib.material.CutoutShaders;
import com.zurrtum.create.client.flywheel.lib.material.SimpleMaterial;
import com.zurrtum.create.client.flywheel.lib.model.part.InstanceTree;
import com.zurrtum.create.client.flywheel.lib.model.part.ModelTrees;
import com.zurrtum.create.client.flywheel.lib.visual.AbstractBlockEntityVisual;
import com.zurrtum.create.client.flywheel.lib.visual.SimpleDynamicVisual;
import it.unimi.dsi.fastutil.floats.Float2FloatFunction;
import it.unimi.dsi.fastutil.longs.LongSet;
import java.util.Calendar;
import java.util.EnumMap;
import java.util.Map;
import java.util.function.Consumer;
import net.fabricmc.api.EnvType;
import net.fabricmc.api.Environment;
import net.minecraft.class_11959;
import net.minecraft.class_1920;
import net.minecraft.class_2248;
import net.minecraft.class_2281;
import net.minecraft.class_2338;
import net.minecraft.class_2350;
import net.minecraft.class_2586;
import net.minecraft.class_2595;
import net.minecraft.class_2618;
import net.minecraft.class_2745;
import net.minecraft.class_2769;
import net.minecraft.class_310;
import net.minecraft.class_4076;
import net.minecraft.class_4722;
import net.minecraft.class_4730;
import net.minecraft.class_4732;
import net.minecraft.class_4739;
import net.minecraft.class_5601;
import net.minecraft.class_5602;
import net.minecraft.class_761;
import net.minecraft.class_765;
import net.minecraft.class_826;
import org.jetbrains.annotations.Nullable;
import org.joml.Matrix4f;
import org.joml.Matrix4fc;

@Environment(value=EnvType.CLIENT)
public class ChestVisual<T extends class_2586>
extends AbstractBlockEntityVisual<T>
implements SimpleDynamicVisual {
    private static final Material MATERIAL = SimpleMaterial.builder().cutout(CutoutShaders.ONE_TENTH).texture(class_4722.field_21709).mipmap(false).build();
    private static final Map<class_2745, class_5601> LAYER_LOCATIONS = new EnumMap<class_2745, class_5601>(class_2745.class);
    @Nullable
    private final InstanceTree instances;
    @Nullable
    private final InstanceTree lid;
    @Nullable
    private final InstanceTree lock;
    @Nullable
    private final Matrix4fc initialPose;
    private final BrightnessCombiner brightnessCombiner = new BrightnessCombiner();
    @Nullable
    private final class_4732.class_4734<? extends class_2595> neighborCombineResult;
    @Nullable
    private final Float2FloatFunction lidProgress;
    private float lastProgress = Float.NaN;

    public ChestVisual(VisualizationContext ctx, T blockEntity, float partialTick) {
        super(ctx, blockEntity, partialTick);
        class_2248 block = this.blockState.method_26204();
        if (block instanceof class_4739) {
            class_4739 chestBlock = (class_4739)block;
            class_2745 chestType = this.blockState.method_28498((class_2769)class_2281.field_10770) ? (class_2745)this.blockState.method_11654((class_2769)class_2281.field_10770) : class_2745.field_12569;
            class_826 renderer = (class_826)class_310.method_1551().method_31975().method_3550(blockEntity);
            class_4730 texture = class_4722.method_24062((class_11959.class_11960)renderer.method_74366(blockEntity, ChestVisual.isChristmas()), (class_2745)chestType);
            this.instances = InstanceTree.create(this.instancerProvider(), ModelTrees.of(LAYER_LOCATIONS.get(chestType), texture, MATERIAL));
            this.lid = this.instances.childOrThrow("lid");
            this.lock = this.instances.childOrThrow("lock");
            this.initialPose = this.createInitialPose();
            this.neighborCombineResult = chestBlock.method_24167(this.blockState, this.level, this.pos, true);
            this.lidProgress = (Float2FloatFunction)this.neighborCombineResult.apply(class_2281.method_24166((class_2618)((class_2618)blockEntity)));
            this.lastProgress = this.lidProgress.get(partialTick);
            this.applyLidTransform(this.lastProgress);
        } else {
            this.instances = null;
            this.lid = null;
            this.lock = null;
            this.initialPose = null;
            this.neighborCombineResult = null;
            this.lidProgress = null;
        }
    }

    private static boolean isChristmas() {
        Calendar calendar = Calendar.getInstance();
        return calendar.get(2) + 1 == 12 && calendar.get(5) >= 24 && calendar.get(5) <= 26;
    }

    private Matrix4f createInitialPose() {
        class_2338 visualPos = this.getVisualPosition();
        float horizontalAngle = ((class_2350)this.blockState.method_11654((class_2769)class_2281.field_10768)).method_10144();
        return new Matrix4f().translate((float)visualPos.method_10263(), (float)visualPos.method_10264(), (float)visualPos.method_10260()).translate(0.5f, 0.5f, 0.5f).rotateY(-horizontalAngle * ((float)Math.PI / 180)).translate(-0.5f, -0.5f, -0.5f);
    }

    @Override
    public void setSectionCollector(SectionTrackedVisual.SectionCollector sectionCollector) {
        this.lightSections = sectionCollector;
        if (this.neighborCombineResult != null) {
            this.lightSections.sections((LongSet)this.neighborCombineResult.apply((class_4732.class_3923)new SectionPosCombiner()));
        } else {
            this.lightSections.sections(LongSet.of((long)class_4076.method_33706((class_2338)this.pos)));
        }
    }

    @Override
    public void beginFrame(DynamicVisual.Context context) {
        if (this.instances == null) {
            return;
        }
        if (this.doDistanceLimitThisFrame(context) || !this.isVisible(context.frustum())) {
            return;
        }
        float progress = this.lidProgress.get(context.partialTick());
        if (this.lastProgress == progress) {
            return;
        }
        this.lastProgress = progress;
        this.applyLidTransform(progress);
    }

    private void applyLidTransform(float progress) {
        progress = 1.0f - progress;
        progress = 1.0f - progress * progress * progress;
        this.lid.xRot(-(progress * 1.5707964f));
        this.lock.xRot(this.lid.xRot());
        this.instances.updateInstancesStatic(this.initialPose);
    }

    @Override
    public void updateLight(float partialTick) {
        if (this.instances != null) {
            int packedLight = (Integer)this.neighborCombineResult.apply((class_4732.class_3923)this.brightnessCombiner);
            this.instances.traverse(instance -> instance.light(packedLight).setChanged());
        }
    }

    @Override
    public void collectCrumblingInstances(Consumer<Instance> consumer) {
        if (this.instances != null) {
            this.instances.traverse(consumer);
        }
    }

    @Override
    protected void _delete() {
        if (this.instances != null) {
            this.instances.delete();
        }
    }

    static {
        LAYER_LOCATIONS.put(class_2745.field_12569, class_5602.field_27689);
        LAYER_LOCATIONS.put(class_2745.field_12574, class_5602.field_27551);
        LAYER_LOCATIONS.put(class_2745.field_12571, class_5602.field_27552);
    }

    @Environment(value=EnvType.CLIENT)
    private class BrightnessCombiner
    implements class_4732.class_3923<class_2586, Integer> {
        private BrightnessCombiner() {
        }

        public Integer getFromBoth(class_2586 first, class_2586 second) {
            int firstLight = class_761.method_23794((class_1920)first.method_10997(), (class_2338)first.method_11016());
            int secondLight = class_761.method_23794((class_1920)second.method_10997(), (class_2338)second.method_11016());
            int firstBlockLight = class_765.method_24186((int)firstLight);
            int secondBlockLight = class_765.method_24186((int)secondLight);
            int firstSkyLight = class_765.method_24187((int)firstLight);
            int secondSkyLight = class_765.method_24187((int)secondLight);
            return class_765.method_23687((int)Math.max(firstBlockLight, secondBlockLight), (int)Math.max(firstSkyLight, secondSkyLight));
        }

        public Integer getFrom(class_2586 single) {
            return class_761.method_23794((class_1920)single.method_10997(), (class_2338)single.method_11016());
        }

        public Integer getFallback() {
            return class_761.method_23794((class_1920)ChestVisual.this.level, (class_2338)ChestVisual.this.pos);
        }
    }

    @Environment(value=EnvType.CLIENT)
    private class SectionPosCombiner
    implements class_4732.class_3923<class_2586, LongSet> {
        private SectionPosCombiner() {
        }

        public LongSet getFromBoth(class_2586 first, class_2586 second) {
            long secondSection;
            long firstSection = class_4076.method_33706((class_2338)first.method_11016());
            if (firstSection == (secondSection = class_4076.method_33706((class_2338)second.method_11016()))) {
                return LongSet.of((long)firstSection);
            }
            return LongSet.of((long)firstSection, (long)secondSection);
        }

        public LongSet getFrom(class_2586 single) {
            return LongSet.of((long)class_4076.method_33706((class_2338)single.method_11016()));
        }

        public LongSet getFallback() {
            return LongSet.of((long)class_4076.method_33706((class_2338)ChestVisual.this.pos));
        }
    }
}

