/*
 * Decompiled with CFR 0.152.
 */
package com.zurrtum.create.content.contraptions.actors.roller;

import com.zurrtum.create.AllBlockEntityTypes;
import com.zurrtum.create.catnip.data.Iterate;
import com.zurrtum.create.content.contraptions.actors.roller.RollerBlock;
import com.zurrtum.create.content.contraptions.actors.roller.RollerMovementBehaviour;
import com.zurrtum.create.foundation.blockEntity.SmartBlockEntity;
import com.zurrtum.create.foundation.blockEntity.behaviour.BlockEntityBehaviour;
import com.zurrtum.create.foundation.blockEntity.behaviour.filtering.ServerFilteringBehaviour;
import com.zurrtum.create.foundation.blockEntity.behaviour.scrollValue.ServerScrollOptionBehaviour;
import java.util.List;
import net.minecraft.class_1799;
import net.minecraft.class_1922;
import net.minecraft.class_2338;
import net.minecraft.class_2343;
import net.minecraft.class_2350;
import net.minecraft.class_238;
import net.minecraft.class_2510;
import net.minecraft.class_2586;
import net.minecraft.class_259;
import net.minecraft.class_265;
import net.minecraft.class_2680;
import net.minecraft.class_2769;

public class RollerBlockEntity
extends SmartBlockEntity {
    private float manuallyAnimatedSpeed;
    public ServerFilteringBehaviour filtering;
    public ServerScrollOptionBehaviour<RollingMode> mode;
    private boolean dontPropagate = false;

    public RollerBlockEntity(class_2338 pos, class_2680 state) {
        super(AllBlockEntityTypes.MECHANICAL_ROLLER, pos, state);
    }

    @Override
    public void addBehaviours(List<BlockEntityBehaviour<?>> behaviours) {
        this.filtering = new ServerFilteringBehaviour(this);
        behaviours.add(this.filtering);
        this.mode = new ServerScrollOptionBehaviour<RollingMode>(RollingMode.class, this);
        behaviours.add(this.mode);
        this.filtering.withCallback(this::onFilterChanged);
        this.filtering.withPredicate(this::isValidMaterial);
        this.mode.withCallback(this::onModeChanged);
    }

    protected void onModeChanged(int mode) {
        this.shareValuesToAdjacent();
    }

    protected void onFilterChanged(class_1799 newFilter) {
        this.shareValuesToAdjacent();
    }

    protected boolean isValidMaterial(class_1799 newFilter) {
        if (newFilter.method_7960()) {
            return true;
        }
        class_2680 appliedState = RollerMovementBehaviour.getStateToPaveWith(newFilter);
        if (appliedState.method_26215()) {
            return false;
        }
        if (appliedState.method_26204() instanceof class_2343) {
            return false;
        }
        if (appliedState.method_26204() instanceof class_2510) {
            return false;
        }
        class_265 shape = appliedState.method_26218((class_1922)this.field_11863, this.field_11867);
        if (shape.method_1110() || !shape.method_1107().equals((Object)class_259.method_1077().method_1107())) {
            return false;
        }
        class_265 collisionShape = appliedState.method_26220((class_1922)this.field_11863, this.field_11867);
        return !collisionShape.method_1110();
    }

    @Override
    protected class_238 createRenderBoundingBox() {
        return new class_238(this.field_11867).method_1014(1.0);
    }

    public float getAnimatedSpeed() {
        return this.manuallyAnimatedSpeed;
    }

    public void setAnimatedSpeed(float speed) {
        this.manuallyAnimatedSpeed = speed;
    }

    public void searchForSharedValues() {
        class_2680 blockState = this.method_11010();
        class_2350 facing = (class_2350)blockState.method_61767((class_2769)RollerBlock.field_11177, (Comparable)class_2350.field_11035);
        for (int side : Iterate.positiveAndNegative) {
            class_2586 class_25862;
            class_2338 pos = this.field_11867.method_10079(facing.method_10170(), side);
            if (this.field_11863.method_8320(pos) != blockState || !((class_25862 = this.field_11863.method_8321(pos)) instanceof RollerBlockEntity)) continue;
            RollerBlockEntity otherRoller = (RollerBlockEntity)class_25862;
            this.acceptSharedValues(otherRoller.mode.getValue(), otherRoller.filtering.getFilter());
            this.shareValuesToAdjacent();
            break;
        }
    }

    protected void acceptSharedValues(int mode, class_1799 filter) {
        this.dontPropagate = true;
        this.filtering.setFilter(filter.method_7972());
        this.mode.setValue(mode);
        this.dontPropagate = false;
        this.notifyUpdate();
    }

    public void shareValuesToAdjacent() {
        if (this.dontPropagate || this.field_11863.method_8608()) {
            return;
        }
        class_2680 blockState = this.method_11010();
        class_2350 facing = (class_2350)blockState.method_61767((class_2769)RollerBlock.field_11177, (Comparable)class_2350.field_11035);
        for (int side : Iterate.positiveAndNegative) {
            class_2586 class_25862;
            class_2338 pos;
            for (int i = 1; i < 100 && this.field_11863.method_8320(pos = this.field_11867.method_10079(facing.method_10170(), side * i)) == blockState && (class_25862 = this.field_11863.method_8321(pos)) instanceof RollerBlockEntity; ++i) {
                RollerBlockEntity otherRoller = (RollerBlockEntity)class_25862;
                otherRoller.acceptSharedValues(this.mode.getValue(), this.filtering.getFilter());
            }
        }
    }

    public static enum RollingMode {
        TUNNEL_PAVE,
        STRAIGHT_FILL,
        WIDE_FILL;

    }
}

