/*
 * Decompiled with CFR 0.152.
 */
package com.zurrtum.create.content.logistics.packager;

import com.google.common.collect.Lists;
import com.mojang.serialization.Codec;
import com.zurrtum.create.content.logistics.BigItemStack;
import com.zurrtum.create.infrastructure.packet.s2c.LogisticalStockResponsePacket;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.IdentityHashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.function.Predicate;
import net.minecraft.class_1792;
import net.minecraft.class_1799;
import net.minecraft.class_2338;
import net.minecraft.class_2596;
import net.minecraft.class_3222;
import org.apache.commons.lang3.mutable.MutableInt;

public class InventorySummary {
    public static Codec<InventorySummary> CODEC = BigItemStack.CODEC.listOf().xmap(i -> {
        InventorySummary summary = new InventorySummary();
        summary.addAllBigItemStacks((List<BigItemStack>)i);
        return summary;
    }, i -> {
        ArrayList all = new ArrayList();
        i.items.forEach((key, list) -> all.addAll(list));
        return all;
    });
    public static final InventorySummary EMPTY = new InventorySummary();
    private Map<class_1792, List<BigItemStack>> items = new IdentityHashMap<class_1792, List<BigItemStack>>();
    private List<BigItemStack> stacksByCount;
    private int totalCount;
    public int contributingLinks;

    public void add(InventorySummary summary) {
        summary.items.forEach((i, list) -> list.forEach(this::add));
        this.contributingLinks += summary.contributingLinks;
    }

    public void add(class_1799 stack) {
        this.add(stack, stack.method_7947());
    }

    public void add(BigItemStack entry) {
        this.add(entry.stack, entry.count);
    }

    public Map<class_1792, List<BigItemStack>> getItemMap() {
        return this.items;
    }

    public void addAllItemStacks(List<class_1799> list) {
        for (class_1799 stack : list) {
            this.add(stack, stack.method_7947());
        }
    }

    public void addAllBigItemStacks(List<BigItemStack> list) {
        for (BigItemStack entry : list) {
            this.add(entry.stack, entry.count);
        }
    }

    public InventorySummary copy() {
        InventorySummary inventorySummary = new InventorySummary();
        this.items.forEach((i, list) -> list.forEach(entry -> inventorySummary.add(entry.stack, entry.count)));
        return inventorySummary;
    }

    public void add(class_1799 stack, int count) {
        if (count == 0 || stack.method_7960()) {
            return;
        }
        if (this.totalCount < 1000000000) {
            this.totalCount += count;
        }
        List stacks = this.items.computeIfAbsent(stack.method_7909(), $ -> Lists.newArrayList());
        for (BigItemStack existing : stacks) {
            class_1799 existingStack = existing.stack;
            if (!class_1799.method_31577((class_1799)existingStack, (class_1799)stack)) continue;
            if (existing.count < 1000000000) {
                existing.count += count;
            }
            return;
        }
        if (stack.method_7947() > stack.method_7914()) {
            stack = stack.method_46651(1);
        }
        BigItemStack newEntry = new BigItemStack(stack, count);
        stacks.add(newEntry);
    }

    public boolean erase(class_1799 stack) {
        List<BigItemStack> stacks = this.items.get(stack.method_7909());
        if (stacks == null) {
            return false;
        }
        Iterator<BigItemStack> iterator = stacks.iterator();
        while (iterator.hasNext()) {
            BigItemStack existing = iterator.next();
            class_1799 existingStack = existing.stack;
            if (!class_1799.method_31577((class_1799)existingStack, (class_1799)stack)) continue;
            this.totalCount -= existing.count;
            iterator.remove();
            return true;
        }
        return false;
    }

    public int getCountOf(class_1799 stack) {
        List<BigItemStack> list = this.items.get(stack.method_7909());
        if (list == null) {
            return 0;
        }
        for (BigItemStack entry : list) {
            if (!class_1799.method_31577((class_1799)entry.stack, (class_1799)stack)) continue;
            return entry.count;
        }
        return 0;
    }

    public int getTotalOfMatching(Predicate<class_1799> filter) {
        MutableInt sum = new MutableInt();
        this.items.forEach(($, list) -> {
            for (BigItemStack entry : list) {
                if (!filter.test(entry.stack)) continue;
                sum.add(entry.count);
            }
        });
        return sum.getValue();
    }

    public List<BigItemStack> getStacks() {
        if (this.stacksByCount == null) {
            ArrayList<BigItemStack> stacks = new ArrayList<BigItemStack>();
            this.items.forEach((i, list) -> stacks.addAll((Collection<BigItemStack>)list));
            return stacks;
        }
        return this.stacksByCount;
    }

    public List<BigItemStack> getStacksByCount() {
        if (this.stacksByCount == null) {
            this.stacksByCount = new ArrayList<BigItemStack>();
            this.items.forEach((i, list) -> this.stacksByCount.addAll((Collection<BigItemStack>)list));
            this.stacksByCount.sort(BigItemStack.comparator());
        }
        return this.stacksByCount;
    }

    public int getTotalCount() {
        return this.totalCount;
    }

    public void divideAndSendTo(class_3222 player, class_2338 pos) {
        List<BigItemStack> stacks = this.getStacksByCount();
        int remaining = stacks.size();
        ArrayList<BigItemStack> currentList = null;
        if (stacks.isEmpty()) {
            player.field_13987.method_14364((class_2596)new LogisticalStockResponsePacket(true, pos, Collections.emptyList()));
        }
        for (BigItemStack entry : stacks) {
            if (currentList == null) {
                currentList = new ArrayList<BigItemStack>(Math.min(100, remaining));
            }
            currentList.add(entry);
            if (--remaining == 0) break;
            if (currentList.size() < 100) continue;
            player.field_13987.method_14364((class_2596)new LogisticalStockResponsePacket(false, pos, currentList));
            currentList = null;
        }
        if (currentList != null) {
            player.field_13987.method_14364((class_2596)new LogisticalStockResponsePacket(true, pos, (List<BigItemStack>)currentList));
        }
    }

    public boolean isEmpty() {
        return this.items.isEmpty();
    }
}

