/*
 * Decompiled with CFR 0.152.
 */
package com.zurrtum.create.content.logistics.tunnel;

import com.mojang.datafixers.util.Pair;
import com.mojang.serialization.Codec;
import com.zurrtum.create.AllBlockEntityTypes;
import com.zurrtum.create.AllClientHandle;
import com.zurrtum.create.catnip.animation.LerpedFloat;
import com.zurrtum.create.catnip.data.Iterate;
import com.zurrtum.create.content.logistics.funnel.BeltFunnelBlock;
import com.zurrtum.create.content.logistics.tunnel.BeltTunnelBlock;
import com.zurrtum.create.foundation.blockEntity.SmartBlockEntity;
import com.zurrtum.create.foundation.blockEntity.behaviour.BlockEntityBehaviour;
import com.zurrtum.create.infrastructure.packet.s2c.TunnelFlapPacket;
import java.util.EnumMap;
import java.util.HashSet;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import java.util.Set;
import net.minecraft.class_11368;
import net.minecraft.class_11372;
import net.minecraft.class_1263;
import net.minecraft.class_1923;
import net.minecraft.class_1937;
import net.minecraft.class_2338;
import net.minecraft.class_2350;
import net.minecraft.class_2591;
import net.minecraft.class_2596;
import net.minecraft.class_2680;
import net.minecraft.class_2741;
import net.minecraft.class_2769;
import net.minecraft.class_3218;
import net.minecraft.class_3222;

public class BeltTunnelBlockEntity
extends SmartBlockEntity {
    public Map<class_2350, LerpedFloat> flaps = new EnumMap<class_2350, LerpedFloat>(class_2350.class);
    public Set<class_2350> sides = new HashSet<class_2350>();
    public class_1263 cap = null;
    protected List<Pair<class_2350, Boolean>> flapsToSend = new LinkedList<Pair<class_2350, Boolean>>();

    public BeltTunnelBlockEntity(class_2591<?> type, class_2338 pos, class_2680 state) {
        super(type, pos, state);
    }

    public static BeltTunnelBlockEntity andesite(class_2338 pos, class_2680 state) {
        return new BeltTunnelBlockEntity(AllBlockEntityTypes.ANDESITE_TUNNEL, pos, state);
    }

    protected void writeFlapsAndSides(class_11372 view) {
        class_11372.class_11373 flapsList = view.method_71467("Flaps", (Codec)class_2350.field_29502);
        for (class_2350 direction : this.flaps.keySet()) {
            flapsList.method_71484((Object)direction);
        }
        class_11372.class_11373 sidesList = view.method_71467("Sides", (Codec)class_2350.field_29502);
        for (class_2350 direction : this.sides) {
            sidesList.method_71484((Object)direction);
        }
    }

    @Override
    public void writeSafe(class_11372 view) {
        this.writeFlapsAndSides(view);
        super.writeSafe(view);
    }

    @Override
    public void write(class_11372 view, boolean clientPacket) {
        this.writeFlapsAndSides(view);
        super.write(view, clientPacket);
    }

    @Override
    protected void read(class_11368 view, boolean clientPacket) {
        HashSet<class_2350> newFlaps = new HashSet<class_2350>(6);
        class_11368.class_11369 flapsList = view.method_71437("Flaps", (Codec)class_2350.field_29502);
        for (class_2350 direction : flapsList) {
            newFlaps.add(direction);
        }
        this.sides.clear();
        class_11368.class_11369 sidesList = view.method_71437("Sides", (Codec)class_2350.field_29502);
        for (class_2350 direction : sidesList) {
            this.sides.add(direction);
        }
        for (class_2350 d : Iterate.directions) {
            if (!newFlaps.contains(d)) {
                this.flaps.remove(d);
                continue;
            }
            if (this.flaps.containsKey(d)) continue;
            this.flaps.put(d, this.createChasingFlap());
        }
        super.read(view, clientPacket);
        if (clientPacket) {
            AllClientHandle.INSTANCE.queueUpdate(this);
        }
    }

    private LerpedFloat createChasingFlap() {
        return LerpedFloat.linear().startWithValue(0.25).chase(0.0, 0.05f, LerpedFloat.Chaser.EXP);
    }

    public void updateTunnelConnections() {
        this.flaps.clear();
        this.sides.clear();
        class_2680 tunnelState = this.method_11010();
        for (class_2350 direction : Iterate.horizontalDirections) {
            class_2680 nextState;
            if (direction.method_10166() != tunnelState.method_11654((class_2769)class_2741.field_12529)) {
                boolean positive = direction.method_10171() == class_2350.class_2352.field_11056 ^ direction.method_10166() == class_2350.class_2351.field_11051;
                BeltTunnelBlock.Shape shape = (BeltTunnelBlock.Shape)((Object)tunnelState.method_11654(BeltTunnelBlock.SHAPE));
                if (BeltTunnelBlock.isStraight(tunnelState) || positive && shape == BeltTunnelBlock.Shape.T_LEFT || !positive && shape == BeltTunnelBlock.Shape.T_RIGHT) continue;
            }
            this.sides.add(direction);
            if (this.field_11863 == null || (nextState = this.field_11863.method_8320(this.field_11867.method_10093(direction))).method_26204() instanceof BeltTunnelBlock || nextState.method_26204() instanceof BeltFunnelBlock && nextState.method_11654(BeltFunnelBlock.SHAPE) == BeltFunnelBlock.Shape.EXTENDED && nextState.method_11654((class_2769)BeltFunnelBlock.HORIZONTAL_FACING) == direction.method_10153()) continue;
            this.flaps.put(direction, this.createChasingFlap());
        }
        this.sendData();
    }

    public void flap(class_2350 side, boolean inward) {
        if (this.field_11863.method_8608()) {
            if (this.flaps.containsKey(side)) {
                this.flaps.get(side).setValue(inward ? -1.0 : 1.0);
            }
            return;
        }
        this.flapsToSend.add((Pair<class_2350, Boolean>)Pair.of((Object)side, (Object)inward));
    }

    @Override
    public void initialize() {
        super.initialize();
        this.updateTunnelConnections();
    }

    @Override
    public void tick() {
        super.tick();
        if (!this.field_11863.method_8608()) {
            if (!this.flapsToSend.isEmpty()) {
                this.sendFlaps();
            }
            return;
        }
        this.flaps.forEach((d, value) -> value.tickChaser());
    }

    private void sendFlaps() {
        class_1937 class_19372 = this.field_11863;
        if (class_19372 instanceof class_3218) {
            class_3218 serverLevel = (class_3218)class_19372;
            TunnelFlapPacket packet = new TunnelFlapPacket(this, this.flapsToSend);
            for (class_3222 player : serverLevel.method_14178().field_17254.method_17210(new class_1923(this.field_11867), false)) {
                player.field_13987.method_14364((class_2596)packet);
            }
        }
        this.flapsToSend.clear();
    }

    @Override
    public void addBehaviours(List<BlockEntityBehaviour<?>> behaviours) {
    }
}

