/*
 * Decompiled with CFR 0.152.
 */
package com.zurrtum.create.content.processing.basin;

import com.zurrtum.create.Create;
import com.zurrtum.create.content.kinetics.base.KineticBlockEntity;
import com.zurrtum.create.content.processing.basin.BasinBlockEntity;
import com.zurrtum.create.content.processing.basin.BasinInput;
import com.zurrtum.create.content.processing.basin.BasinRecipe;
import com.zurrtum.create.foundation.advancement.CreateTrigger;
import com.zurrtum.create.foundation.blockEntity.behaviour.BlockEntityBehaviour;
import com.zurrtum.create.foundation.blockEntity.behaviour.simple.DeferralBehaviour;
import com.zurrtum.create.foundation.recipe.RecipeFinder;
import com.zurrtum.create.foundation.recipe.trie.AbstractVariant;
import com.zurrtum.create.foundation.recipe.trie.RecipeTrie;
import com.zurrtum.create.foundation.recipe.trie.RecipeTrieFinder;
import java.lang.runtime.SwitchBootstraps;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.Set;
import java.util.function.Consumer;
import net.minecraft.class_1860;
import net.minecraft.class_1867;
import net.minecraft.class_1869;
import net.minecraft.class_2338;
import net.minecraft.class_2586;
import net.minecraft.class_2591;
import net.minecraft.class_2680;
import net.minecraft.class_3218;
import net.minecraft.class_8786;

public abstract class BasinOperatingBlockEntity
extends KineticBlockEntity {
    public DeferralBehaviour basinChecker;
    public boolean basinRemoved;
    protected class_1860<?> currentRecipe;
    private final BasinRecipeFinder finder = new BasinRecipeFinder();

    public BasinOperatingBlockEntity(class_2591<?> typeIn, class_2338 pos, class_2680 state) {
        super(typeIn, pos, state);
    }

    @Override
    public void addBehaviours(List<BlockEntityBehaviour<?>> behaviours) {
        super.addBehaviours(behaviours);
        this.basinChecker = new DeferralBehaviour(this, this::updateBasin);
        behaviours.add(this.basinChecker);
    }

    @Override
    public void onSpeedChanged(float prevSpeed) {
        super.onSpeedChanged(prevSpeed);
        this.basinRemoved = false;
        this.basinChecker.scheduleUpdate();
    }

    @Override
    public void tick() {
        if (this.basinRemoved) {
            this.basinRemoved = false;
            this.onBasinRemoved();
            this.sendData();
            return;
        }
        super.tick();
    }

    protected boolean updateBasin() {
        if (!this.isSpeedRequirementFulfilled()) {
            return true;
        }
        if (this.getSpeed() == 0.0f) {
            return true;
        }
        if (this.isRunning()) {
            return true;
        }
        if (this.field_11863 == null || this.field_11863.method_8608()) {
            return true;
        }
        Optional<BasinBlockEntity> basin = this.getBasin();
        if (basin.filter(BasinBlockEntity::canContinueProcessing).isEmpty()) {
            return true;
        }
        class_1860<?> recipe = this.getMatchingRecipes();
        if (recipe == null) {
            return true;
        }
        this.currentRecipe = recipe;
        this.startProcessingBasin();
        this.sendData();
        return true;
    }

    protected abstract boolean isRunning();

    public void startProcessingBasin() {
    }

    public boolean continueWithPreviousRecipe() {
        return true;
    }

    protected boolean matchBasinRecipe(class_1860<?> recipe) {
        if (recipe == null) {
            return false;
        }
        return this.getBasin().map(blockEntity -> {
            class_1860 class_18602 = recipe;
            Objects.requireNonNull(class_18602);
            class_1860 selector0$temp = class_18602;
            int index$1 = 0;
            return switch (SwitchBootstraps.typeSwitch("typeSwitch", new Object[]{BasinRecipe.class, class_1869.class, class_1867.class}, (Object)selector0$temp, index$1)) {
                case 0 -> {
                    BasinRecipe basinRecipe = (BasinRecipe)selector0$temp;
                    yield basinRecipe.method_8115(new BasinInput((BasinBlockEntity)blockEntity), this.field_11863);
                }
                case 1 -> {
                    class_1869 shapedRecipe = (class_1869)selector0$temp;
                    yield BasinRecipe.matchCraftingRecipe(new BasinInput((BasinBlockEntity)blockEntity), shapedRecipe, this.field_11863);
                }
                case 2 -> {
                    class_1867 shapelessRecipe = (class_1867)selector0$temp;
                    yield BasinRecipe.matchCraftingRecipe(new BasinInput((BasinBlockEntity)blockEntity), shapelessRecipe, this.field_11863);
                }
                default -> false;
            };
        }).orElse(false);
    }

    protected void applyBasinRecipe() {
        if (this.currentRecipe == null) {
            return;
        }
        Optional<BasinBlockEntity> optionalBasin = this.getBasin();
        if (optionalBasin.isEmpty()) {
            return;
        }
        BasinBlockEntity basin = optionalBasin.get();
        boolean wasEmpty = basin.canContinueProcessing();
        class_1860<?> class_18602 = this.currentRecipe;
        Objects.requireNonNull(class_18602);
        class_1860<?> class_18603 = class_18602;
        int n = 0;
        switch (SwitchBootstraps.typeSwitch("typeSwitch", new Object[]{BasinRecipe.class, class_1869.class, class_1867.class}, class_18603, n)) {
            case 0: {
                BasinRecipe basinRecipe = (BasinRecipe)class_18603;
                if (basinRecipe.apply(new BasinInput(basin))) break;
                return;
            }
            case 1: {
                class_1869 shapedRecipe = (class_1869)class_18603;
                if (BasinRecipe.applyCraftingRecipe(new BasinInput(basin), shapedRecipe, this.field_11863)) break;
                return;
            }
            case 2: {
                class_1867 shapelessRecipe = (class_1867)class_18603;
                if (BasinRecipe.applyCraftingRecipe(new BasinInput(basin), shapelessRecipe, this.field_11863)) break;
                return;
            }
            default: {
                return;
            }
        }
        this.getProcessedRecipeTrigger().ifPresent(this::award);
        basin.inputTank.sendDataImmediately();
        if (wasEmpty && this.matchBasinRecipe(this.currentRecipe)) {
            this.continueWithPreviousRecipe();
            this.sendData();
        }
        basin.notifyChangeOfContents();
    }

    protected class_1860<?> getMatchingRecipes() {
        BasinBlockEntity basin;
        Optional<BasinBlockEntity> $basin = this.getBasin();
        if ($basin.isEmpty() || (basin = $basin.get()).isEmpty()) {
            return null;
        }
        if (basin.itemCapability == null && basin.fluidCapability == null) {
            return null;
        }
        try {
            RecipeTrie<class_1860<?>> trie = RecipeTrieFinder.get(this.getRecipeCacheKey(), (class_3218)this.field_11863, this::matchStaticFilters);
            Set<AbstractVariant> availableVariants = RecipeTrie.getVariants(basin.itemCapability, basin.fluidCapability);
            return this.finder.match(basin, trie.lookup(availableVariants));
        }
        catch (Exception e) {
            Create.LOGGER.error("Failed to get recipe trie, falling back to slow logic", (Throwable)e);
            List<class_8786<class_1860<?>>> recipes = RecipeFinder.get(this.getRecipeCacheKey(), (class_3218)this.field_11863, this::matchStaticFilters);
            if (recipes.isEmpty()) {
                return null;
            }
            return this.finder.matchEntry(basin, recipes);
        }
    }

    protected abstract void onBasinRemoved();

    protected Optional<BasinBlockEntity> getBasin() {
        if (this.field_11863 == null) {
            return Optional.empty();
        }
        class_2586 basinBE = this.field_11863.method_8321(this.field_11867.method_10087(2));
        if (!(basinBE instanceof BasinBlockEntity)) {
            return Optional.empty();
        }
        return Optional.of((BasinBlockEntity)basinBE);
    }

    protected Optional<CreateTrigger> getProcessedRecipeTrigger() {
        return Optional.empty();
    }

    protected abstract boolean matchStaticFilters(class_8786<? extends class_1860<?>> var1);

    protected abstract Object getRecipeCacheKey();

    private class BasinRecipeFinder {
        private BasinInput basinInput;
        private Consumer<class_1860<?>> matchingStrategy;
        private class_1860<?> matchedRecipe;
        private int ingredientCount;

        private BasinRecipeFinder() {
        }

        public class_1860<?> match(BasinBlockEntity basin, List<class_1860<?>> recipes) {
            this.matchedRecipe = null;
            this.matchingStrategy = this::firstMatchStrategy;
            this.basinInput = new BasinInput(basin);
            for (class_1860<?> recipe : recipes) {
                this.matchingStrategy.accept(recipe);
            }
            return this.matchedRecipe;
        }

        public class_1860<?> matchEntry(BasinBlockEntity basin, List<class_8786<? extends class_1860<?>>> recipes) {
            this.matchedRecipe = null;
            this.matchingStrategy = this::firstMatchStrategy;
            this.basinInput = new BasinInput(basin);
            for (class_8786<class_1860<?>> class_87862 : recipes) {
                this.matchingStrategy.accept(class_87862.comp_1933());
            }
            return this.matchedRecipe;
        }

        private void updateMatchedRecipe(class_1860<?> recipe, int size) {
            this.matchedRecipe = recipe;
            this.ingredientCount = size;
        }

        private void firstMatchStrategy(class_1860<?> candidateRecipe) {
            class_1860<?> class_18602 = candidateRecipe;
            Objects.requireNonNull(class_18602);
            class_1860<?> class_18603 = class_18602;
            int n = 0;
            switch (SwitchBootstraps.typeSwitch("typeSwitch", new Object[]{BasinRecipe.class, class_1869.class, class_1867.class}, class_18603, n)) {
                case 0: {
                    BasinRecipe recipe = (BasinRecipe)class_18603;
                    if (!recipe.method_8115(this.basinInput, BasinOperatingBlockEntity.this.field_11863)) break;
                    this.updateMatchedRecipe(recipe, recipe.getIngredientSize());
                    this.matchingStrategy = this::selectBetterMatch;
                    break;
                }
                case 1: {
                    class_1869 recipe = (class_1869)class_18603;
                    if (!BasinRecipe.matchCraftingRecipe(this.basinInput, recipe, BasinOperatingBlockEntity.this.field_11863)) break;
                    this.updateMatchedRecipe((class_1860<?>)recipe, (int)recipe.method_61693().stream().filter(Optional::isPresent).count());
                    this.matchingStrategy = this::selectBetterMatch;
                    break;
                }
                case 2: {
                    class_1867 recipe = (class_1867)class_18603;
                    if (!BasinRecipe.matchCraftingRecipe(this.basinInput, recipe, BasinOperatingBlockEntity.this.field_11863)) break;
                    this.updateMatchedRecipe((class_1860<?>)recipe, recipe.field_9047.size());
                    this.matchingStrategy = this::selectBetterMatch;
                    break;
                }
            }
        }

        private void selectBetterMatch(class_1860<?> candidateRecipe) {
            class_1860<?> class_18602 = candidateRecipe;
            Objects.requireNonNull(class_18602);
            class_1860<?> class_18603 = class_18602;
            int n = 0;
            switch (SwitchBootstraps.typeSwitch("typeSwitch", new Object[]{BasinRecipe.class, class_1869.class, class_1867.class}, class_18603, n)) {
                case 0: {
                    BasinRecipe recipe = (BasinRecipe)class_18603;
                    int count = recipe.getIngredientSize();
                    if (count <= this.ingredientCount || !recipe.method_8115(this.basinInput, BasinOperatingBlockEntity.this.field_11863)) break;
                    this.updateMatchedRecipe(recipe, count);
                    break;
                }
                case 1: {
                    class_1869 recipe = (class_1869)class_18603;
                    int count = recipe.method_61693().size();
                    if (count <= this.ingredientCount || !BasinRecipe.matchCraftingRecipe(this.basinInput, recipe, BasinOperatingBlockEntity.this.field_11863)) break;
                    this.updateMatchedRecipe((class_1860<?>)recipe, count);
                    break;
                }
                case 2: {
                    class_1867 recipe = (class_1867)class_18603;
                    int count = recipe.field_9047.size();
                    if (count <= this.ingredientCount || !BasinRecipe.matchCraftingRecipe(this.basinInput, recipe, BasinOperatingBlockEntity.this.field_11863)) break;
                    this.updateMatchedRecipe((class_1860<?>)recipe, count);
                    break;
                }
            }
        }
    }
}

