/*
 * Decompiled with CFR 0.152.
 */
package com.zurrtum.create.content.trains.bogey;

import com.google.common.collect.ImmutableList;
import com.google.common.collect.ImmutableSet;
import com.zurrtum.create.AllBogeyStyles;
import com.zurrtum.create.AllItems;
import com.zurrtum.create.api.schematic.requirement.SpecialBlockItemRequirement;
import com.zurrtum.create.catnip.data.Iterate;
import com.zurrtum.create.catnip.registry.RegisteredObjectsHelper;
import com.zurrtum.create.content.equipment.wrench.IWrenchable;
import com.zurrtum.create.content.schematics.requirement.ItemRequirement;
import com.zurrtum.create.content.trains.bogey.AbstractBogeyBlockEntity;
import com.zurrtum.create.content.trains.bogey.AllBogeySizes;
import com.zurrtum.create.content.trains.bogey.BogeySize;
import com.zurrtum.create.content.trains.bogey.BogeyStyle;
import com.zurrtum.create.content.trains.entity.Carriage;
import com.zurrtum.create.content.trains.entity.CarriageBogey;
import com.zurrtum.create.content.trains.entity.TravellingPoint;
import com.zurrtum.create.content.trains.graph.TrackEdge;
import com.zurrtum.create.foundation.block.IBE;
import com.zurrtum.create.foundation.block.ProperWaterloggedBlock;
import java.util.ArrayList;
import java.util.Collection;
import java.util.EnumSet;
import java.util.List;
import java.util.Set;
import java.util.function.Function;
import net.minecraft.class_10225;
import net.minecraft.class_1268;
import net.minecraft.class_1269;
import net.minecraft.class_156;
import net.minecraft.class_1657;
import net.minecraft.class_1792;
import net.minecraft.class_1799;
import net.minecraft.class_1922;
import net.minecraft.class_1937;
import net.minecraft.class_2248;
import net.minecraft.class_2338;
import net.minecraft.class_2350;
import net.minecraft.class_243;
import net.minecraft.class_2470;
import net.minecraft.class_2487;
import net.minecraft.class_2561;
import net.minecraft.class_2586;
import net.minecraft.class_2680;
import net.minecraft.class_2689;
import net.minecraft.class_2741;
import net.minecraft.class_2754;
import net.minecraft.class_2769;
import net.minecraft.class_2960;
import net.minecraft.class_3610;
import net.minecraft.class_3965;
import net.minecraft.class_4538;
import net.minecraft.class_4970;
import net.minecraft.class_5321;
import net.minecraft.class_5819;
import net.minecraft.class_7923;
import net.minecraft.class_7924;
import net.minecraft.class_9129;
import net.minecraft.class_9135;
import net.minecraft.class_9139;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public abstract class AbstractBogeyBlock<T extends AbstractBogeyBlockEntity>
extends class_2248
implements IBE<T>,
ProperWaterloggedBlock,
SpecialBlockItemRequirement,
IWrenchable {
    public static final class_9139<class_9129, AbstractBogeyBlock<?>> STREAM_CODEC = class_9135.method_56365((class_5321)class_7924.field_41254).method_56432(block -> (AbstractBogeyBlock)block, Function.identity());
    public static final class_2754<class_2350.class_2351> AXIS = class_2741.field_12529;
    static final List<class_2960> BOGEYS = (List)class_156.method_654(new ArrayList(), list -> {
        list.add(class_2960.method_60655((String)"create", (String)"block/small_bogey"));
        list.add(class_2960.method_60655((String)"create", (String)"block/large_bogey"));
    });
    public BogeySize size;
    static final EnumSet<class_2350> STICKY_X = EnumSet.of(class_2350.field_11034, class_2350.field_11039);
    static final EnumSet<class_2350> STICKY_Z = EnumSet.of(class_2350.field_11035, class_2350.field_11043);

    public AbstractBogeyBlock(class_4970.class_2251 pProperties, BogeySize size) {
        super(pProperties);
        this.method_9590((class_2680)this.method_9564().method_11657((class_2769)WATERLOGGED, (Comparable)Boolean.valueOf(false)));
        this.size = size;
    }

    public boolean isOnIncompatibleTrack(Carriage carriage, boolean leading) {
        TravellingPoint point = leading ? carriage.getLeadingPoint() : carriage.getTrailingPoint();
        CarriageBogey bogey = leading ? carriage.leadingBogey() : carriage.trailingBogey();
        TrackEdge currentEdge = point.edge;
        if (currentEdge == null) {
            return false;
        }
        return currentEdge.getTrackMaterial().getId() != this.getTrackType(bogey.getStyle());
    }

    public Set<class_2960> getValidPathfindingTypes(BogeyStyle style) {
        return ImmutableSet.of((Object)this.getTrackType(style));
    }

    public abstract class_2960 getTrackType(BogeyStyle var1);

    protected void method_9515(class_2689.class_2690<class_2248, class_2680> builder) {
        builder.method_11667(new class_2769[]{AXIS, WATERLOGGED});
        super.method_9515(builder);
    }

    public class_2680 method_9559(class_2680 pState, class_4538 pLevel, class_10225 tickView, class_2338 pCurrentPos, class_2350 pDirection, class_2338 pNeighborPos, class_2680 pNeighborState, class_5819 random) {
        this.updateWater(pLevel, tickView, pState, pCurrentPos);
        return pState;
    }

    public class_3610 method_9545(class_2680 pState) {
        return this.fluidState(pState);
    }

    public EnumSet<class_2350> getStickySurfaces(class_1922 world, class_2338 pos, class_2680 state) {
        return state.method_11654((class_2769)class_2741.field_12529) == class_2350.class_2351.field_11048 ? STICKY_X : STICKY_Z;
    }

    public abstract double getWheelPointSpacing();

    public abstract double getWheelRadius();

    public class_243 getConnectorAnchorOffset(boolean upsideDown) {
        return this.getConnectorAnchorOffset();
    }

    protected abstract class_243 getConnectorAnchorOffset();

    public boolean allowsSingleBogeyCarriage() {
        return true;
    }

    public abstract BogeyStyle getDefaultStyle();

    public boolean captureBlockEntityForTrain() {
        return false;
    }

    public BogeySize getSize() {
        return this.size;
    }

    public class_2350 getBogeyUpDirection() {
        return class_2350.field_11036;
    }

    public boolean isTrackAxisAlongFirstCoordinate(class_2680 state) {
        return state.method_11654(AXIS) == class_2350.class_2351.field_11048;
    }

    @Nullable
    public class_2680 getMatchingBogey(class_2350 upDirection, boolean axisAlongFirst) {
        if (upDirection != class_2350.field_11036) {
            return null;
        }
        return (class_2680)this.method_9564().method_11657(AXIS, (Comparable)(axisAlongFirst ? class_2350.class_2351.field_11048 : class_2350.class_2351.field_11051));
    }

    protected class_1269 method_55765(class_1799 stack, class_2680 state, class_1937 level, class_2338 pos, class_1657 player, class_1268 hand, class_3965 hitResult) {
        if (level.method_8608()) {
            return class_1269.field_52423;
        }
        if (!player.method_5715() && stack.method_31574((class_1792)AllItems.WRENCH) && !player.method_7357().method_7904(stack) && AllBogeyStyles.BOGEY_STYLES.size() > 1) {
            class_2586 be = level.method_8321(pos);
            if (!(be instanceof AbstractBogeyBlockEntity)) {
                return class_1269.field_5814;
            }
            AbstractBogeyBlockEntity sbbe = (AbstractBogeyBlockEntity)be;
            player.method_7357().method_62835(stack, 20);
            BogeyStyle currentStyle = sbbe.getStyle();
            BogeySize size = this.getSize();
            BogeyStyle style = this.getNextStyle(currentStyle);
            if (style == currentStyle) {
                return class_1269.field_52423;
            }
            Set<BogeySize> validSizes = style.validSizes();
            for (int i = 0; i < AllBogeySizes.all().size() && !validSizes.contains(size); ++i) {
                size = size.nextBySize();
            }
            sbbe.setBogeyStyle(style);
            class_2487 defaultData = style.defaultData;
            sbbe.setBogeyData(sbbe.getBogeyData().method_10543(defaultData));
            if (size == this.getSize()) {
                if (state.method_26204() != style.getBlockForSize(size)) {
                    class_2487 oldData = sbbe.getBogeyData();
                    level.method_8501(pos, this.copyProperties(state, this.getStateOfSize(sbbe, size)));
                    class_2586 class_25862 = level.method_8321(pos);
                    if (!(class_25862 instanceof AbstractBogeyBlockEntity)) {
                        return class_1269.field_5814;
                    }
                    AbstractBogeyBlockEntity bogeyBlockEntity = (AbstractBogeyBlockEntity)class_25862;
                    bogeyBlockEntity.setBogeyData(oldData);
                }
                player.method_7353((class_2561)class_2561.method_43471((String)"create.bogey.style.updated_style").method_27693(": ").method_10852(style.displayName), true);
            } else {
                class_2487 oldData = sbbe.getBogeyData();
                level.method_8501(pos, this.getStateOfSize(sbbe, size));
                class_2586 class_25863 = level.method_8321(pos);
                if (!(class_25863 instanceof AbstractBogeyBlockEntity)) {
                    return class_1269.field_5814;
                }
                AbstractBogeyBlockEntity bogeyBlockEntity = (AbstractBogeyBlockEntity)class_25863;
                bogeyBlockEntity.setBogeyData(oldData);
                player.method_7353((class_2561)class_2561.method_43471((String)"create.bogey.style.updated_style_and_size").method_27693(": ").method_10852(style.displayName), true);
            }
            return class_1269.field_21466;
        }
        return this.onInteractWithBogey(state, level, pos, player, hand, hitResult);
    }

    protected class_1269 onInteractWithBogey(class_2680 state, class_1937 level, class_2338 pos, class_1657 player, class_1268 hand, class_3965 hit) {
        return class_1269.field_52423;
    }

    protected List<class_2960> getBogeyBlockCycle() {
        return BOGEYS;
    }

    @Override
    public class_2680 getRotatedBlockState(class_2680 state, class_2350 targetedFace) {
        class_2248 block = state.method_26204();
        List<class_2960> bogeyCycle = this.getBogeyBlockCycle();
        int indexOf = bogeyCycle.indexOf(RegisteredObjectsHelper.getKeyOrThrow(block));
        if (indexOf == -1) {
            return state;
        }
        int index = (indexOf + 1) % bogeyCycle.size();
        class_2350 bogeyUpDirection = this.getBogeyUpDirection();
        boolean trackAxisAlongFirstCoordinate = this.isTrackAxisAlongFirstCoordinate(state);
        while (index != indexOf) {
            AbstractBogeyBlock bogey;
            class_2680 matchingBogey;
            class_2960 id = bogeyCycle.get(index);
            class_2248 newBlock = (class_2248)class_7923.field_41175.method_63535(id);
            if (newBlock instanceof AbstractBogeyBlock && (matchingBogey = (bogey = (AbstractBogeyBlock)newBlock).getMatchingBogey(bogeyUpDirection, trackAxisAlongFirstCoordinate)) != null) {
                return this.copyProperties(state, matchingBogey);
            }
            index = (index + 1) % bogeyCycle.size();
        }
        return state;
    }

    public class_2680 getNextSize(class_1937 level, class_2338 pos) {
        class_2586 be = level.method_8321(pos);
        if (be instanceof AbstractBogeyBlockEntity) {
            AbstractBogeyBlockEntity sbbe = (AbstractBogeyBlockEntity)be;
            return this.getNextSize(sbbe);
        }
        return level.method_8320(pos);
    }

    public List<class_2769<?>> propertiesToCopy() {
        return ImmutableList.of((Object)WATERLOGGED, AXIS);
    }

    private <V extends Comparable<V>> class_2680 copyProperty(class_2680 source, class_2680 target, class_2769<V> property) {
        if (source.method_28498(property) && target.method_28498(property)) {
            return (class_2680)target.method_11657(property, source.method_11654(property));
        }
        return target;
    }

    private class_2680 copyProperties(class_2680 source, class_2680 target) {
        for (class_2769<?> property : this.propertiesToCopy()) {
            target = this.copyProperty(source, target, property);
        }
        return target;
    }

    public class_2680 getNextSize(AbstractBogeyBlockEntity sbbe) {
        BogeySize size = this.getSize();
        BogeyStyle style = sbbe.getStyle();
        class_2680 nextBlock = style.getNextBlock(size).method_9564();
        nextBlock = this.copyProperties(sbbe.method_11010(), nextBlock);
        return nextBlock;
    }

    public class_2680 getStateOfSize(AbstractBogeyBlockEntity sbbe, BogeySize size) {
        BogeyStyle style = sbbe.getStyle();
        class_2680 state = style.getBlockForSize(size).method_9564();
        return this.copyProperties(sbbe.method_11010(), state);
    }

    public BogeyStyle getNextStyle(class_1937 level, class_2338 pos) {
        class_2586 te = level.method_8321(pos);
        if (te instanceof AbstractBogeyBlockEntity) {
            AbstractBogeyBlockEntity sbbe = (AbstractBogeyBlockEntity)te;
            return this.getNextStyle(sbbe.getStyle());
        }
        return this.getDefaultStyle();
    }

    public BogeyStyle getNextStyle(BogeyStyle style) {
        Collection<BogeyStyle> allStyles = style.getCycleGroup().values();
        if (allStyles.size() <= 1) {
            return style;
        }
        ArrayList<BogeyStyle> list = new ArrayList<BogeyStyle>(allStyles);
        return Iterate.cycleValue(list, style);
    }

    @NotNull
    public class_2680 method_9598(@NotNull class_2680 pState, class_2470 pRotation) {
        return switch (pRotation) {
            case class_2470.field_11465, class_2470.field_11463 -> (class_2680)pState.method_28493(AXIS);
            default -> pState;
        };
    }

    @Override
    public ItemRequirement getRequiredItems(class_2680 state, class_2586 te) {
        return new ItemRequirement(ItemRequirement.ItemUseType.CONSUME, AllItems.RAILWAY_CASING.method_7854());
    }

    public boolean canBeUpsideDown() {
        return false;
    }

    public boolean isUpsideDown(class_2680 state) {
        return false;
    }

    public class_2680 getVersion(class_2680 base, boolean upsideDown) {
        return base;
    }
}

