/*
 * Decompiled with CFR 0.152.
 */
package com.zurrtum.create.content.trains.entity;

import com.mojang.serialization.Codec;
import com.zurrtum.create.AllBlocks;
import com.zurrtum.create.AllContraptionTypes;
import com.zurrtum.create.api.behaviour.interaction.ConductorBlockInteractionBehavior;
import com.zurrtum.create.api.behaviour.interaction.MovingInteractionBehaviour;
import com.zurrtum.create.api.contraption.ContraptionType;
import com.zurrtum.create.catnip.data.Couple;
import com.zurrtum.create.catnip.data.Iterate;
import com.zurrtum.create.catnip.math.VecHelper;
import com.zurrtum.create.content.contraptions.AssemblyException;
import com.zurrtum.create.content.contraptions.Contraption;
import com.zurrtum.create.content.contraptions.MountedStorageManager;
import com.zurrtum.create.content.contraptions.actors.trainControls.ControlsBlock;
import com.zurrtum.create.content.contraptions.minecart.TrainCargoManager;
import com.zurrtum.create.content.trains.bogey.AbstractBogeyBlock;
import com.zurrtum.create.content.trains.entity.ArrivalSoundQueue;
import com.zurrtum.create.content.trains.entity.Carriage;
import com.zurrtum.create.content.trains.entity.CarriageContraptionEntity;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import net.minecraft.class_11368;
import net.minecraft.class_11372;
import net.minecraft.class_1937;
import net.minecraft.class_2248;
import net.minecraft.class_2338;
import net.minecraft.class_2350;
import net.minecraft.class_238;
import net.minecraft.class_2382;
import net.minecraft.class_2561;
import net.minecraft.class_2586;
import net.minecraft.class_2680;
import net.minecraft.class_2688;
import net.minecraft.class_2769;
import net.minecraft.class_3499;
import org.apache.commons.lang3.tuple.Pair;

public class CarriageContraption
extends Contraption {
    private class_2350 assemblyDirection;
    private boolean forwardControls;
    private boolean backwardControls;
    public Couple<Boolean> blockConductors;
    public Map<class_2338, Couple<Boolean>> conductorSeats = new HashMap<class_2338, Couple<Boolean>>();
    public ArrivalSoundQueue soundQueue;
    protected MountedStorageManager storageProxy;
    private int bogeys;
    private boolean sidewaysControls;
    private class_2338 secondBogeyPos;
    private List<class_2338> assembledBlockConductors = new ArrayList<class_2338>();
    public int portalCutoffMin;
    public int portalCutoffMax;
    static final MountedStorageManager fallbackStorage = new MountedStorageManager();

    public CarriageContraption() {
        this.blockConductors = Couple.create(false, false);
        this.soundQueue = new ArrivalSoundQueue();
        this.portalCutoffMin = Integer.MIN_VALUE;
        this.portalCutoffMax = Integer.MAX_VALUE;
        this.storage = new TrainCargoManager();
    }

    public void setSoundQueueOffset(int offset) {
        this.soundQueue.offset = offset;
    }

    public CarriageContraption(class_2350 assemblyDirection) {
        this();
        this.assemblyDirection = assemblyDirection;
        this.bogeys = 0;
    }

    @Override
    public boolean assemble(class_1937 world, class_2338 pos) throws AssemblyException {
        if (!this.searchMovedStructure(world, pos, null)) {
            return false;
        }
        if (this.blocks.size() <= 1) {
            return false;
        }
        if (this.bogeys == 0) {
            return false;
        }
        if (this.bogeys > 2) {
            throw new AssemblyException((class_2561)class_2561.method_43469((String)"create.train_assembly.too_many_bogeys", (Object[])new Object[]{this.bogeys}));
        }
        if (this.sidewaysControls) {
            throw new AssemblyException((class_2561)class_2561.method_43471((String)"create.train_assembly.sideways_controls"));
        }
        for (class_2338 blazePos : this.assembledBlockConductors) {
            for (class_2350 direction : Iterate.directionsInAxis(this.assemblyDirection.method_10166())) {
                if (!this.inControl(blazePos, direction)) continue;
                this.blockConductors.set(direction != this.assemblyDirection, true);
            }
        }
        for (class_2338 seatPos : this.getSeats()) {
            for (class_2350 direction : Iterate.directionsInAxis(this.assemblyDirection.method_10166())) {
                if (!this.inControl(seatPos, direction)) continue;
                this.conductorSeats.computeIfAbsent(seatPos, p -> Couple.create(false, false)).set(direction != this.assemblyDirection, true);
            }
        }
        return true;
    }

    public boolean inControl(class_2338 pos, class_2350 direction) {
        class_2338 controlsPos = pos.method_10093(direction);
        if (!this.blocks.containsKey(controlsPos)) {
            return false;
        }
        class_3499.class_3501 info = (class_3499.class_3501)this.blocks.get(controlsPos);
        if (!info.comp_1342().method_27852((class_2248)AllBlocks.TRAIN_CONTROLS)) {
            return false;
        }
        return info.comp_1342().method_11654((class_2769)ControlsBlock.field_11177) == direction.method_10153();
    }

    public void swapStorageAfterAssembly(CarriageContraptionEntity cce) {
        Carriage carriage = cce.getCarriage();
        if (carriage.storage == null) {
            carriage.storage = (TrainCargoManager)this.storage;
            this.storage = new MountedStorageManager();
        }
        this.storageProxy = carriage.storage;
    }

    public void returnStorageForDisassembly(MountedStorageManager storage) {
        this.storage = storage;
    }

    @Override
    protected boolean isAnchoringBlockAt(class_2338 pos) {
        return false;
    }

    @Override
    protected Pair<class_3499.class_3501, class_2586> capture(class_1937 world, class_2338 pos) {
        ConductorBlockInteractionBehavior conductor;
        MovingInteractionBehaviour behaviour;
        class_2680 blockState = world.method_8320(pos);
        if (ArrivalSoundQueue.isPlayable(blockState)) {
            int anchorCoord = VecHelper.getCoordinate((class_2382)this.anchor, this.assemblyDirection.method_10166());
            int posCoord = VecHelper.getCoordinate((class_2382)pos, this.assemblyDirection.method_10166());
            this.soundQueue.add((posCoord - anchorCoord) * this.assemblyDirection.method_10171().method_10181(), this.toLocalPos(pos));
        }
        if (blockState.method_26204() instanceof AbstractBogeyBlock) {
            ++this.bogeys;
            if (this.bogeys == 2) {
                this.secondBogeyPos = pos;
            }
        }
        if ((behaviour = MovingInteractionBehaviour.REGISTRY.get((class_2688<class_2248, ?>)blockState)) instanceof ConductorBlockInteractionBehavior && (conductor = (ConductorBlockInteractionBehavior)behaviour).isValidConductor(blockState)) {
            this.assembledBlockConductors.add(this.toLocalPos(pos));
        }
        if (blockState.method_27852((class_2248)AllBlocks.TRAIN_CONTROLS)) {
            class_2350 facing = (class_2350)blockState.method_11654((class_2769)ControlsBlock.field_11177);
            if (facing.method_10166() != this.assemblyDirection.method_10166()) {
                this.sidewaysControls = true;
            } else {
                boolean forwards;
                boolean bl = forwards = facing == this.assemblyDirection;
                if (forwards) {
                    this.forwardControls = true;
                } else {
                    this.backwardControls = true;
                }
            }
        }
        return super.capture(world, pos);
    }

    @Override
    public void write(class_11372 view, boolean spawnPacket) {
        super.write(view, spawnPacket);
        view.method_71468("AssemblyDirection", (Codec)class_2350.field_29502, (Object)this.getAssemblyDirection());
        view.method_71472("FrontControls", this.forwardControls);
        view.method_71472("BackControls", this.backwardControls);
        view.method_71472("FrontBlazeConductor", ((Boolean)this.blockConductors.getFirst()).booleanValue());
        view.method_71472("BackBlazeConductor", ((Boolean)this.blockConductors.getSecond()).booleanValue());
        class_11372.class_11374 list = view.method_71476("ConductorSeats");
        for (Map.Entry<class_2338, Couple<Boolean>> entry : this.conductorSeats.entrySet()) {
            class_11372 item = list.method_71480();
            item.method_71468("Pos", class_2338.field_25064, (Object)entry.getKey());
            Couple<Boolean> couple = entry.getValue();
            item.method_71472("Forward", ((Boolean)couple.getFirst()).booleanValue());
            item.method_71472("Backward", ((Boolean)couple.getSecond()).booleanValue());
        }
        this.soundQueue.write(view);
    }

    @Override
    public void read(class_1937 world, class_11368 view, boolean spawnData) {
        this.assemblyDirection = view.method_71426("AssemblyDirection", (Codec)class_2350.field_29502).orElse(class_2350.field_11033);
        this.forwardControls = view.method_71433("FrontControls", false);
        this.backwardControls = view.method_71433("BackControls", false);
        this.blockConductors = Couple.create(view.method_71433("FrontBlazeConductor", false), view.method_71433("BackBlazeConductor", false));
        this.conductorSeats.clear();
        view.method_71438("ConductorSeats").forEach(item -> this.conductorSeats.put(item.method_71426("Pos", class_2338.field_25064).orElse(class_2338.field_10980), Couple.create(item.method_71433("Forward", false), item.method_71433("Backward", false))));
        this.soundQueue.read(view);
        super.read(world, view, spawnData);
    }

    @Override
    public boolean canBeStabilized(class_2350 facing, class_2338 localPos) {
        return false;
    }

    @Override
    public ContraptionType getType() {
        return AllContraptionTypes.CARRIAGE;
    }

    public class_2350 getAssemblyDirection() {
        return this.assemblyDirection;
    }

    public boolean hasForwardControls() {
        return this.forwardControls;
    }

    public boolean hasBackwardControls() {
        return this.backwardControls;
    }

    public class_2338 getSecondBogeyPos() {
        return this.secondBogeyPos;
    }

    @Override
    public Optional<List<class_238>> getSimplifiedEntityColliders() {
        if (this.notInPortal()) {
            return super.getSimplifiedEntityColliders();
        }
        return Optional.empty();
    }

    @Override
    public boolean isHiddenInPortal(class_2338 localPos) {
        if (this.notInPortal()) {
            return super.isHiddenInPortal(localPos);
        }
        class_2350 facing = this.assemblyDirection;
        class_2350.class_2351 axis = facing.method_10170().method_10166();
        int coord = axis.method_10173(localPos.method_10260(), localPos.method_10264(), localPos.method_10263()) * -facing.method_10171().method_10181();
        return !this.withinVisible(coord) || this.atSeam(coord);
    }

    public boolean isHiddenInPortal(int posAlongMovementAxis) {
        if (this.notInPortal()) {
            return false;
        }
        return !this.withinVisible(posAlongMovementAxis) || this.atSeam(posAlongMovementAxis);
    }

    public boolean notInPortal() {
        return this.portalCutoffMin == Integer.MIN_VALUE && this.portalCutoffMax == Integer.MAX_VALUE;
    }

    public boolean atSeam(class_2338 localPos) {
        class_2350 facing = this.assemblyDirection;
        class_2350.class_2351 axis = facing.method_10170().method_10166();
        int coord = axis.method_10173(localPos.method_10260(), localPos.method_10264(), localPos.method_10263()) * -facing.method_10171().method_10181();
        return coord == this.portalCutoffMin || coord == this.portalCutoffMax;
    }

    public boolean withinVisible(class_2338 localPos) {
        class_2350 facing = this.assemblyDirection;
        class_2350.class_2351 axis = facing.method_10170().method_10166();
        int coord = axis.method_10173(localPos.method_10260(), localPos.method_10264(), localPos.method_10263()) * -facing.method_10171().method_10181();
        return this.withinVisible(coord);
    }

    public boolean atSeam(int posAlongMovementAxis) {
        return posAlongMovementAxis == this.portalCutoffMin || posAlongMovementAxis == this.portalCutoffMax;
    }

    public boolean withinVisible(int posAlongMovementAxis) {
        return posAlongMovementAxis > this.portalCutoffMin && posAlongMovementAxis < this.portalCutoffMax;
    }

    @Override
    public MountedStorageManager getStorage() {
        return this.storageProxy == null ? fallbackStorage : this.storageProxy;
    }

    @Override
    public void writeStorage(class_11372 view, boolean spawnPacket) {
        if (!spawnPacket) {
            return;
        }
        if (this.storageProxy != null) {
            this.storageProxy.write(view, spawnPacket);
        }
    }

    static {
        fallbackStorage.initialize();
    }
}

