/*
 * Decompiled with CFR 0.152.
 */
package com.zurrtum.create.content.trains.track;

import com.google.common.base.Predicates;
import com.zurrtum.create.AllBlockEntityTypes;
import com.zurrtum.create.AllBlockTags;
import com.zurrtum.create.AllBlocks;
import com.zurrtum.create.AllItems;
import com.zurrtum.create.AllShapes;
import com.zurrtum.create.AllTrackMaterials;
import com.zurrtum.create.api.contraption.train.PortalTrackProvider;
import com.zurrtum.create.api.schematic.requirement.SpecialBlockItemRequirement;
import com.zurrtum.create.catnip.data.Iterate;
import com.zurrtum.create.catnip.math.BlockFace;
import com.zurrtum.create.catnip.math.VecHelper;
import com.zurrtum.create.content.decoration.girder.GirderBlock;
import com.zurrtum.create.content.equipment.wrench.IWrenchable;
import com.zurrtum.create.content.schematics.requirement.ItemRequirement;
import com.zurrtum.create.content.trains.graph.TrackNodeLocation;
import com.zurrtum.create.content.trains.station.StationBlockEntity;
import com.zurrtum.create.content.trains.track.BezierConnection;
import com.zurrtum.create.content.trains.track.ITrackBlock;
import com.zurrtum.create.content.trains.track.TrackBlockEntity;
import com.zurrtum.create.content.trains.track.TrackMaterial;
import com.zurrtum.create.content.trains.track.TrackPropagator;
import com.zurrtum.create.content.trains.track.TrackShape;
import com.zurrtum.create.foundation.block.IBE;
import com.zurrtum.create.foundation.block.ProperWaterloggedBlock;
import it.unimi.dsi.fastutil.objects.Object2IntArrayMap;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import java.util.Map;
import java.util.function.Predicate;
import net.minecraft.class_10225;
import net.minecraft.class_124;
import net.minecraft.class_1268;
import net.minecraft.class_1269;
import net.minecraft.class_1309;
import net.minecraft.class_1657;
import net.minecraft.class_1750;
import net.minecraft.class_1799;
import net.minecraft.class_1838;
import net.minecraft.class_1922;
import net.minecraft.class_1935;
import net.minecraft.class_1936;
import net.minecraft.class_1937;
import net.minecraft.class_2246;
import net.minecraft.class_2248;
import net.minecraft.class_2338;
import net.minecraft.class_2350;
import net.minecraft.class_2374;
import net.minecraft.class_2382;
import net.minecraft.class_2415;
import net.minecraft.class_243;
import net.minecraft.class_2470;
import net.minecraft.class_2561;
import net.minecraft.class_2586;
import net.minecraft.class_259;
import net.minecraft.class_2591;
import net.minecraft.class_265;
import net.minecraft.class_2680;
import net.minecraft.class_2689;
import net.minecraft.class_2741;
import net.minecraft.class_2746;
import net.minecraft.class_2754;
import net.minecraft.class_2769;
import net.minecraft.class_3218;
import net.minecraft.class_3341;
import net.minecraft.class_3532;
import net.minecraft.class_3610;
import net.minecraft.class_3726;
import net.minecraft.class_3965;
import net.minecraft.class_4538;
import net.minecraft.class_4970;
import net.minecraft.class_5250;
import net.minecraft.class_5321;
import net.minecraft.class_5819;
import net.minecraft.class_6756;

public class TrackBlock
extends class_2248
implements IBE<TrackBlockEntity>,
IWrenchable,
ITrackBlock,
SpecialBlockItemRequirement,
ProperWaterloggedBlock {
    public static final class_2754<TrackShape> SHAPE = class_2754.method_11850((String)"shape", TrackShape.class);
    public static final class_2746 HAS_BE = class_2746.method_11825((String)"turn");
    protected final TrackMaterial material;

    public TrackBlock(class_4970.class_2251 p_49795_, TrackMaterial material) {
        super(p_49795_);
        this.method_9590((class_2680)((class_2680)((class_2680)this.method_9564().method_11657(SHAPE, (Comparable)((Object)TrackShape.ZO))).method_11657((class_2769)HAS_BE, (Comparable)Boolean.valueOf(false))).method_11657((class_2769)WATERLOGGED, (Comparable)Boolean.valueOf(false)));
        this.material = material;
    }

    public static TrackBlock andesite(class_4970.class_2251 settings) {
        return new TrackBlock(settings, AllTrackMaterials.ANDESITE);
    }

    protected void method_9515(class_2689.class_2690<class_2248, class_2680> p_49915_) {
        super.method_9515(p_49915_.method_11667(new class_2769[]{SHAPE, HAS_BE, WATERLOGGED}));
    }

    public class_3610 method_9545(class_2680 state) {
        return this.fluidState(state);
    }

    public class_2680 method_9605(class_1750 ctx) {
        class_2680 stateForPlacement = this.withWater(super.method_9605(ctx), ctx);
        if (ctx.method_8036() == null) {
            return stateForPlacement;
        }
        class_243 lookAngle = ctx.method_8036().method_5720();
        if (class_3532.method_20390((double)(lookAngle = lookAngle.method_18805(1.0, 0.0, 1.0)).method_1033(), (double)0.0)) {
            lookAngle = VecHelper.rotate(new class_243(0.0, 0.0, 1.0), -ctx.method_8036().method_36454(), class_2350.class_2351.field_11052);
        }
        lookAngle = lookAngle.method_1029();
        TrackShape best = TrackShape.ZO;
        double bestValue = 3.4028234663852886E38;
        for (TrackShape shape : TrackShape.values()) {
            class_243 axis;
            double distance;
            if (shape.isJunction() || shape.isPortal() || (distance = Math.min((axis = shape.getAxes().getFirst()).method_1025(lookAngle), axis.method_1029().method_1021(-1.0).method_1025(lookAngle))) > bestValue) continue;
            bestValue = distance;
            best = shape;
        }
        class_1937 level = ctx.method_8045();
        class_243 bestAxis = best.getAxes().getFirst();
        if (bestAxis.method_1027() == 1.0) {
            for (boolean neg : Iterate.trueAndFalse) {
                class_2338 offset = ctx.method_8037().method_10081((class_2382)class_2338.method_49638((class_2374)bestAxis.method_1021(neg ? -1.0 : 1.0)));
                if (!level.method_8320(offset).method_26206((class_1922)level, offset, class_2350.field_11036) || level.method_8320(offset.method_10084()).method_26206((class_1922)level, offset, class_2350.field_11033)) continue;
                if (best == TrackShape.XO) {
                    TrackShape trackShape = best = neg ? TrackShape.AW : TrackShape.AE;
                }
                if (best != TrackShape.ZO) continue;
                best = neg ? TrackShape.AN : TrackShape.AS;
            }
        }
        return (class_2680)stateForPlacement.method_11657(SHAPE, (Comparable)((Object)best));
    }

    public class_2680 method_9576(class_1937 pLevel, class_2338 pPos, class_2680 pState, class_1657 pPlayer) {
        super.method_9576(pLevel, pPos, pState, pPlayer);
        if (pLevel.method_8608()) {
            return pState;
        }
        if (!pPlayer.method_68878()) {
            return pState;
        }
        this.withBlockEntityDo((class_1922)pLevel, pPos, be -> {
            be.cancelDrops = true;
            be.removeInboundConnections(true);
        });
        return pState;
    }

    public void method_9615(class_2680 pState, class_1937 pLevel, class_2338 pPos, class_2680 pOldState, boolean pIsMoving) {
        if (pOldState.method_27852((class_2248)this)) {
            if (pState.method_11657((class_2769)HAS_BE, (Comparable)Boolean.valueOf(true)) == pOldState.method_11657((class_2769)HAS_BE, (Comparable)Boolean.valueOf(true))) {
                return;
            }
            TrackPropagator.onRailRemoved((class_1936)pLevel, pPos, pState);
        }
        if (pLevel.method_8608()) {
            return;
        }
        class_6756 blockTicks = pLevel.method_8397();
        if (!blockTicks.method_8674(pPos, (Object)this)) {
            pLevel.method_64310(pPos, (class_2248)this, 1);
        }
        this.updateGirders(pState, pLevel, pPos, (class_6756<class_2248>)blockTicks);
    }

    public void method_9567(class_1937 pLevel, class_2338 pPos, class_2680 pState, class_1309 pPlacer, class_1799 pStack) {
        super.method_9567(pLevel, pPos, pState, pPlacer, pStack);
        this.withBlockEntityDo((class_1922)pLevel, pPos, TrackBlockEntity::validateConnections);
    }

    public void method_9588(class_2680 state, class_3218 level, class_2338 pos, class_5819 p_60465_) {
        TrackPropagator.onRailAdded((class_1936)level, pos, state);
        this.withBlockEntityDo((class_1922)level, pos, tbe -> tbe.tilt.undoSmoothing());
        if (!((TrackShape)((Object)state.method_11654(SHAPE))).isPortal()) {
            this.connectToPortal(level, pos, state);
        }
    }

    protected void connectToPortal(class_3218 level, class_2338 pos, class_2680 state) {
        class_2350.class_2351 portalTest;
        TrackShape shape = (TrackShape)((Object)state.method_11654(SHAPE));
        Object object = shape == TrackShape.XO ? class_2350.class_2351.field_11048 : (portalTest = shape == TrackShape.ZO ? class_2350.class_2351.field_11051 : null);
        if (portalTest == null) {
            return;
        }
        boolean pop = false;
        String fail = null;
        class_2338 failPos = null;
        for (class_2350 d : Iterate.directionsInAxis(portalTest)) {
            BlockFace otherTrack;
            class_2338 otherTrackPos;
            class_2338 portalPos = pos.method_10093(d);
            class_2680 portalState = level.method_8320(portalPos);
            if (!PortalTrackProvider.isSupportedPortal(portalState)) continue;
            pop = true;
            PortalTrackProvider.Exit otherSide = PortalTrackProvider.getOtherSide(level, new BlockFace(pos, d));
            if (otherSide == null) {
                fail = "missing";
                continue;
            }
            class_3218 otherLevel = otherSide.level();
            class_2680 existing = otherLevel.method_8320(otherTrackPos = (otherTrack = otherSide.face()).getPos());
            if (!existing.method_45474()) {
                fail = "blocked";
                failPos = otherTrackPos;
                continue;
            }
            level.method_8652(pos, (class_2680)((class_2680)state.method_11657(SHAPE, (Comparable)((Object)TrackShape.asPortal(d)))).method_11657((class_2769)HAS_BE, (Comparable)Boolean.valueOf(true)), 3);
            class_2586 be = level.method_8321(pos);
            if (be instanceof TrackBlockEntity) {
                TrackBlockEntity tbe = (TrackBlockEntity)be;
                tbe.bind((class_5321<class_1937>)otherLevel.method_27983(), otherTrackPos);
            }
            class_2680 otherState = ProperWaterloggedBlock.withWater((class_4538)otherLevel, (class_2680)((class_2680)state.method_11657(SHAPE, (Comparable)((Object)TrackShape.asPortal(otherTrack.getFace())))).method_11657((class_2769)HAS_BE, (Comparable)Boolean.valueOf(true)), otherTrackPos);
            otherLevel.method_8652(otherTrackPos, otherState, 3);
            class_2586 otherBE = otherLevel.method_8321(otherTrackPos);
            if (otherBE instanceof TrackBlockEntity) {
                TrackBlockEntity tbe = (TrackBlockEntity)otherBE;
                tbe.bind((class_5321<class_1937>)level.method_27983(), pos);
            }
            pop = false;
        }
        if (!pop) {
            return;
        }
        level.method_22352(pos, true);
        if (fail == null) {
            return;
        }
        class_1657 player = level.method_8604((double)pos.method_10263(), (double)pos.method_10264(), (double)pos.method_10260(), 10.0, (Predicate)Predicates.alwaysTrue());
        if (player == null) {
            return;
        }
        player.method_7353((class_2561)class_2561.method_43470((String)"<!> ").method_10852((class_2561)class_2561.method_43471((String)"create.portal_track.failed")).method_27692(class_124.field_1065), false);
        class_5250 component = failPos != null ? class_2561.method_43469((String)("create.portal_track." + fail), (Object[])new Object[]{failPos.method_10263(), failPos.method_10264(), failPos.method_10260()}) : class_2561.method_43471((String)("create.portal_track." + fail));
        player.method_7353((class_2561)class_2561.method_43470((String)" - ").method_27692(class_124.field_1080).method_10852((class_2561)component.method_54663(16765876)), false);
    }

    public class_2680 method_9559(class_2680 state, class_4538 level, class_10225 tickView, class_2338 pCurrentPos, class_2350 pDirection, class_2338 pNeighborPos, class_2680 pNeighborState, class_5819 random) {
        this.updateWater(level, tickView, state, pCurrentPos);
        TrackShape shape = (TrackShape)((Object)state.method_11654(SHAPE));
        if (!shape.isPortal()) {
            return state;
        }
        for (class_2350 d : Iterate.horizontalDirections) {
            class_2338 portalPos;
            class_2680 portalState;
            if (TrackShape.asPortal(d) != state.method_11654(SHAPE) || pDirection != d || PortalTrackProvider.isSupportedPortal(portalState = level.method_8320(portalPos = pCurrentPos.method_10093(d)))) continue;
            return class_2246.field_10124.method_9564();
        }
        return state;
    }

    @Override
    public int getYOffsetAt(class_1922 world, class_2338 pos, class_2680 state, class_243 end) {
        return this.getBlockEntityOptional(world, pos).map(tbe -> tbe.tilt.getYOffsetForAxisEnd(end)).orElse(0);
    }

    @Override
    public Collection<TrackNodeLocation.DiscoveredLocation> getConnected(class_1922 worldIn, class_2338 pos, class_2680 state, boolean linear, TrackNodeLocation connectedTo) {
        Collection<TrackNodeLocation.DiscoveredLocation> list;
        class_1922 world;
        if (connectedTo != null && worldIn instanceof class_3218) {
            class_3218 sl = (class_3218)worldIn;
            v0 = sl.method_8503().method_3847(connectedTo.dimension);
        } else {
            v0 = world = worldIn;
        }
        if (this.getTrackAxes(world, pos, state).size() > 1) {
            class_243 center = class_243.method_24955((class_2382)pos).method_1031(0.0, this.getElevationAtCenter(world, pos, state), 0.0);
            TrackShape shape = (TrackShape)((Object)state.method_11654(SHAPE));
            list = new ArrayList<TrackNodeLocation.DiscoveredLocation>();
            for (class_243 axis2 : this.getTrackAxes(world, pos, state)) {
                for (boolean fromCenter : Iterate.trueAndFalse) {
                    ITrackBlock.addToListIfConnected(connectedTo, list, (d, b) -> axis2.method_1021(b != false ? 0.0 : (fromCenter ? -d.doubleValue() : d)).method_1019(center), b -> shape.getNormal(), b -> {
                        class_5321 class_53212;
                        if (world instanceof class_1937) {
                            class_1937 l = (class_1937)world;
                            class_53212 = l.method_27983();
                        } else {
                            class_53212 = class_1937.field_25179;
                        }
                        return class_53212;
                    }, v -> 0, axis2, null, (b, v) -> ITrackBlock.getMaterialSimple(world, v));
                }
            }
        } else {
            list = ITrackBlock.super.getConnected(world, pos, state, linear, connectedTo);
        }
        if (!((Boolean)state.method_11654((class_2769)HAS_BE)).booleanValue()) {
            return list;
        }
        if (linear) {
            return list;
        }
        class_2586 blockEntity = world.method_8321(pos);
        if (!(blockEntity instanceof TrackBlockEntity)) {
            return list;
        }
        TrackBlockEntity trackBE = (TrackBlockEntity)blockEntity;
        Map<class_2338, BezierConnection> connections = trackBE.getConnections();
        connections.forEach((connectedPos, bc) -> ITrackBlock.addToListIfConnected(connectedTo, list, (d, b) -> d == 1.0 ? class_243.method_24954((class_2382)((class_2382)bc.bePositions.get((boolean)b))) : bc.starts.get((boolean)b), bc.normals::get, b -> {
            class_5321 class_53212;
            if (world instanceof class_1937) {
                class_1937 l = (class_1937)world;
                class_53212 = l.method_27983();
            } else {
                class_53212 = class_1937.field_25179;
            }
            return class_53212;
        }, bc::yOffsetAt, null, bc, (b, v) -> ITrackBlock.getMaterialSimple(world, v, bc.getMaterial())));
        if (trackBE.boundLocation == null || !(world instanceof class_3218)) {
            return list;
        }
        class_3218 level = (class_3218)world;
        class_5321<class_1937> otherDim = trackBE.boundLocation.getFirst();
        class_3218 otherLevel = level.method_8503().method_3847(otherDim);
        if (otherLevel == null) {
            return list;
        }
        class_2338 boundPos = trackBE.boundLocation.getSecond();
        class_2680 boundState = otherLevel.method_8320(boundPos);
        if (!boundState.method_26164(AllBlockTags.TRACKS)) {
            return list;
        }
        class_243 center = class_243.method_24955((class_2382)pos).method_1031(0.0, this.getElevationAtCenter(world, pos, state), 0.0);
        class_243 boundCenter = class_243.method_24955((class_2382)boundPos).method_1031(0.0, this.getElevationAtCenter((class_1922)otherLevel, boundPos, boundState), 0.0);
        TrackShape shape = (TrackShape)((Object)state.method_11654(SHAPE));
        TrackShape boundShape = (TrackShape)((Object)boundState.method_11654(SHAPE));
        class_243 boundAxis = this.getTrackAxes((class_1922)otherLevel, boundPos, boundState).getFirst();
        this.getTrackAxes(world, pos, state).forEach(axis -> ITrackBlock.addToListIfConnected(connectedTo, list, (d, b) -> (b != false ? axis : boundAxis).method_1021(d.doubleValue()).method_1019(b != false ? center : boundCenter), b -> (b != false ? shape : boundShape).getNormal(), b -> b != false ? level.method_27983() : otherLevel.method_27983(), v -> 0, axis, null, (b, v) -> ITrackBlock.getMaterialSimple((class_1922)(b != false ? level : otherLevel), v)));
        return list;
    }

    public void method_66388(class_2680 pState, class_3218 pLevel, class_2338 pPos, boolean pIsMoving) {
        TrackPropagator.onRailRemoved((class_1936)pLevel, pPos, pState);
        if (!pLevel.method_8608()) {
            this.updateGirders(pState, (class_1937)pLevel, pPos, (class_6756<class_2248>)pLevel.method_14196());
        }
    }

    protected class_1269 method_55765(class_1799 stack, class_2680 state, class_1937 level, class_2338 pos, class_1657 player, class_1268 hand, class_3965 hitResult) {
        if (level.method_8608()) {
            return class_1269.field_5812;
        }
        for (Map.Entry<class_2338, class_3341> entry : StationBlockEntity.assemblyAreas.get((class_1936)level).entrySet()) {
            StationBlockEntity station;
            class_2586 class_25862;
            if (!entry.getValue().method_14662((class_2382)pos) || !((class_25862 = level.method_8321(entry.getKey())) instanceof StationBlockEntity) || !(station = (StationBlockEntity)class_25862).trackClicked(player, hand, this, state, pos)) continue;
            return class_1269.field_5812;
        }
        return class_1269.field_52423;
    }

    private void updateGirders(class_2680 pState, class_1937 pLevel, class_2338 pPos, class_6756<class_2248> blockTicks) {
        for (class_243 vec3 : this.getTrackAxes((class_1922)pLevel, pPos, pState)) {
            if (vec3.method_1033() > 1.0 || vec3.field_1351 != 0.0) continue;
            for (int side : Iterate.positiveAndNegative) {
                GirderBlock girderBlock;
                class_2338 girderPos = pPos.method_10074().method_10081((class_2382)class_2338.method_49637((double)(vec3.field_1350 * (double)side), (double)0.0, (double)(vec3.field_1352 * (double)side)));
                class_2680 girderState = pLevel.method_8320(girderPos);
                class_2248 class_22482 = girderState.method_26204();
                if (!(class_22482 instanceof GirderBlock) || blockTicks.method_8674(girderPos, (Object)(girderBlock = (GirderBlock)class_22482))) continue;
                pLevel.method_64310(girderPos, (class_2248)girderBlock, 1);
            }
        }
    }

    public boolean method_9558(class_2680 state, class_4538 reader, class_2338 pos) {
        return reader.method_8320(pos.method_10074()).method_26204() != this;
    }

    public class_265 method_9530(class_2680 state, class_1922 p_60556_, class_2338 p_60557_, class_3726 p_60558_) {
        return this.getFullShape(state);
    }

    public class_265 method_9584(class_2680 state, class_1922 pLevel, class_2338 pPos) {
        return this.getFullShape(state);
    }

    private class_265 getFullShape(class_2680 state) {
        return switch ((TrackShape)((Object)state.method_11654(SHAPE))) {
            case TrackShape.AE -> AllShapes.TRACK_ASC.get(class_2350.field_11034);
            case TrackShape.AW -> AllShapes.TRACK_ASC.get(class_2350.field_11039);
            case TrackShape.AN -> AllShapes.TRACK_ASC.get(class_2350.field_11043);
            case TrackShape.AS -> AllShapes.TRACK_ASC.get(class_2350.field_11035);
            case TrackShape.CR_D -> AllShapes.TRACK_CROSS_DIAG;
            case TrackShape.CR_NDX -> AllShapes.TRACK_CROSS_ORTHO_DIAG.get(class_2350.field_11035);
            case TrackShape.CR_NDZ -> AllShapes.TRACK_CROSS_DIAG_ORTHO.get(class_2350.field_11035);
            case TrackShape.CR_O -> AllShapes.TRACK_CROSS;
            case TrackShape.CR_PDX -> AllShapes.TRACK_CROSS_DIAG_ORTHO.get(class_2350.field_11034);
            case TrackShape.CR_PDZ -> AllShapes.TRACK_CROSS_ORTHO_DIAG.get(class_2350.field_11034);
            case TrackShape.ND -> AllShapes.TRACK_DIAG.get(class_2350.field_11035);
            case TrackShape.PD -> AllShapes.TRACK_DIAG.get(class_2350.field_11034);
            case TrackShape.XO -> AllShapes.TRACK_ORTHO.get(class_2350.field_11034);
            case TrackShape.ZO -> AllShapes.TRACK_ORTHO.get(class_2350.field_11035);
            case TrackShape.TE -> AllShapes.TRACK_ORTHO_LONG.get(class_2350.field_11034);
            case TrackShape.TW -> AllShapes.TRACK_ORTHO_LONG.get(class_2350.field_11039);
            case TrackShape.TS -> AllShapes.TRACK_ORTHO_LONG.get(class_2350.field_11035);
            case TrackShape.TN -> AllShapes.TRACK_ORTHO_LONG.get(class_2350.field_11043);
            default -> AllShapes.TRACK_FALLBACK;
        };
    }

    public class_265 method_9549(class_2680 pState, class_1922 pLevel, class_2338 pPos, class_3726 pContext) {
        return switch ((TrackShape)((Object)pState.method_11654(SHAPE))) {
            case TrackShape.AE, TrackShape.AW, TrackShape.AN, TrackShape.AS -> class_259.method_1073();
            default -> AllShapes.TRACK_COLLISION;
        };
    }

    @Override
    public class_2586 method_10123(class_2338 p_153215_, class_2680 state) {
        if (!((Boolean)state.method_11654((class_2769)HAS_BE)).booleanValue()) {
            return null;
        }
        return AllBlockEntityTypes.TRACK.method_11032(p_153215_, state);
    }

    @Override
    public Class<TrackBlockEntity> getBlockEntityClass() {
        return TrackBlockEntity.class;
    }

    @Override
    public class_2591<? extends TrackBlockEntity> getBlockEntityType() {
        return AllBlockEntityTypes.TRACK;
    }

    @Override
    public class_243 getUpNormal(class_1922 world, class_2338 pos, class_2680 state) {
        return ((TrackShape)((Object)state.method_11654(SHAPE))).getNormal();
    }

    @Override
    public List<class_243> getTrackAxes(class_1922 world, class_2338 pos, class_2680 state) {
        return ((TrackShape)((Object)state.method_11654(SHAPE))).getAxes();
    }

    @Override
    public class_243 getCurveStart(class_1922 world, class_2338 pos, class_2680 state, class_243 axis) {
        boolean vertical = axis.field_1351 != 0.0;
        return VecHelper.getCenterOf((class_2382)pos).method_1031(0.0, (double)(vertical ? 0.0f : -0.5f), 0.0).method_1019(axis.method_1021(0.5));
    }

    @Override
    public class_1269 onWrenched(class_2680 state, class_1838 context) {
        return class_1269.field_5812;
    }

    @Override
    public class_1269 onSneakWrenched(class_2680 state, class_1838 context) {
        class_2586 blockEntity;
        class_1657 player = context.method_8036();
        class_1937 level = context.method_8045();
        if (!level.method_8608() && !player.method_68878() && ((Boolean)state.method_11654((class_2769)HAS_BE)).booleanValue() && (blockEntity = level.method_8321(context.method_8037())) instanceof TrackBlockEntity) {
            TrackBlockEntity trackBE = (TrackBlockEntity)blockEntity;
            trackBE.cancelDrops = true;
            trackBE.connections.values().forEach(bc -> bc.addItemsToPlayer(player));
        }
        return IWrenchable.super.onSneakWrenched(state, context);
    }

    @Override
    public class_2680 overlay(class_1922 world, class_2338 pos, class_2680 existing, class_2680 placed) {
        if (placed.method_26204() != this) {
            return existing;
        }
        TrackShape existingShape = (TrackShape)((Object)existing.method_11654(SHAPE));
        TrackShape placedShape = (TrackShape)((Object)placed.method_11654(SHAPE));
        TrackShape combinedShape = null;
        for (boolean flip : Iterate.trueAndFalse) {
            TrackShape s2;
            TrackShape s1 = flip ? existingShape : placedShape;
            TrackShape trackShape = s2 = flip ? placedShape : existingShape;
            if (s1 == TrackShape.XO && s2 == TrackShape.ZO) {
                combinedShape = TrackShape.CR_O;
            }
            if (s1 == TrackShape.PD && s2 == TrackShape.ND) {
                combinedShape = TrackShape.CR_D;
            }
            if (s1 == TrackShape.XO && s2 == TrackShape.PD) {
                combinedShape = TrackShape.CR_PDX;
            }
            if (s1 == TrackShape.ZO && s2 == TrackShape.PD) {
                combinedShape = TrackShape.CR_PDZ;
            }
            if (s1 == TrackShape.XO && s2 == TrackShape.ND) {
                combinedShape = TrackShape.CR_NDX;
            }
            if (s1 != TrackShape.ZO || s2 != TrackShape.ND) continue;
            combinedShape = TrackShape.CR_NDZ;
        }
        if (combinedShape != null) {
            existing = (class_2680)existing.method_11657(SHAPE, combinedShape);
        }
        return existing;
    }

    public class_2680 method_9598(class_2680 state, class_2470 pRotation) {
        return (class_2680)state.method_11657(SHAPE, (Comparable)((Object)((TrackShape)((Object)state.method_11654(SHAPE))).rotate(pRotation)));
    }

    public class_2680 method_9569(class_2680 state, class_2415 pMirror) {
        return (class_2680)state.method_11657(SHAPE, (Comparable)((Object)((TrackShape)((Object)state.method_11654(SHAPE))).mirror(pMirror)));
    }

    @Override
    public class_2680 getBogeyAnchor(class_1922 world, class_2338 pos, class_2680 state) {
        return (class_2680)AllBlocks.SMALL_BOGEY.method_9564().method_11657((class_2769)class_2741.field_12529, (Comparable)(state.method_11654(SHAPE) == TrackShape.XO ? class_2350.class_2351.field_11048 : class_2350.class_2351.field_11051));
    }

    @Override
    public boolean trackEquals(class_2680 state1, class_2680 state2) {
        return state1.method_26204() == this && state2.method_26204() == this && state1.method_11657((class_2769)HAS_BE, (Comparable)Boolean.valueOf(false)) == state2.method_11657((class_2769)HAS_BE, (Comparable)Boolean.valueOf(false));
    }

    @Override
    public ItemRequirement getRequiredItems(class_2680 state, class_2586 be) {
        int sameTypeTrackAmount = 1;
        Object2IntArrayMap otherTrackAmounts = new Object2IntArrayMap();
        int girderAmount = 0;
        if (be instanceof TrackBlockEntity) {
            TrackBlockEntity track = (TrackBlockEntity)be;
            for (BezierConnection bezierConnection : track.getConnections().values()) {
                if (!bezierConnection.isPrimary()) continue;
                TrackMaterial material = bezierConnection.getMaterial();
                if (material == this.getMaterial()) {
                    sameTypeTrackAmount += bezierConnection.getTrackItemCost();
                } else {
                    otherTrackAmounts.put((Object)material, otherTrackAmounts.getOrDefault((Object)material, 0) + 1);
                }
                girderAmount += bezierConnection.getGirderItemCost();
            }
        }
        ArrayList<class_1799> stacks = new ArrayList<class_1799>();
        while (sameTypeTrackAmount > 0) {
            stacks.add(new class_1799((class_1935)state.method_26204(), Math.min(sameTypeTrackAmount, 64)));
            sameTypeTrackAmount -= 64;
        }
        for (TrackMaterial material : otherTrackAmounts.keySet()) {
            for (int amt = otherTrackAmounts.getOrDefault((Object)material, 0); amt > 0; amt -= 64) {
                stacks.add(new class_1799((class_1935)material, Math.min(amt, 64)));
            }
        }
        while (girderAmount > 0) {
            stacks.add(new class_1799((class_1935)AllItems.METAL_GIRDER, Math.min(girderAmount, 64)));
            girderAmount -= 64;
        }
        return new ItemRequirement(ItemRequirement.ItemUseType.CONSUME, stacks);
    }

    @Override
    public TrackMaterial getMaterial() {
        return this.material;
    }
}

