/*
 * Decompiled with CFR 0.152.
 */
package com.zurrtum.create.infrastructure.component;

import com.mojang.datafixers.kinds.App;
import com.mojang.datafixers.kinds.Applicative;
import com.mojang.serialization.Codec;
import com.mojang.serialization.codecs.RecordCodecBuilder;
import com.zurrtum.create.catnip.codecs.stream.CatnipStreamCodecBuilders;
import com.zurrtum.create.content.logistics.BigItemStack;
import com.zurrtum.create.content.logistics.packager.InventorySummary;
import com.zurrtum.create.content.logistics.stockTicker.PackageOrder;
import java.util.List;
import net.minecraft.class_9129;
import net.minecraft.class_9135;
import net.minecraft.class_9139;

public record PackageOrderWithCrafts(PackageOrder orderedStacks, List<CraftingEntry> orderedCrafts) {
    public static final Codec<PackageOrderWithCrafts> CODEC = Codec.withAlternative((Codec)RecordCodecBuilder.create(i -> i.group((App)PackageOrder.CODEC.fieldOf("ordered_stacks").forGetter(PackageOrderWithCrafts::orderedStacks), (App)CraftingEntry.CODEC.listOf().fieldOf("ordered_crafts").forGetter(PackageOrderWithCrafts::orderedCrafts)).apply((Applicative)i, PackageOrderWithCrafts::new)), (Codec)RecordCodecBuilder.create(instance -> instance.group((App)BigItemStack.CODEC.listOf().fieldOf("entries").forGetter(PackageOrderWithCrafts::stacks)).apply((Applicative)instance, PackageOrderWithCrafts::simple)));
    public static final class_9139<class_9129, PackageOrderWithCrafts> STREAM_CODEC = class_9139.method_56435(PackageOrder.STREAM_CODEC, s -> s.orderedStacks, CatnipStreamCodecBuilders.list(CraftingEntry.STREAM_CODEC), s -> s.orderedCrafts, PackageOrderWithCrafts::new);

    public static PackageOrderWithCrafts empty() {
        return new PackageOrderWithCrafts(PackageOrder.empty(), List.of());
    }

    public static PackageOrderWithCrafts simple(List<BigItemStack> orderedStacks) {
        return new PackageOrderWithCrafts(new PackageOrder(orderedStacks), List.of());
    }

    public static PackageOrderWithCrafts singleRecipe(List<BigItemStack> pattern) {
        return new PackageOrderWithCrafts(PackageOrder.empty(), List.of(new CraftingEntry(new PackageOrder(pattern), 1)));
    }

    public static boolean hasCraftingInformation(PackageOrderWithCrafts context) {
        if (context == null) {
            return false;
        }
        return context.orderedCrafts.size() == 1;
    }

    public List<BigItemStack> getCraftingInformation() {
        return this.orderedCrafts.get((int)0).pattern.stacks();
    }

    public List<BigItemStack> stacks() {
        return this.orderedStacks.stacks();
    }

    public boolean isEmpty() {
        return this.orderedStacks.isEmpty();
    }

    public boolean orderedStacksMatchOrderedRecipes() {
        if (this.orderedCrafts.isEmpty()) {
            return false;
        }
        InventorySummary stacks = new InventorySummary();
        InventorySummary crafts = new InventorySummary();
        this.stacks().forEach(stacks::add);
        this.orderedCrafts.forEach(ce -> ce.pattern.stacks().forEach(bis -> crafts.add(new BigItemStack(bis.stack, bis.count * ce.count))));
        List<BigItemStack> stackEntries = stacks.getStacks();
        if (stackEntries.size() != crafts.getStacks().size()) {
            return false;
        }
        for (BigItemStack bis : stackEntries) {
            if (crafts.getCountOf(bis.stack) == bis.count) continue;
            return false;
        }
        return true;
    }

    public record CraftingEntry(PackageOrder pattern, int count) {
        public static final Codec<CraftingEntry> CODEC = RecordCodecBuilder.create(i -> i.group((App)PackageOrder.CODEC.fieldOf("pattern").forGetter(CraftingEntry::pattern), (App)Codec.INT.fieldOf("count").forGetter(CraftingEntry::count)).apply((Applicative)i, CraftingEntry::new));
        public static final class_9139<class_9129, CraftingEntry> STREAM_CODEC = class_9139.method_56435(PackageOrder.STREAM_CODEC, CraftingEntry::pattern, (class_9139)class_9135.field_48550, CraftingEntry::count, CraftingEntry::new);
    }
}

