/*
 * Decompiled with CFR 0.152.
 */
package com.zurrtum.create.infrastructure.fluids;

import com.zurrtum.create.infrastructure.fluids.FluidItemInventory;
import com.zurrtum.create.infrastructure.fluids.FluidStack;
import java.util.NoSuchElementException;
import java.util.function.Consumer;
import java.util.stream.Stream;
import net.minecraft.class_1799;
import net.minecraft.class_2350;
import org.jetbrains.annotations.NotNull;

public abstract class FluidItemInventoryWrapper
implements FluidItemInventory {
    public Consumer<FluidItemInventoryWrapper> release;
    public class_1799 stack;

    @Override
    public void close() {
        this.stack = class_1799.field_8037;
        this.release.accept(this);
    }

    @Override
    public class_1799 getContainer() {
        return this.stack;
    }

    @Override
    public int size() {
        return 1;
    }

    @Override
    public boolean isEmpty() {
        return this.stack.method_7960();
    }

    public abstract FluidStack getStack();

    public abstract void setStack(FluidStack var1);

    public boolean canInsert() {
        return true;
    }

    public boolean canExtract() {
        return true;
    }

    @Override
    public int insert(FluidStack stack) {
        if (!this.canInsert()) {
            return 0;
        }
        return FluidItemInventory.super.insert(stack);
    }

    @Override
    public boolean preciseInsert(FluidStack stack) {
        if (!this.canInsert()) {
            return false;
        }
        return FluidItemInventory.super.preciseInsert(stack);
    }

    @Override
    public int extract(FluidStack stack) {
        if (!this.canExtract()) {
            return 0;
        }
        return FluidItemInventory.super.extract(stack);
    }

    @Override
    public boolean preciseExtract(FluidStack stack) {
        if (!this.canExtract()) {
            return false;
        }
        return FluidItemInventory.super.preciseExtract(stack);
    }

    public FluidStack removeStack() {
        FluidStack stack = this.getStack();
        if (stack.isEmpty()) {
            return FluidStack.EMPTY;
        }
        this.setStack(FluidStack.EMPTY);
        return stack;
    }

    public FluidStack removeStackWithAmount(int amount) {
        FluidStack stack = this.getStack();
        if (stack.isEmpty()) {
            return FluidStack.EMPTY;
        }
        FluidStack result = stack.split(amount);
        this.setStack(stack);
        return result;
    }

    @Override
    public FluidStack removeStack(int slot) {
        if (slot != 0) {
            return FluidStack.EMPTY;
        }
        if (!this.canExtract()) {
            return FluidStack.EMPTY;
        }
        return this.removeStack();
    }

    @Override
    public FluidStack removeStack(int slot, int amount) {
        if (slot != 0) {
            return FluidStack.EMPTY;
        }
        if (!this.canExtract()) {
            return FluidStack.EMPTY;
        }
        return this.removeStackWithAmount(amount);
    }

    @Override
    public FluidStack getStack(int slot) {
        if (slot != 0) {
            return FluidStack.EMPTY;
        }
        return this.getStack();
    }

    @Override
    public void setStack(int slot, FluidStack stack) {
        if (slot != 0) {
            return;
        }
        this.setStack(stack);
    }

    @Override
    public Stream<FluidStack> stream(class_2350 side) {
        return this.stream();
    }

    @Override
    public Stream<FluidStack> stream() {
        return this.canExtract() ? Stream.of(this.getStack()) : Stream.empty();
    }

    @Override
    @NotNull
    public java.util.Iterator<FluidStack> iterator() {
        return new Iterator(this);
    }

    public static class Iterator
    implements java.util.Iterator<FluidStack> {
        private FluidStack stack;
        private boolean hasNext;

        public Iterator(FluidItemInventoryWrapper inventory) {
            if (inventory.canExtract()) {
                this.stack = inventory.getStack();
                this.hasNext = true;
            } else {
                this.hasNext = false;
            }
        }

        @Override
        public boolean hasNext() {
            return this.hasNext;
        }

        @Override
        public FluidStack next() {
            if (!this.hasNext) {
                throw new NoSuchElementException();
            }
            this.hasNext = false;
            return this.stack;
        }
    }
}

