/*
 * Decompiled with CFR 0.152.
 */
package fi.dy.masa.minihud.info;

import fi.dy.masa.minihud.util.DataStorage;
import java.util.HashMap;
import java.util.Map;
import java.util.Objects;
import java.util.concurrent.CompletableFuture;
import java.util.concurrent.CompletionStage;
import javax.annotation.Nullable;
import net.minecraft.class_1132;
import net.minecraft.class_1923;
import net.minecraft.class_1937;
import net.minecraft.class_2791;
import net.minecraft.class_2806;
import net.minecraft.class_2818;
import net.minecraft.class_310;
import net.minecraft.class_3218;
import net.minecraft.class_9259;

public class InfoLineChunkCache {
    public static final InfoLineChunkCache INSTANCE = new InfoLineChunkCache();
    private final Map<class_1923, CompletableFuture<class_9259<class_2791>>> chunkFutures = new HashMap<class_1923, CompletableFuture<class_9259<class_2791>>>();
    @Nullable
    private class_2818 cachedClientChunk;
    private class_310 mc = class_310.method_1551();

    private InfoLineChunkCache() {
    }

    @Nullable
    private class_1937 getClientWorld() {
        if (this.mc == null) {
            this.mc = class_310.method_1551();
        }
        if (this.mc.field_1687 != null) {
            return this.mc.field_1687;
        }
        return null;
    }

    private DataStorage getData() {
        return DataStorage.getInstance();
    }

    public void onUpdate() {
        if (this.chunkFutures.size() >= 4) {
            this.resetCachedChunks();
        }
    }

    public void onReset() {
        this.resetCachedChunks();
    }

    @Nullable
    public class_2818 getChunk(class_1923 chunkPos) {
        class_9259 chunkResult;
        CompletableFuture<class_9259<class_2791>> future = this.chunkFutures.get(chunkPos);
        if (future == null) {
            future = this.setupChunkFuture(chunkPos);
        }
        if ((chunkResult = (class_9259)future.getNow(null)) == null) {
            return null;
        }
        class_2791 chunk = (class_2791)chunkResult.method_57130(null);
        if (chunk instanceof class_2818) {
            return (class_2818)chunk;
        }
        return null;
    }

    public CompletableFuture<class_9259<class_2791>> setupChunkFuture(class_1923 chunkPos) {
        class_3218 world;
        class_1132 server = this.getData().getIntegratedServer();
        CompletionStage<Object> future = null;
        if (server != null && (world = server.method_3847(Objects.requireNonNull(this.getClientWorld()).method_27983())) != null) {
            future = world.method_14178().method_17299(chunkPos.field_9181, chunkPos.field_9180, class_2806.field_12803, false).thenApply(either -> either.method_57127(chunk -> (class_2818)chunk));
        }
        if (future == null) {
            future = CompletableFuture.completedFuture(class_9259.method_57124((Object)this.getClientChunk(chunkPos)));
        }
        this.chunkFutures.put(chunkPos, (CompletableFuture<class_9259<class_2791>>)future);
        return future;
    }

    public class_2818 getClientChunk(class_1923 chunkPos) {
        if (this.cachedClientChunk == null || !this.cachedClientChunk.method_12004().equals((Object)chunkPos)) {
            this.cachedClientChunk = Objects.requireNonNull(this.getClientWorld()).method_8497(chunkPos.field_9181, chunkPos.field_9180);
        }
        return this.cachedClientChunk;
    }

    public void resetCachedChunks() {
        this.chunkFutures.clear();
        this.cachedClientChunk = null;
    }
}

