/*
 * Decompiled with CFR 0.152.
 */
package fi.dy.masa.minihud.renderer;

import fi.dy.masa.malilib.render.MaLiLibPipelines;
import fi.dy.masa.malilib.render.RenderUtils;
import fi.dy.masa.malilib.util.data.Color4f;
import fi.dy.masa.malilib.util.position.PositionUtils;
import fi.dy.masa.minihud.MiniHUD;
import fi.dy.masa.minihud.config.Configs;
import fi.dy.masa.minihud.config.RendererToggle;
import fi.dy.masa.minihud.renderer.OverlayRendererBase;
import fi.dy.masa.minihud.renderer.RenderObjectVbo;
import fi.dy.masa.minihud.util.BlockGridMode;
import net.minecraft.class_1297;
import net.minecraft.class_1937;
import net.minecraft.class_2338;
import net.minecraft.class_2350;
import net.minecraft.class_243;
import net.minecraft.class_2818;
import net.minecraft.class_287;
import net.minecraft.class_2902;
import net.minecraft.class_310;
import net.minecraft.class_3532;
import net.minecraft.class_3695;
import net.minecraft.class_9801;

public class OverlayRendererBlockGrid
extends OverlayRendererBase {
    public static final OverlayRendererBlockGrid INSTANCE = new OverlayRendererBlockGrid();
    private class_1297 cameraEntity = null;
    private boolean hasData = false;

    public OverlayRendererBlockGrid() {
        this.useCulling = true;
        this.renderThrough = false;
    }

    @Override
    public String getName() {
        return "BlockGrid";
    }

    @Override
    public boolean shouldRender(class_310 mc) {
        return RendererToggle.OVERLAY_BLOCK_GRID.getBooleanValue();
    }

    @Override
    public boolean needsUpdate(class_1297 entity, class_310 mc) {
        if (this.lastUpdatePos == null) {
            return true;
        }
        return Math.abs(entity.method_23317() - (double)this.lastUpdatePos.method_10263()) > 8.0 || Math.abs(entity.method_23318() - (double)this.lastUpdatePos.method_10264()) > 8.0 || Math.abs(entity.method_23321() - (double)this.lastUpdatePos.method_10260()) > 8.0;
    }

    @Override
    public void update(class_243 cameraPos, class_1297 entity, class_310 mc, class_3695 profiler) {
        if (RendererToggle.OVERLAY_BLOCK_GRID.getBooleanValue()) {
            this.cameraEntity = entity;
            this.hasData = true;
            this.render(cameraPos, mc, profiler);
        }
    }

    @Override
    public boolean hasData() {
        return this.hasData;
    }

    @Override
    protected void allocateBuffers() {
        this.clearBuffers();
        this.renderObjects.add(new RenderObjectVbo(() -> this.getName() + " Lines", MaLiLibPipelines.DEBUG_LINES_MASA_SIMPLE_LEQUAL_DEPTH));
    }

    @Override
    public void render(class_243 cameraPos, class_310 mc, class_3695 profiler) {
        this.allocateBuffers();
        this.renderOutlines(cameraPos, mc, profiler);
    }

    private void renderOutlines(class_243 cameraPos, class_310 mc, class_3695 profiler) {
        if (mc.field_1687 == null || mc.field_1724 == null || this.lastUpdatePos == null || this.cameraEntity == null) {
            return;
        }
        profiler.method_15396("block_grid_outlines");
        BlockGridMode mode = (BlockGridMode)Configs.Generic.BLOCK_GRID_OVERLAY_MODE.getOptionListValue();
        int radius = Configs.Generic.BLOCK_GRID_OVERLAY_RADIUS.getIntegerValue();
        Color4f color = Configs.Colors.BLOCK_GRID_OVERLAY_COLOR.getColor();
        RenderObjectVbo ctx = (RenderObjectVbo)this.renderObjects.getFirst();
        class_287 builder = ctx.start(() -> "minihud:block_grid/outlines", MaLiLibPipelines.DEBUG_LINES_MASA_SIMPLE_LEQUAL_DEPTH);
        switch (mode) {
            case ALL: {
                this.renderLinesAll(cameraPos, this.lastUpdatePos, radius, color, builder);
                break;
            }
            case NON_AIR: {
                this.renderLinesNonAir(cameraPos, this.cameraEntity.method_73183(), this.lastUpdatePos, radius, color, builder);
                break;
            }
            case ADJACENT: {
                this.renderLinesAdjacentToNonAir(cameraPos, this.cameraEntity.method_73183(), this.lastUpdatePos, radius, color, builder);
            }
        }
        try {
            class_9801 meshData = builder.method_60794();
            if (meshData != null) {
                ctx.upload(meshData, false);
                meshData.close();
            }
        }
        catch (Exception err) {
            MiniHUD.LOGGER.error("OverlayRendererBlockGrid#renderOutlines(): Exception; {}", (Object)err.getMessage());
        }
        profiler.method_15407();
    }

    @Override
    public void reset() {
        super.reset();
        this.cameraEntity = null;
        this.hasData = false;
    }

    protected void renderLinesAll(class_243 cameraPos, class_2338 center, int radius, Color4f color, class_287 buffer) {
        int y;
        int x;
        int startX = center.method_10263() - radius - class_3532.method_15357((double)cameraPos.field_1352);
        int startY = center.method_10264() - radius - class_3532.method_15357((double)cameraPos.field_1351);
        int startZ = center.method_10260() - radius - class_3532.method_15357((double)cameraPos.field_1350);
        int endX = center.method_10263() + radius - class_3532.method_15384((double)cameraPos.field_1352);
        int endY = center.method_10264() + radius - class_3532.method_15384((double)cameraPos.field_1351);
        int endZ = center.method_10260() + radius - class_3532.method_15384((double)cameraPos.field_1350);
        for (x = startX; x <= endX; ++x) {
            for (y = startY; y <= endY; ++y) {
                buffer.method_22912((float)x, (float)y, (float)startZ).method_22915(color.r, color.g, color.b, color.a);
                buffer.method_22912((float)x, (float)y, (float)endZ).method_22915(color.r, color.g, color.b, color.a);
            }
        }
        for (x = startX; x <= endX; ++x) {
            for (int z = startZ; z <= endZ; ++z) {
                buffer.method_22912((float)x, (float)startY, (float)z).method_22915(color.r, color.g, color.b, color.a);
                buffer.method_22912((float)x, (float)endY, (float)z).method_22915(color.r, color.g, color.b, color.a);
            }
        }
        for (int z = startZ; z <= endZ; ++z) {
            for (y = startY; y <= endY; ++y) {
                buffer.method_22912((float)startX, (float)y, (float)z).method_22915(color.r, color.g, color.b, color.a);
                buffer.method_22912((float)endX, (float)y, (float)z).method_22915(color.r, color.g, color.b, color.a);
            }
        }
    }

    protected void renderLinesNonAir(class_243 cameraPos, class_1937 world, class_2338 center, int radius, Color4f color, class_287 buffer) {
        int startX = center.method_10263() - radius;
        int startY = center.method_10264() - radius;
        int startZ = center.method_10260() - radius;
        int endX = center.method_10263() + radius;
        int endY = center.method_10264() + radius;
        int endZ = center.method_10260() + radius;
        int lastCX = startX >> 4;
        int lastCZ = startZ >> 4;
        class_2818 chunk = world.method_8497(lastCX, lastCZ);
        class_2338.class_2339 posMutable = new class_2338.class_2339();
        for (int x = startX; x <= endX; ++x) {
            for (int z = startZ; z <= endZ; ++z) {
                int cx = x >> 4;
                int cz = z >> 4;
                if (cx != lastCX || cz != lastCZ) {
                    chunk = world.method_8497(cx, cz);
                    lastCX = cx;
                    lastCZ = cz;
                }
                for (int y = startY; y <= endY && y <= chunk.method_12005(class_2902.class_2903.field_13202, x, z); ++y) {
                    posMutable.method_10103(x, y, z);
                    if (chunk.method_8320((class_2338)posMutable).method_26215()) continue;
                    RenderUtils.drawBlockBoundingBoxOutlinesBatchedLines((class_2338)posMutable, (class_243)cameraPos, (Color4f)color, (double)0.001, (class_287)buffer);
                }
            }
        }
    }

    protected void renderLinesAdjacentToNonAir(class_243 cameraPos, class_1937 world, class_2338 center, int radius, Color4f color, class_287 buffer) {
        int startX = center.method_10263() - radius;
        int startY = center.method_10264() - radius;
        int startZ = center.method_10260() - radius;
        int endX = center.method_10263() + radius;
        int endY = center.method_10264() + radius;
        int endZ = center.method_10260() + radius;
        int lastCX = startX >> 4;
        int lastCZ = startZ >> 4;
        class_2818 chunk = world.method_8497(lastCX, lastCZ);
        class_2338.class_2339 posMutable = new class_2338.class_2339();
        class_2338.class_2339 posMutable2 = new class_2338.class_2339();
        for (int x = startX; x <= endX; ++x) {
            for (int z = startZ; z <= endZ; ++z) {
                int cx = x >> 4;
                int cz = z >> 4;
                if (cx != lastCX || cz != lastCZ) {
                    chunk = world.method_8497(cx, cz);
                    lastCX = cx;
                    lastCZ = cz;
                }
                block2: for (int y = startY; y <= endY; ++y) {
                    posMutable.method_10103(x, y, z);
                    if (!chunk.method_8320((class_2338)posMutable).method_26215()) continue;
                    for (class_2350 side : PositionUtils.VERTICAL_DIRECTIONS) {
                        posMutable2.method_10103(posMutable.method_10263() + side.method_10148(), posMutable.method_10264() + side.method_10164(), posMutable.method_10260() + side.method_10165());
                        if (chunk.method_8320((class_2338)posMutable2).method_26215()) continue;
                        RenderUtils.drawBlockBoundingBoxOutlinesBatchedLines((class_2338)posMutable, (class_243)cameraPos, (Color4f)color, (double)0.001, (class_287)buffer);
                        break;
                    }
                    for (class_2350 side : PositionUtils.HORIZONTAL_DIRECTIONS) {
                        posMutable2.method_10103(posMutable.method_10263() + side.method_10148(), posMutable.method_10264() + side.method_10164(), posMutable.method_10260() + side.method_10165());
                        if (world.method_22347((class_2338)posMutable2)) continue;
                        RenderUtils.drawBlockBoundingBoxOutlinesBatchedLines((class_2338)posMutable, (class_243)cameraPos, (Color4f)color, (double)0.001, (class_287)buffer);
                        continue block2;
                    }
                }
            }
        }
    }
}

