/*
 * Decompiled with CFR 0.152.
 */
package net.wizardsoflua.command.dynamic;

import com.google.common.collect.LinkedListMultimap;
import com.google.common.collect.Multimap;
import com.mojang.brigadier.Command;
import com.mojang.brigadier.CommandDispatcher;
import com.mojang.brigadier.Message;
import com.mojang.brigadier.arguments.ArgumentType;
import com.mojang.brigadier.arguments.StringArgumentType;
import com.mojang.brigadier.builder.ArgumentBuilder;
import com.mojang.brigadier.builder.LiteralArgumentBuilder;
import com.mojang.brigadier.builder.RequiredArgumentBuilder;
import com.mojang.brigadier.context.CommandContext;
import com.mojang.brigadier.exceptions.CommandExceptionType;
import com.mojang.brigadier.exceptions.CommandSyntaxException;
import com.mojang.brigadier.exceptions.SimpleCommandExceptionType;
import com.mojang.brigadier.tree.CommandNode;
import java.util.ArrayDeque;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.Deque;
import java.util.IdentityHashMap;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Set;
import java.util.function.Function;
import me.lucko.fabric.api.permissions.v0.Permissions;
import net.minecraft.class_2168;
import net.minecraft.class_2170;
import net.minecraft.class_2172;
import net.minecraft.class_2561;
import net.minecraft.class_3222;
import net.minecraft.class_7157;
import net.minecraft.class_7225;
import net.minecraft.class_7699;
import net.minecraft.server.MinecraftServer;
import net.wizardsoflua.command.dynamic.CommandDef;
import net.wizardsoflua.command.dynamic.CommandNodeRemover;
import net.wizardsoflua.command.dynamic.DynamicCommandParser;
import net.wizardsoflua.command.dynamic.ParseResult;
import net.wizardsoflua.command.dynamic.Placeholder;
import net.wizardsoflua.command.dynamic.Token;
import net.wizardsoflua.spell.SpellCaster;

public class DynamicCommandManager {
    private static final SimpleCommandExceptionType NO_PERMISSION = new SimpleCommandExceptionType((Message)class_2561.method_43470((String)"You do not have permission to use this command"));
    private final SpellCaster spellCaster;
    private final CommandNodeRemover commandNodeRemover;
    private final Map<String, CommandDef> dynamicCommandsDefs = new LinkedHashMap<String, CommandDef>();
    private final Multimap<String, String> reachableCommands = LinkedListMultimap.create();
    private final Deque<CommandDef> definitionOrder = new ArrayDeque<CommandDef>();
    private final Set<CommandNode<class_2168>> createdNodes = Collections.newSetFromMap(new IdentityHashMap());
    private boolean needsReload = false;
    private boolean needsSync = false;

    public DynamicCommandManager(SpellCaster spellCaster) throws ReflectiveOperationException {
        this.spellCaster = Objects.requireNonNull(spellCaster, "spellCaster");
        this.commandNodeRemover = new CommandNodeRemover();
    }

    public Map<String, CommandDef> getAll() {
        return Collections.unmodifiableMap(this.dynamicCommandsDefs);
    }

    public CommandDef get(String id) {
        return this.dynamicCommandsDefs.get(id);
    }

    public boolean contains(String id) {
        return this.dynamicCommandsDefs.containsKey(id);
    }

    public void set(String commandId, String pattern, String code, class_2168 src, int level) {
        ParseResult parseResult = DynamicCommandParser.parse(pattern);
        CommandDef commandDef = new CommandDef(pattern, code, level, parseResult);
        commandDef.check((CommandDispatcher<class_2168>)src.method_54310(), this.createdNodes);
        CommandDef oldCommandDef = this.dynamicCommandsDefs.put(commandId, commandDef);
        if (oldCommandDef != null) {
            Collection<String> tokenPaths = oldCommandDef.getTokenPaths();
            for (String tokenPath : tokenPaths) {
                this.reachableCommands.remove((Object)tokenPath, (Object)commandId);
            }
        }
        for (String tokenPath : parseResult.getTokenPaths()) {
            this.reachableCommands.put((Object)tokenPath, (Object)commandId);
        }
        this.markForReload();
    }

    public boolean remove(String commandId, class_2168 src) {
        CommandDef commandDef = this.dynamicCommandsDefs.remove(commandId);
        if (commandDef == null) {
            return false;
        }
        for (String tokenPath : commandDef.getTokenPaths()) {
            this.reachableCommands.remove((Object)tokenPath, (Object)commandId);
        }
        this.markForReload();
        return true;
    }

    public void clearAll() {
        if (this.dynamicCommandsDefs.isEmpty()) {
            return;
        }
        this.dynamicCommandsDefs.clear();
        this.reachableCommands.clear();
        this.markForReload();
    }

    public void markForReload() {
        this.needsReload = true;
    }

    public void tick(MinecraftServer server) {
        if (this.needsSync) {
            this.needsSync = false;
            this.sendCommandTree(server);
        }
        if (this.needsReload) {
            this.needsReload = false;
            this.reload(server);
        }
    }

    private void sendCommandTree(MinecraftServer server) {
        class_2170 mgr = server.method_3734();
        for (class_3222 player : server.method_3760().method_14571()) {
            mgr.method_9241(player);
        }
    }

    private void reload(MinecraftServer server) {
        CommandDispatcher disp = server.method_3734().method_9235();
        class_7157 regAccess = class_7157.method_46722((class_7225.class_7874)server.method_30611(), (class_7699)server.method_27728().method_45560());
        this.reload((CommandDispatcher<class_2168>)disp, regAccess);
    }

    public void reload(CommandDispatcher<class_2168> disp, class_7157 regAccess) {
        this.deregister(disp, regAccess);
        this.register(disp, regAccess);
    }

    private void deregister(CommandDispatcher<class_2168> dispatcher, class_7157 registryAccess) {
        if (this.definitionOrder.isEmpty()) {
            return;
        }
        while (!this.definitionOrder.isEmpty()) {
            CommandDef def = this.definitionOrder.pop();
            def.deregister(dispatcher, this.commandNodeRemover);
            this.needsSync = true;
        }
        this.createdNodes.clear();
    }

    private void register(CommandDispatcher<class_2168> dispatcher, class_7157 registryAccess) {
        for (Map.Entry<String, CommandDef> entry : this.dynamicCommandsDefs.entrySet()) {
            String commandId = entry.getKey();
            CommandDef commandDef = entry.getValue();
            commandDef.register(dispatcher, this.buildLiteral(commandId, commandDef, registryAccess));
            this.definitionOrder.push(commandDef);
            this.createdNodes.addAll(commandDef.getCreatedNodes());
            this.needsSync = true;
        }
    }

    private LiteralArgumentBuilder<class_2168> buildLiteral(String commandId, CommandDef def, class_7157 registryAccess) {
        List<Token> tokens = def.getTokens();
        int lastPlaceholderIdx = def.findLastPlaceholderIndex();
        ArrayList<Object> builders = new ArrayList<Object>();
        ArrayList<Function<CommandContext, Object>> extractors = new ArrayList<Function<CommandContext, Object>>();
        ArrayList<Object> luaArgNames = new ArrayList<Object>();
        int argCount = 0;
        for (int i = 0; i < tokens.size(); ++i) {
            boolean greedy;
            Token tok = tokens.get(i);
            if (!tok.isPlaceholder()) {
                builders.add(class_2170.method_9247((String)tok.tokenName()));
                continue;
            }
            ++argCount;
            String nodeName = tok.tokenName();
            Placeholder ph = tok.placeholder();
            boolean bl = greedy = ph == Placeholder.STRING && i == lastPlaceholderIdx;
            if (ph == Placeholder.STRING && tok.enumValues() != null) {
                List<String> opts = tok.enumValues();
                RequiredArgumentBuilder argB = class_2170.method_9244((String)nodeName, (ArgumentType)(greedy ? StringArgumentType.greedyString() : StringArgumentType.string())).suggests((ctx, sb) -> {
                    for (String v : opts) {
                        sb.suggest(v);
                    }
                    return sb.buildFuture();
                });
                builders.add(argB);
                extractors.add(ctx -> {
                    String val = StringArgumentType.getString((CommandContext)ctx, (String)nodeName);
                    if (!opts.contains(val)) {
                        throw new IllegalArgumentException("Unknown value \"" + val + "\"");
                    }
                    return val;
                });
            } else {
                builders.add(ph.createBuilder(nodeName, greedy, registryAccess));
                extractors.add(ctx -> ph.extract((CommandContext<class_2168>)ctx, nodeName, registryAccess));
            }
            luaArgNames.add(tok.isNamedPlaceholder() ? tok.tokenName() : Integer.valueOf(argCount));
        }
        int size = builders.size();
        if (size > 0) {
            for (int i = 0; i < size; ++i) {
                String tokenPath = def.getTokenPath(i);
                builders.set(i, ((ArgumentBuilder)builders.get(i)).requires(src -> {
                    if (!this.contains(commandId)) {
                        return false;
                    }
                    Collection commandIds = this.reachableCommands.get((Object)tokenPath);
                    return src.method_9228() == null || commandIds.stream().map(cId -> Permissions.check((class_2172)src, (String)cId, (int)def.getLevel())).anyMatch(b -> b);
                }));
            }
        }
        Command exec = ctx -> {
            class_2168 src = (class_2168)ctx.getSource();
            LinkedHashMap<Object, Object> args = new LinkedHashMap<Object, Object>();
            try {
                for (int j = 0; j < extractors.size(); ++j) {
                    Object v = ((Function)extractors.get(j)).apply(ctx);
                    if (v == null) continue;
                    Object key = luaArgNames.get(j);
                    args.put(key, v);
                }
            }
            catch (IllegalArgumentException e) {
                class_2561 message = class_2561.method_30163((String)e.getMessage());
                throw new CommandSyntaxException((CommandExceptionType)new SimpleCommandExceptionType((Message)message), (Message)message);
            }
            return this.spellCaster.castNewSpell(src, def.getCode(), args);
        };
        if (builders.isEmpty()) {
            throw new IllegalStateException("Unexpected state. Builders are empty.");
        }
        int i = builders.size() - 1;
        ArgumentBuilder chain = ((ArgumentBuilder)builders.get(i)).executes(ctx -> {
            class_2168 src = (class_2168)ctx.getSource();
            if (src.method_9228() != null && !Permissions.check((class_2172)src, (String)commandId, (int)def.getLevel())) {
                throw NO_PERMISSION.create();
            }
            return exec.run(ctx);
        });
        for (int j = builders.size() - 2; j >= 0; --j) {
            chain = ((ArgumentBuilder)builders.get(j)).then(chain);
        }
        return (LiteralArgumentBuilder)chain;
    }
}

