/*
 * Decompiled with CFR 0.152.
 */
package net.wizardsoflua.spell;

import java.util.Collection;
import java.util.HashSet;
import java.util.Objects;
import java.util.Set;
import net.minecraft.class_1297;
import net.minecraft.class_2165;
import net.minecraft.class_2168;
import net.minecraft.class_2338;
import net.minecraft.class_2374;
import net.minecraft.class_241;
import net.minecraft.class_243;
import net.minecraft.class_2561;
import net.minecraft.class_3218;
import net.minecraft.class_3532;
import net.minecraft.server.MinecraftServer;
import net.wizardsoflua.spell.SpellScope;
import net.wizardsoflua.spell.SpellServerCommandSource;
import net.wizardsoflua.spell.VirtualEntityChunkForceSupport;
import net.wizardsoflua.util.WolDirection;

public class VirtualEntity {
    private final SpellScope spellScope;
    private class_243 pos;
    private final VirtualEntityChunkForceSupport chunkForceSupport;
    private final long startedTime;
    private boolean alive;
    private String name;
    private final Set<String> tags = new HashSet<String>();
    private float pitch;
    private float yaw;
    private class_243 velocity = class_243.field_1353;

    public VirtualEntity(SpellScope spellScope, class_243 pos) {
        this.spellScope = Objects.requireNonNull(spellScope, "spellScope");
        this.pos = pos;
        this.chunkForceSupport = new VirtualEntityChunkForceSupport(spellScope.getChunkForceManager(), this);
        this.startedTime = spellScope.getWorld().method_8510();
        this.alive = true;
        this.setForceChunk(true);
    }

    public void setForceChunk(boolean value) {
        if (value) {
            this.chunkForceSupport.requestNewTicket();
        } else {
            this.chunkForceSupport.releaseTicket();
        }
    }

    public boolean isForceChunk() {
        return this.chunkForceSupport.hasTicket();
    }

    public class_3218 getWorld() {
        return this.spellScope.getWorld();
    }

    public long getStartedTime() {
        return this.startedTime;
    }

    public long getAge() {
        return this.getWorld().method_8510() - this.getStartedTime();
    }

    public String getName() {
        return this.name;
    }

    public void setName(String name) {
        this.name = name;
    }

    public boolean isAlive() {
        return this.alive;
    }

    public void setDead() {
        this.alive = false;
        this.chunkForceSupport.releaseTicket();
    }

    public class_2561 getDisplayName() {
        return class_2561.method_30163((String)this.getName());
    }

    public Set<String> getTags() {
        return this.tags;
    }

    public void setTags(Collection<String> tags) {
        tags.clear();
        tags.addAll(tags);
    }

    public boolean addTag(String tag) {
        return this.tags.add(tag);
    }

    public boolean removeTag(String tag) {
        return this.tags.remove(tag);
    }

    public class_243 getPos() {
        return this.pos;
    }

    public void setPos(class_243 pos) {
        this.pos = Objects.requireNonNull(pos, "pos");
        this.chunkForceSupport.updatePosition();
    }

    public void move(WolDirection dir, double distance) {
        class_243 offset = dir.getDirectionVec(this.yaw).method_1021(distance);
        class_243 newPos = this.getPos().method_1019(offset);
        this.setPos(newPos);
    }

    public class_2338 getBlockPos() {
        return class_2338.method_49638((class_2374)this.getPos());
    }

    public double getDistanceSq(VirtualEntity entity) {
        return this.getPos().method_1025(entity.getPos());
    }

    public float getPitch() {
        return this.pitch;
    }

    public void setPitch(float pitch) {
        this.pitch = pitch;
    }

    public float getYaw() {
        return this.yaw;
    }

    public void setYaw(float yaw) {
        this.yaw = yaw;
    }

    public class_243 getLookVector() {
        return this.getRotationVector(this.pitch, this.yaw);
    }

    public class_241 getRotationClient() {
        return new class_241(this.getPitch(), this.getYaw());
    }

    public class_243 getVelocity() {
        return this.velocity;
    }

    public void setVelocity(class_243 velocity) {
        this.velocity = velocity;
    }

    private final class_243 getRotationVector(float pitch, float yaw) {
        float f = pitch * ((float)Math.PI / 180);
        float g = -yaw * ((float)Math.PI / 180);
        float h = class_3532.method_15362((float)g);
        float i = class_3532.method_15374((float)g);
        float j = class_3532.method_15362((float)f);
        float k = class_3532.method_15374((float)f);
        return new class_243((double)(i * j), (double)(-k), (double)(h * j));
    }

    public class_2168 createCommandSource() {
        class_2165 output = new class_2165(this){

            public boolean method_9202() {
                return true;
            }

            public boolean method_9200() {
                return true;
            }

            public boolean method_9201() {
                return true;
            }

            public void method_43496(class_2561 text) {
            }
        };
        return this.createCommandSource(output);
    }

    public SpellServerCommandSource createCommandSource(class_2165 output) {
        class_243 pos = this.getPos();
        class_241 rot = this.getRotationClient();
        int level = 4;
        String name = this.getName();
        class_2561 displayName = this.getDisplayName();
        class_1297 entity = null;
        MinecraftServer server = this.getWorld().method_8503();
        class_3218 world = this.getWorld();
        return new SpellServerCommandSource(output, pos, rot, world, level, name, displayName, server, entity);
    }

    public void tick() {
        class_243 newPOs = this.pos.method_1019(this.velocity);
        this.setPos(newPOs);
    }
}

