/*
 * Decompiled with CFR 0.152.
 */
package snownee.jade.track;

import snownee.jade.track.TrackInfo;

public class HealthTrackInfo
extends TrackInfo {
    private float health;
    private float lastHealth;
    private float absorption;
    private float lastAbsorption;
    private int ticksSinceHurt = 1000;

    public HealthTrackInfo(float health, float absorption) {
        this.health = this.lastHealth = health;
        this.absorption = this.lastAbsorption = absorption;
    }

    @Override
    public void update(float pTicks) {
    }

    @Override
    public void tick() {
        ++this.ticksSinceHurt;
        if (this.health != this.lastHealth && this.ticksSinceHurt >= 5) {
            this.lastHealth = this.health;
        }
        if (this.absorption != this.lastAbsorption && this.ticksSinceHurt >= 5) {
            this.lastAbsorption = this.absorption;
        }
    }

    public float getLastHealth() {
        return this.lastHealth;
    }

    public float getLastAbsorption() {
        return this.lastAbsorption;
    }

    public boolean isBlinking() {
        return this.ticksSinceHurt < 5;
    }

    public void setHealth(float health, float absorption) {
        if (health < this.health) {
            this.ticksSinceHurt = 0;
        } else if (health > this.health) {
            this.lastHealth = health;
        }
        this.health = health;
        if (absorption < this.absorption) {
            this.ticksSinceHurt = 0;
        } else if (absorption > this.absorption) {
            this.lastAbsorption = absorption;
        }
        this.absorption = absorption;
    }
}

