/*
 * Decompiled with CFR 0.152.
 */
package eu.pb4.placeholders.api.arguments;

import java.util.ArrayList;
import java.util.List;
import java.util.Locale;
import net.minecraft.class_5462;
import org.jetbrains.annotations.Nullable;

public class SimpleArguments {
    public static boolean isWrapCharacter(char c) {
        return c == '\"' || c == '\'' || c == '`';
    }

    public static String unwrap(String string) {
        return SimpleArguments.unwrap(string, SimpleArguments::isWrapCharacter);
    }

    public static String unwrap(String string, class_5462 isWrap) {
        char c2;
        if (string.length() < 2) {
            return string;
        }
        char c1 = string.charAt(0);
        if (c1 == (c2 = string.charAt(string.length() - 1)) && isWrap.test(c1)) {
            StringBuilder builder = new StringBuilder(string.length() - 2);
            for (int i = 1; i < string.length() - 1; ++i) {
                char chr = string.charAt(i);
                if (chr == c1 && string.charAt(i + 1) == c1) {
                    ++i;
                }
                builder.append(chr);
            }
            return builder.toString();
        }
        return string;
    }

    public static List<String> split(String string, char separator) {
        return SimpleArguments.split(string, separator, true, true);
    }

    public static List<String> split(String string, char separator, boolean removeWrapping, boolean removeBackslash) {
        ArrayList<String> list = new ArrayList<String>();
        StringBuilder b = new StringBuilder();
        char wrap = '\u0000';
        for (int i = 0; i < string.length(); ++i) {
            char character = string.charAt(i);
            if (character == '\\') {
                if (!removeBackslash) {
                    b.append(character);
                }
                if (i + 1 >= string.length()) continue;
                b.append(string.charAt(i + 1));
                ++i;
                continue;
            }
            if (character == separator && wrap == '\u0000') {
                list.add(b.toString());
                b = new StringBuilder();
                continue;
            }
            if (wrap == character && wrap != '\u0000') {
                if (i + 1 >= string.length() || string.charAt(i + 1) != wrap) {
                    wrap = '\u0000';
                    if (removeWrapping) {
                        continue;
                    }
                } else if (removeWrapping) {
                    ++i;
                }
            } else if (wrap == '\u0000' && SimpleArguments.isWrapCharacter(character)) {
                wrap = character;
                if (removeWrapping) continue;
            }
            b.append(character);
        }
        if (!b.isEmpty()) {
            list.add(b.toString());
        }
        return list;
    }

    public static boolean bool(@Nullable String arg) {
        return SimpleArguments.bool(arg, false);
    }

    public static boolean bool(@Nullable String arg, boolean defaultBool) {
        if (arg == null || arg.isBlank()) {
            return defaultBool;
        }
        return switch (arg.toLowerCase(Locale.ROOT)) {
            case "true", "tru", "yes", "y", "1", "enabled", "enable", "on" -> true;
            default -> false;
        };
    }

    public static float floatNumber(@Nullable String arg) {
        return SimpleArguments.floatNumber(arg, 0.0f);
    }

    public static float floatNumber(@Nullable String arg, float defaultFloat) {
        if (arg == null || arg.isBlank()) {
            return defaultFloat;
        }
        try {
            return Float.parseFloat(arg);
        }
        catch (Exception e) {
            return defaultFloat;
        }
    }

    public static int intNumber(@Nullable String arg) {
        return SimpleArguments.intNumber(arg, 0);
    }

    public static int intNumber(@Nullable String arg, int defaultFloat) {
        if (arg == null || arg.isBlank()) {
            return defaultFloat;
        }
        try {
            return Integer.parseInt(arg);
        }
        catch (Exception e) {
            return defaultFloat;
        }
    }
}

