/*
 * Decompiled with CFR 0.152.
 */
package eu.pb4.placeholders.impl;

import com.mojang.datafixers.util.Either;
import eu.pb4.placeholders.api.node.KeybindNode;
import eu.pb4.placeholders.api.node.LiteralNode;
import eu.pb4.placeholders.api.node.NbtNode;
import eu.pb4.placeholders.api.node.ObjectNode;
import eu.pb4.placeholders.api.node.ScoreNode;
import eu.pb4.placeholders.api.node.SelectorNode;
import eu.pb4.placeholders.api.node.TextNode;
import eu.pb4.placeholders.api.node.TranslatedNode;
import eu.pb4.placeholders.api.node.parent.ColorNode;
import eu.pb4.placeholders.api.node.parent.DynamicShadowNode;
import eu.pb4.placeholders.api.node.parent.FormattingNode;
import eu.pb4.placeholders.api.node.parent.GradientNode;
import eu.pb4.placeholders.api.node.parent.HoverNode;
import eu.pb4.placeholders.api.node.parent.ParentNode;
import eu.pb4.placeholders.api.node.parent.ParentTextNode;
import eu.pb4.placeholders.api.node.parent.StyledNode;
import java.lang.runtime.SwitchBootstraps;
import java.util.ArrayList;
import java.util.Objects;
import java.util.function.BiFunction;
import java.util.function.Function;
import java.util.function.Predicate;
import net.fabricmc.loader.api.FabricLoader;
import net.minecraft.class_10104;
import net.minecraft.class_11722;
import net.minecraft.class_124;
import net.minecraft.class_1799;
import net.minecraft.class_2558;
import net.minecraft.class_2561;
import net.minecraft.class_2568;
import net.minecraft.class_2572;
import net.minecraft.class_2574;
import net.minecraft.class_2578;
import net.minecraft.class_2579;
import net.minecraft.class_2583;
import net.minecraft.class_2588;
import net.minecraft.class_5250;
import net.minecraft.class_5251;
import net.minecraft.class_7417;
import net.minecraft.class_8828;
import net.minecraft.class_9334;
import org.jetbrains.annotations.ApiStatus;
import org.jetbrains.annotations.Nullable;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@ApiStatus.Internal
public class GeneralUtils {
    public static final Logger LOGGER = LoggerFactory.getLogger((String)"Text Placeholder API");
    public static final boolean IS_DEV = FabricLoader.getInstance().isDevelopmentEnvironment();
    public static final TextNode[] CASTER = new TextNode[0];

    public static String durationToString(long x) {
        long seconds = x % 60L;
        long minutes = x / 60L % 60L;
        long hours = x / 3600L % 24L;
        long days = x / 86400L;
        if (days > 0L) {
            return String.format("%dd%dh%dm%ds", days, hours, minutes, seconds);
        }
        if (hours > 0L) {
            return String.format("%dh%dm%ds", hours, minutes, seconds);
        }
        if (minutes > 0L) {
            return String.format("%dm%ds", minutes, seconds);
        }
        if (seconds > 0L) {
            return String.format("%ds", seconds);
        }
        return "---";
    }

    public static boolean isEmpty(class_2561 text) {
        class_8828.class_2585 l;
        class_7417 class_74172;
        return (text.method_10851() == class_8828.field_46625 || (class_74172 = text.method_10851()) instanceof class_8828.class_2585 && (l = (class_8828.class_2585)class_74172).comp_737().isEmpty()) && text.method_10855().isEmpty();
    }

    public static class_5250 toGradient(class_2561 base, GradientNode.GradientProvider posToColor) {
        return GeneralUtils.recursiveGradient(base, posToColor, 0, GeneralUtils.getGradientLength(base), text -> text.method_10866().method_10973() == null, class_2583::method_27703, class_2561::method_27661).text();
    }

    public static class_5250 toGradientShadow(class_2561 base, float scale, float alpha, GradientNode.GradientProvider posToColor) {
        return GeneralUtils.recursiveGradient(base, posToColor, 0, GeneralUtils.getGradientLength(base), text -> text.method_10866().method_65301() == null && text.method_10866().method_10973() == null, (style, textColor) -> style.method_65302(DynamicShadowNode.modifiedColor(textColor.method_27716(), scale, alpha)), text2 -> text2.method_10866().method_65301() != null ? text2.method_27661() : GeneralUtils.cloneTransformText(text2, text -> {
            class_5251 color = text.method_10866().method_10973();
            return text.method_10862(text.method_10866().method_65302(DynamicShadowNode.modifiedColor(Objects.requireNonNull(color).method_27716(), scale, alpha)));
        }, text -> text == text2 || text.method_10866().method_65301() == null && text.method_10866().method_10973() != null)).text();
    }

    private static int getGradientLength(class_2561 base) {
        int n;
        class_7417 class_74172 = base.method_10851();
        if (class_74172 instanceof class_8828.class_2585) {
            class_8828.class_2585 l = (class_8828.class_2585)class_74172;
            n = l.comp_737().codePointCount(0, l.comp_737().length());
        } else {
            n = base.method_10851() == class_8828.field_46625 ? 0 : 1;
        }
        int length = n;
        for (class_2561 text : base.method_10855()) {
            length += GeneralUtils.getGradientLength(text);
        }
        return length;
    }

    private static TextLengthPair recursiveGradient(class_2561 base, GradientNode.GradientProvider posToColor, int pos, int totalLength, Predicate<class_2561> canContinue, BiFunction<class_2583, class_5251, class_2583> apply, Function<class_2561, class_5250> passthroughApply) {
        if (canContinue.test(base)) {
            class_5250 out = class_2561.method_43473().method_10862(base.method_10866());
            class_7417 class_74172 = base.method_10851();
            if (class_74172 instanceof class_8828.class_2585) {
                class_8828.class_2585 literalTextContent = (class_8828.class_2585)class_74172;
                int l = literalTextContent.comp_737().length();
                for (int i = 0; i < l; ++i) {
                    char next;
                    int character = literalTextContent.comp_737().charAt(i);
                    int value = Character.isHighSurrogate((char)character) && i + 1 < l ? (Character.isLowSurrogate(next = literalTextContent.comp_737().charAt(++i)) ? Character.toCodePoint((char)character, next) : character) : character;
                    out.method_10852((class_2561)class_2561.method_43470((String)Character.toString(value)).method_10862(apply.apply(class_2583.field_24360, posToColor.getColorAt(pos++, totalLength))));
                }
            } else if (base.method_10851() != class_8828.field_46625) {
                out.method_10852((class_2561)base.method_27662().method_10862(apply.apply(class_2583.field_24360, posToColor.getColorAt(pos++, totalLength))));
            }
            for (class_2561 sibling : base.method_10855()) {
                TextLengthPair pair = GeneralUtils.recursiveGradient(sibling, posToColor, pos, totalLength, canContinue, apply, passthroughApply);
                pos = pair.length;
                out.method_10852((class_2561)pair.text);
            }
            return new TextLengthPair(out, pos);
        }
        return new TextLengthPair(passthroughApply.apply(base), pos + base.getString().length());
    }

    public static int rgbToInt(float r, float g, float b) {
        return ((int)(r * 255.0f) & 0xFF) << 16 | ((int)(g * 255.0f) & 0xFF) << 8 | (int)(b * 255.0f) & 0xFF;
    }

    public static class_2561 deepTransform(class_2561 input) {
        class_5250 output = GeneralUtils.cloneText(input);
        GeneralUtils.removeHoverAndClick(output);
        return output;
    }

    public static class_2561 removeHoverAndClick(class_2561 input) {
        class_5250 output = GeneralUtils.cloneText(input);
        GeneralUtils.removeHoverAndClick(output);
        return output;
    }

    private static void removeHoverAndClick(class_5250 input) {
        class_7417 class_74172;
        if (input.method_10866() != null) {
            input.method_10862(input.method_10866().method_10949(null).method_10958(null));
        }
        if ((class_74172 = input.method_10851()) instanceof class_2588) {
            class_2588 text = (class_2588)class_74172;
            for (int i = 0; i < text.method_11023().length; ++i) {
                Object arg = text.method_11023()[i];
                if (!(arg instanceof class_5250)) continue;
                class_5250 argText = (class_5250)arg;
                GeneralUtils.removeHoverAndClick(argText);
            }
        }
        for (class_2561 sibling : input.method_10855()) {
            GeneralUtils.removeHoverAndClick((class_5250)sibling);
        }
    }

    public static class_5250 cloneText(class_2561 input) {
        class_5250 baseText;
        class_7417 class_74172 = input.method_10851();
        if (class_74172 instanceof class_2588) {
            class_2588 translatable = (class_2588)class_74172;
            ArrayList<Object> obj = new ArrayList<Object>();
            for (Object arg : translatable.method_11023()) {
                if (arg instanceof class_2561) {
                    class_2561 argText = (class_2561)arg;
                    obj.add(GeneralUtils.cloneText(argText));
                    continue;
                }
                obj.add(arg);
            }
            baseText = class_2561.method_43469((String)translatable.method_11022(), (Object[])obj.toArray());
        } else {
            baseText = input.method_27662();
        }
        for (class_2561 sibling : input.method_10855()) {
            baseText.method_10852((class_2561)GeneralUtils.cloneText(sibling));
        }
        baseText.method_10862(input.method_10866());
        return baseText;
    }

    public static class_5250 cloneTransformText(class_2561 input, Function<class_5250, class_5250> transform) {
        return GeneralUtils.cloneTransformText(input, transform, text -> true);
    }

    public static class_5250 cloneTransformText(class_2561 input, Function<class_5250, class_5250> transform, Predicate<class_2561> canContinue) {
        class_5250 baseText;
        if (!canContinue.test(input)) {
            return input.method_27661();
        }
        class_7417 class_74172 = input.method_10851();
        if (class_74172 instanceof class_2588) {
            class_2588 translatable = (class_2588)class_74172;
            ArrayList<Object> obj = new ArrayList<Object>();
            for (Object arg : translatable.method_11023()) {
                if (arg instanceof class_2561) {
                    class_2561 argText = (class_2561)arg;
                    obj.add(GeneralUtils.cloneTransformText(argText, transform));
                    continue;
                }
                obj.add(arg);
            }
            baseText = class_2561.method_43469((String)translatable.method_11022(), (Object[])obj.toArray());
        } else {
            baseText = input.method_27662();
        }
        for (class_2561 sibling : input.method_10855()) {
            baseText.method_10852((class_2561)GeneralUtils.cloneTransformText(sibling, transform, canContinue));
        }
        baseText.method_10862(input.method_10866());
        return transform.apply(baseText);
    }

    public static class_2561 getItemText(class_1799 stack, boolean rarity) {
        if (!stack.method_7960()) {
            class_5250 mutableText = class_2561.method_43473().method_10852(stack.method_7964());
            if (stack.method_57826(class_9334.field_49631)) {
                mutableText.method_27692(class_124.field_1056);
            }
            if (rarity) {
                mutableText.method_27692(stack.method_7932().method_58413());
            }
            mutableText.method_27694(style -> style.method_10949((class_2568)new class_2568.class_10612(stack)));
            return mutableText;
        }
        return class_2561.method_43473().method_10852(class_1799.field_8037.method_7964());
    }

    public static ParentNode convertToNodes(class_2561 input) {
        ArrayList<TextNode> list = new ArrayList<TextNode>();
        class_7417 class_74172 = input.method_10851();
        if (class_74172 instanceof class_8828.class_2585) {
            class_8828.class_2585 content = (class_8828.class_2585)class_74172;
            list.add(new LiteralNode(content.comp_737()));
        } else {
            class_74172 = input.method_10851();
            if (class_74172 instanceof class_2588) {
                class_2588 content = (class_2588)class_74172;
                ArrayList<Object> args = new ArrayList<Object>();
                for (Object arg : content.method_11023()) {
                    if (arg instanceof class_2561) {
                        class_2561 text = (class_2561)arg;
                        args.add(GeneralUtils.convertToNodes(text));
                        continue;
                    }
                    if (arg instanceof String) {
                        String s = (String)arg;
                        args.add(new LiteralNode(s));
                        continue;
                    }
                    args.add(arg);
                }
                list.add(TranslatedNode.ofFallback(content.method_11022(), content.method_48323(), args.toArray()));
            } else {
                class_74172 = input.method_10851();
                if (class_74172 instanceof class_2578) {
                    class_2578 content = (class_2578)class_74172;
                    list.add(new ScoreNode((Either<class_10104, String>)content.comp_3078(), content.comp_3079()));
                } else {
                    class_74172 = input.method_10851();
                    if (class_74172 instanceof class_2572) {
                        class_2572 content = (class_2572)class_74172;
                        list.add(new KeybindNode(content.method_10901()));
                    } else {
                        class_74172 = input.method_10851();
                        if (class_74172 instanceof class_2579) {
                            class_2579 content = (class_2579)class_74172;
                            list.add(new SelectorNode(content.comp_3080(), content.comp_3081().map(GeneralUtils::convertToNodes)));
                        } else {
                            class_74172 = input.method_10851();
                            if (class_74172 instanceof class_2574) {
                                class_2574 content = (class_2574)class_74172;
                                list.add(new NbtNode(content.method_10920(), content.method_10921(), content.method_43484().map(GeneralUtils::convertToNodes), content.method_43485()));
                            } else {
                                class_74172 = input.method_10851();
                                if (class_74172 instanceof class_11722) {
                                    class_11722 content = (class_11722)class_74172;
                                    list.add(new ObjectNode(content.comp_4591()));
                                }
                            }
                        }
                    }
                }
            }
        }
        for (class_2561 child : input.method_10855()) {
            list.add(GeneralUtils.convertToNodes(child));
        }
        if (input.method_10866() == class_2583.field_24360) {
            return new ParentNode(list);
        }
        class_2583 style = input.method_10866();
        StyledNode.HoverData<?> hoverValue = style.method_10969() != null ? GeneralUtils.getHoverValue(style) : null;
        TextNode clickValue = style.method_10970() != null ? GeneralUtils.getClickValue(style) : null;
        LiteralNode insertion = style.method_10955() != null ? new LiteralNode(style.method_10955()) : null;
        return new StyledNode(list.toArray(new TextNode[0]), style, hoverValue, clickValue, (TextNode)insertion);
    }

    private static StyledNode.HoverData<?> getHoverValue(class_2583 style) {
        if (style.method_10969() != null) {
            class_2568 class_25682 = style.method_10969();
            if (class_25682 instanceof class_2568.class_10613) {
                class_2568.class_10613 showText = (class_2568.class_10613)class_25682;
                return new StyledNode.HoverData<ParentNode>(HoverNode.Action.TEXT_NODE, GeneralUtils.convertToNodes(showText.comp_3510()));
            }
            class_25682 = style.method_10969();
            if (class_25682 instanceof class_2568.class_10611) {
                class_2568.class_10611 showEntity = (class_2568.class_10611)class_25682;
                return new StyledNode.HoverData<HoverNode.EntityNodeContent>(HoverNode.Action.ENTITY_NODE, new HoverNode.EntityNodeContent(showEntity.comp_3508().field_24351, showEntity.comp_3508().field_24352, showEntity.comp_3508().field_24353.map(GeneralUtils::convertToNodes).orElse(null)));
            }
            class_25682 = style.method_10969();
            if (class_25682 instanceof class_2568.class_10612) {
                class_2568.class_10612 showItem = (class_2568.class_10612)class_25682;
                return new StyledNode.HoverData<class_2568.class_10612>(HoverNode.Action.VANILLA_ITEM_STACK, showItem);
            }
        }
        return null;
    }

    @Nullable
    private static TextNode getClickValue(class_2583 style) {
        if (style.method_10970() != null) {
            class_2558 class_25582 = style.method_10970();
            Objects.requireNonNull(class_25582);
            class_2558 class_25583 = class_25582;
            int n = 0;
            return switch (SwitchBootstraps.typeSwitch("typeSwitch", new Object[]{class_2558.class_10605.class, class_2558.class_10606.class, class_2558.class_10607.class, class_2558.class_10608.class, class_2558.class_10609.class, class_2558.class_10610.class}, (Object)class_25583, n)) {
                case 0 -> {
                    class_2558.class_10605 event = (class_2558.class_10605)class_25583;
                    yield TextNode.of(String.valueOf(event.comp_3502()));
                }
                case 1 -> {
                    class_2558.class_10606 event = (class_2558.class_10606)class_25583;
                    yield TextNode.of(event.comp_3503());
                }
                case 2 -> {
                    class_2558.class_10607 openFile = (class_2558.class_10607)class_25583;
                    yield TextNode.of(openFile.method_66568().getPath());
                }
                case 3 -> {
                    class_2558.class_10608 openUrl = (class_2558.class_10608)class_25583;
                    yield TextNode.of(openUrl.comp_3505().toString());
                }
                case 4 -> {
                    class_2558.class_10609 runCommand = (class_2558.class_10609)class_25583;
                    yield TextNode.of(runCommand.comp_3506());
                }
                case 5 -> {
                    class_2558.class_10610 suggestCommand = (class_2558.class_10610)class_25583;
                    yield TextNode.of(suggestCommand.comp_3507());
                }
                default -> null;
            };
        }
        return null;
    }

    public static TextNode removeColors(TextNode node) {
        if (node instanceof ParentTextNode) {
            ParentTextNode parentNode = (ParentTextNode)node;
            ArrayList<TextNode> list = new ArrayList<TextNode>();
            for (TextNode child : parentNode.getChildren()) {
                list.add(GeneralUtils.removeColors(child));
            }
            if (node instanceof ColorNode || node instanceof FormattingNode) {
                return new ParentNode(list.toArray(new TextNode[0]));
            }
            if (node instanceof StyledNode) {
                StyledNode styledNode = (StyledNode)node;
                return new StyledNode(list.toArray(new TextNode[0]), styledNode.rawStyle().method_27703((class_5251)null), styledNode.hover(), styledNode.clickValue(), styledNode.insertion());
            }
            return parentNode.copyWith(list.toArray(new TextNode[0]));
        }
        return node;
    }

    public record TextLengthPair(class_5250 text, int length) {
        public static final TextLengthPair EMPTY = new TextLengthPair(null, 0);
    }

    public record MutableTransformer(Function<class_2583, class_2583> textMutableTextFunction) implements Function<class_5250, class_2561>
    {
        public static final MutableTransformer CLEAR = new MutableTransformer(x -> class_2583.field_24360);

        @Override
        public class_2561 apply(class_5250 text) {
            return GeneralUtils.cloneTransformText((class_2561)text, this::transformStyle);
        }

        private class_5250 transformStyle(class_5250 mutableText) {
            return mutableText.method_10862(this.textMutableTextFunction.apply(mutableText.method_10866()));
        }
    }

    public record Pair<L, R>(L left, R right) {
    }
}

