/*
 * Decompiled with CFR 0.152.
 */
package xaero.pac.common.event;

import com.mojang.brigadier.CommandDispatcher;
import java.util.List;
import net.fabricmc.fabric.api.command.v2.CommandRegistrationCallback;
import net.fabricmc.fabric.api.entity.event.v1.ServerEntityWorldChangeEvents;
import net.fabricmc.fabric.api.entity.event.v1.ServerPlayerEvents;
import net.fabricmc.fabric.api.event.Event;
import net.fabricmc.fabric.api.event.lifecycle.v1.ServerLifecycleEvents;
import net.fabricmc.fabric.api.event.lifecycle.v1.ServerTickEvents;
import net.fabricmc.fabric.api.event.player.AttackBlockCallback;
import net.fabricmc.fabric.api.event.player.AttackEntityCallback;
import net.fabricmc.fabric.api.event.player.PlayerBlockBreakEvents;
import net.fabricmc.fabric.api.event.player.UseBlockCallback;
import net.fabricmc.fabric.api.event.player.UseEntityCallback;
import net.fabricmc.fabric.api.event.player.UseItemCallback;
import net.minecraft.class_11560;
import net.minecraft.class_1268;
import net.minecraft.class_1269;
import net.minecraft.class_1282;
import net.minecraft.class_1297;
import net.minecraft.class_1657;
import net.minecraft.class_1799;
import net.minecraft.class_1927;
import net.minecraft.class_1936;
import net.minecraft.class_1937;
import net.minecraft.class_2168;
import net.minecraft.class_2170;
import net.minecraft.class_2338;
import net.minecraft.class_2350;
import net.minecraft.class_239;
import net.minecraft.class_243;
import net.minecraft.class_2586;
import net.minecraft.class_2680;
import net.minecraft.class_2960;
import net.minecraft.class_3218;
import net.minecraft.class_3222;
import net.minecraft.class_3324;
import net.minecraft.class_3730;
import net.minecraft.class_3965;
import net.minecraft.class_3966;
import net.minecraft.class_4076;
import net.minecraft.class_7157;
import net.minecraft.class_9892;
import net.minecraft.server.MinecraftServer;
import org.jetbrains.annotations.Nullable;
import xaero.pac.OpenPartiesAndClaims;
import xaero.pac.common.claims.player.IPlayerChunkClaim;
import xaero.pac.common.claims.player.IPlayerClaimPosList;
import xaero.pac.common.claims.player.IPlayerDimensionClaims;
import xaero.pac.common.claims.tracker.api.IClaimsManagerTrackerRegisterAPI;
import xaero.pac.common.event.CommonEvents;
import xaero.pac.common.event.api.OPACServerAddonRegister;
import xaero.pac.common.mods.ModSupportFabric;
import xaero.pac.common.parties.party.IPartyPlayerInfo;
import xaero.pac.common.parties.party.ally.IPartyAlly;
import xaero.pac.common.parties.party.member.IPartyMember;
import xaero.pac.common.server.IServerData;
import xaero.pac.common.server.claims.IServerClaimsManager;
import xaero.pac.common.server.claims.IServerDimensionClaimsManager;
import xaero.pac.common.server.claims.IServerRegionClaims;
import xaero.pac.common.server.claims.player.IServerPlayerClaimInfo;
import xaero.pac.common.server.core.ServerCoreFabric;
import xaero.pac.common.server.parties.party.IServerParty;
import xaero.pac.common.server.parties.system.api.IPlayerPartySystemRegisterAPI;
import xaero.pac.common.server.player.permission.api.IPlayerPermissionSystemRegisterAPI;
import xaero.pac.common.server.world.ServerLevelHelper;

public class CommonEventsFabric
extends CommonEvents {
    private final class_2960 PROTECTION_PHASE = class_2960.method_60655((String)"openpartiesandclaims", (String)"protection");

    public CommonEventsFabric(OpenPartiesAndClaims modMain) {
        super(modMain);
    }

    public void registerFabricAPIEvents() {
        AttackBlockCallback.EVENT.addPhaseOrdering(this.PROTECTION_PHASE, Event.DEFAULT_PHASE);
        PlayerBlockBreakEvents.BEFORE.addPhaseOrdering(this.PROTECTION_PHASE, Event.DEFAULT_PHASE);
        UseBlockCallback.EVENT.addPhaseOrdering(this.PROTECTION_PHASE, Event.DEFAULT_PHASE);
        UseItemCallback.EVENT.addPhaseOrdering(this.PROTECTION_PHASE, Event.DEFAULT_PHASE);
        UseEntityCallback.EVENT.addPhaseOrdering(this.PROTECTION_PHASE, Event.DEFAULT_PHASE);
        AttackEntityCallback.EVENT.addPhaseOrdering(this.PROTECTION_PHASE, Event.DEFAULT_PHASE);
        ServerPlayerEvents.AFTER_RESPAWN.register(this::onPlayerRespawn);
        ServerPlayerEvents.COPY_FROM.register(this::onPlayerClone);
        ServerLifecycleEvents.SERVER_STARTED.register(this::onServerStarting);
        ServerLifecycleEvents.SERVER_STOPPED.register(this::onServerStopped);
        ServerEntityWorldChangeEvents.AFTER_PLAYER_CHANGE_WORLD.register(this::onPlayerChangedDimension);
        ServerTickEvents.START_SERVER_TICK.register(server -> this.onServerTick(server, true));
        ServerTickEvents.END_SERVER_TICK.register(server -> this.onServerTick(server, false));
        CommandRegistrationCallback.EVENT.register(this::onRegisterCommands);
        AttackBlockCallback.EVENT.register(this.PROTECTION_PHASE, this::onLeftClickBlock);
        PlayerBlockBreakEvents.BEFORE.register(this.PROTECTION_PHASE, this::onDestroyBlock);
        UseBlockCallback.EVENT.register(this.PROTECTION_PHASE, this::onRightClickBlock);
        UseItemCallback.EVENT.register(this.PROTECTION_PHASE, this::onItemRightClick);
        UseEntityCallback.EVENT.register(this.PROTECTION_PHASE, this::onEntityInteract);
        AttackEntityCallback.EVENT.register(this.PROTECTION_PHASE, this::onEntityAttack);
        OPACServerAddonRegister.EVENT.register(this::onAddonRegister);
    }

    @Override
    public void onServerAboutToStart(MinecraftServer server) throws Throwable {
        super.onServerAboutToStart(server);
    }

    @Override
    public void onServerStarting(MinecraftServer server) {
        super.onServerStarting(server);
    }

    private void onPlayerRespawn(class_3222 oldPlayer, class_3222 newPlayer, boolean alive) {
        super.onPlayerRespawn((class_1657)newPlayer);
    }

    private void onPlayerChangedDimension(class_3222 serverPlayer, class_3218 serverLevel, class_3218 serverLevel1) {
        super.onPlayerChangedDimension((class_1657)serverPlayer);
    }

    public void onPlayerLogIn(class_3222 player) {
        super.onPlayerLogIn((class_1657)player);
    }

    private void onPlayerClone(class_3222 oldPlayer, class_3222 newPlayer, boolean alive) {
        super.onPlayerClone((class_1657)oldPlayer, (class_1657)newPlayer);
    }

    public void onPlayerLogOut(class_3222 player) {
        super.onPlayerLogOut((class_1657)player);
    }

    @Override
    public void onServerTick(MinecraftServer server, boolean isTickStart) {
        try {
            super.onServerTick(server, isTickStart);
        }
        catch (Throwable e) {
            throw new RuntimeException(e);
        }
    }

    public void onPlayerTick(boolean isTickStart, class_1657 player) {
        try {
            super.onPlayerTick(isTickStart, player instanceof class_3222, player);
        }
        catch (Throwable e) {
            throw new RuntimeException(e);
        }
    }

    @Override
    public void onServerStopped(MinecraftServer server) {
        super.onServerStopped(server);
        ServerCoreFabric.reset();
    }

    private void onRegisterCommands(CommandDispatcher<class_2168> dispatcher, class_7157 commandBuildContext, class_2170.class_5364 commandSelection) {
        super.onRegisterCommands(dispatcher, commandSelection);
    }

    private class_1269 onLeftClickBlock(class_1657 player, class_1937 level, class_1268 interactionHand, class_2338 blockPos, class_2350 direction) {
        if (super.onLeftClickBlock(level, blockPos, player)) {
            return class_1269.field_5814;
        }
        return class_1269.field_5811;
    }

    private boolean onDestroyBlock(class_1937 level, class_1657 player, class_2338 blockPos, class_2680 blockState, class_2586 blockEntity) {
        return !super.onDestroyBlock((class_1936)level, blockPos, player);
    }

    private class_1269 onRightClickBlock(class_1657 player, class_1937 level, class_1268 interactionHand, class_3965 blockHitResult) {
        if (player.method_7325()) {
            return class_1269.field_5811;
        }
        if (super.onRightClickBlock(level, blockHitResult.method_17777(), player, interactionHand, blockHitResult)) {
            return class_1269.field_5814;
        }
        return class_1269.field_5811;
    }

    private class_1269 onItemRightClick(class_1657 player, class_1937 level, class_1268 interactionHand) {
        class_1799 stack = player.method_5998(interactionHand);
        if (super.onItemRightClick(level, player.method_24515(), player, interactionHand, stack)) {
            return class_1269.field_5814;
        }
        return class_1269.field_5811;
    }

    @Override
    public boolean onMobGrief(class_1297 entity) {
        return super.onMobGrief(entity);
    }

    @Override
    public boolean onLivingHurt(class_1282 source, class_1297 target) {
        return super.onLivingHurt(source, target);
    }

    private class_1269 onEntityAttack(class_1657 player, class_1937 level, class_1268 interactionHand, class_1297 entity, @Nullable class_3966 entityHitResult) {
        if (super.onEntityAttack(player, entity)) {
            return class_1269.field_5814;
        }
        return class_1269.field_5811;
    }

    public class_1269 onEntityInteract(class_1657 player, class_1937 world, class_1268 interactionHand, class_1297 entity, @Nullable class_3966 hitResult) {
        if (hitResult == null) {
            if (super.onEntityInteract((class_1297)player, entity, interactionHand)) {
                return class_1269.field_5814;
            }
            return class_1269.field_5811;
        }
        if (super.onInteractEntitySpecific((class_1297)player, entity, interactionHand)) {
            return class_1269.field_5814;
        }
        return class_1269.field_5811;
    }

    public void onExplosionDetonate(class_9892 explosion, List<class_1297> entities, class_1937 level) {
        super.onExplosionDetonate(level, (class_1927)explosion, entities, ServerCoreFabric.EXPLOSION_BLOCK_POSITIONS);
    }

    @Override
    public boolean onChorusFruit(class_1297 entity, class_243 target) {
        return super.onChorusFruit(entity, target);
    }

    @Override
    public boolean onEntityJoinWorld(class_1297 entity, class_1937 level, boolean fromDisk) {
        class_3730 mobSpawnType;
        if (!fromDisk && entity.field_6012 == 0 && (mobSpawnType = ServerCoreFabric.getMobSpawnTypeForNewEntities(ServerLevelHelper.getServer(entity))) != null) {
            return super.onMobSpawn(entity, entity.method_23317(), entity.method_23318(), entity.method_23321(), mobSpawnType);
        }
        return super.onEntityJoinWorld(entity, level, fromDisk);
    }

    public void onEntityEnteringSection(class_1297 entity, long oldSectionKey, long newSectionKey) {
        class_4076 oldSection = class_4076.method_18677((long)oldSectionKey);
        class_4076 newSection = class_4076.method_18677((long)newSectionKey);
        boolean chunkChanged = oldSection.method_18674() != newSection.method_18674() || oldSection.method_18687() != newSection.method_18687();
        super.onEntityEnteringSection(entity, oldSection, newSection, chunkChanged);
    }

    public void onPermissionsChanged(class_3324 playerList, class_11560 profile) {
        class_3222 player = playerList.method_14602(profile.comp_4422());
        if (player == null) {
            return;
        }
        super.onPermissionsChanged(player);
    }

    @Override
    public boolean onCropTrample(class_1297 entity, class_2338 pos) {
        return super.onCropTrample(entity, pos);
    }

    @Override
    public boolean onBucketUse(class_1297 entity, class_1937 level, class_239 hitResult, class_1799 itemStack) {
        return super.onBucketUse(entity, level, hitResult, itemStack);
    }

    @Override
    public void onTagsUpdate() {
        super.onTagsUpdate();
    }

    @Override
    public void onAddonRegister(MinecraftServer server, IPlayerPermissionSystemRegisterAPI permissionSystemManagerAPI, IPlayerPartySystemRegisterAPI partySystemManagerAPI, IClaimsManagerTrackerRegisterAPI claimsManagerTrackerAPI) {
        super.onAddonRegister(server, permissionSystemManagerAPI, partySystemManagerAPI, claimsManagerTrackerAPI);
        ModSupportFabric modSupportFabric = (ModSupportFabric)this.modMain.getModSupport();
        if (modSupportFabric.FABRIC_PERMISSIONS) {
            permissionSystemManagerAPI.register("permission_api", modSupportFabric.getFabricPermissionsSupport().getPermissionSystem());
        }
    }

    @Override
    protected void fireAddonRegisterEvent(IServerData<IServerClaimsManager<IPlayerChunkClaim, IServerPlayerClaimInfo<IPlayerDimensionClaims<IPlayerClaimPosList>>, IServerDimensionClaimsManager<IServerRegionClaims>>, IServerParty<IPartyMember, IPartyPlayerInfo, IPartyAlly>> serverData) {
        ((OPACServerAddonRegister)OPACServerAddonRegister.EVENT.invoker()).registerAddons(serverData.getServer(), serverData.getPlayerPermissionSystemManager(), serverData.getPlayerPartySystemManager(), serverData.getServerClaimsManager().getTracker());
    }
}

