/*
 * Decompiled with CFR 0.152.
 */
package xaero.pac.common.packet.config;

import it.unimi.dsi.fastutil.ints.Int2ObjectMap;
import it.unimi.dsi.fastutil.ints.Int2ObjectOpenHashMap;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import java.util.function.Predicate;
import net.minecraft.class_2481;
import net.minecraft.class_2487;
import net.minecraft.class_2489;
import net.minecraft.class_2494;
import net.minecraft.class_2497;
import net.minecraft.class_2499;
import net.minecraft.class_2505;
import net.minecraft.class_2519;
import net.minecraft.class_2520;
import net.minecraft.class_2540;
import xaero.pac.OpenPartiesAndClaims;
import xaero.pac.client.player.config.IPlayerConfigClientStorage;
import xaero.pac.client.player.config.IPlayerConfigClientStorageManager;
import xaero.pac.client.player.config.IPlayerConfigStringableOptionClientStorage;
import xaero.pac.common.packet.config.PlayerConfigPacket;
import xaero.pac.common.player.config.dynamic.PlayerConfigDynamicOptions;
import xaero.pac.common.server.player.config.PlayerConfigHexOptionSpec;
import xaero.pac.common.server.player.config.PlayerConfigOptionCategory;
import xaero.pac.common.server.player.config.PlayerConfigOptionSpec;
import xaero.pac.common.server.player.config.PlayerConfigRangedOptionSpec;
import xaero.pac.common.server.player.config.PlayerConfigStaticListIterationOptionSpec;
import xaero.pac.common.server.player.config.PlayerConfigStringOptionSpec;

public final class ClientboundPlayerConfigDynamicOptionsPacket
extends PlayerConfigPacket {
    private static final String DEFAULT_VALUE_KEY = "d";
    private final List<PlayerConfigOptionSpec<?>> entries;

    public ClientboundPlayerConfigDynamicOptionsPacket(List<PlayerConfigOptionSpec<?>> entries) {
        this.entries = entries;
    }

    private static <T extends Comparable<T>> ValueType<T> getEntryValueType(PlayerConfigOptionSpec<T> entry) {
        return ValueType.ALL.get(entry.getType());
    }

    private static final class ValueType<T extends Comparable<T>> {
        private static final Map<Class<?>, ValueType<?>> ALL = new HashMap();
        private static final ValueType<Boolean> BOOLEAN = new ValueType<Boolean>(Boolean.class, t -> t instanceof class_2481, t -> ((class_2481)t).method_10698() != 0, class_2481::method_23234);
        private static final ValueType<Integer> INT = new ValueType<Integer>(Integer.class, t -> t instanceof class_2497, t -> ((class_2497)t).method_10701(), class_2497::method_23247);
        private static final ValueType<Double> DOUBLE = new ValueType<Double>(Double.class, t -> t instanceof class_2489, t -> ((class_2489)t).method_10697(), class_2489::method_23241);
        private static final ValueType<Float> FLOAT = new ValueType<Float>(Float.class, t -> t instanceof class_2494, t -> Float.valueOf(((class_2494)t).method_10700()), class_2494::method_23244);
        private static final ValueType<String> STRING = new ValueType<String>(String.class, t -> t instanceof class_2519, t -> t.method_68658().orElse(null), class_2519::method_23256);
        private final Class<T> jType;
        private final Predicate<class_2520> typeCheck;
        private final Function<class_2520, T> valueUntagger;
        private final Function<T, class_2520> valueTagger;

        private ValueType(Class<T> jType, Predicate<class_2520> typeCheck, Function<class_2520, T> valueUntagger, Function<T, class_2520> valueTagger) {
            this.jType = jType;
            this.typeCheck = typeCheck;
            this.valueUntagger = valueUntagger;
            this.valueTagger = valueTagger;
            ALL.put(jType, this);
        }
    }

    public static abstract class OptionType {
        private static final Int2ObjectMap<OptionType> ALL = new Int2ObjectOpenHashMap();
        public static final OptionType DEFAULT = new OptionType(0){

            @Override
            public <T extends Comparable<T>> void serializeExtra(PlayerConfigOptionSpec<T> option, ValueType<T> type, class_2487 entryTag) {
            }

            @Override
            public <T extends Comparable<T>> PlayerConfigOptionSpec.Builder<T, ?> buildSpec(ValueType<T> type, class_2487 entryTag) {
                return PlayerConfigOptionSpec.FinalBuilder.begin(type.jType);
            }
        };
        public static final OptionType HEX = new OptionType(1){

            @Override
            public <T extends Comparable<T>> void serializeExtra(PlayerConfigOptionSpec<T> option, ValueType<T> type, class_2487 entryTag) {
            }

            @Override
            public <T extends Comparable<T>> PlayerConfigOptionSpec.Builder<T, ?> buildSpec(ValueType<T> type, class_2487 entryTag) {
                return PlayerConfigHexOptionSpec.Builder.begin();
            }
        };
        public static final OptionType RANGED = new OptionType(2){

            @Override
            public <T extends Comparable<T>> void serializeExtra(PlayerConfigOptionSpec<T> o, ValueType<T> type, class_2487 entryTag) {
                PlayerConfigRangedOptionSpec option = (PlayerConfigRangedOptionSpec)o;
                Object minValue = option.getMinValue();
                Object maxValue = option.getMaxValue();
                class_2520 minTag = type.valueTagger.apply(minValue);
                class_2520 maxTag = type.valueTagger.apply(maxValue);
                entryTag.method_10566("min", minTag);
                entryTag.method_10566("max", maxTag);
            }

            @Override
            public <T extends Comparable<T>> PlayerConfigOptionSpec.Builder<T, ?> buildSpec(ValueType<T> type, class_2487 entryTag) {
                PlayerConfigRangedOptionSpec.Builder<Comparable> builder = PlayerConfigRangedOptionSpec.Builder.begin(type.jType);
                class_2520 minValueTag = entryTag.method_10580("min");
                class_2520 maxValueTag = entryTag.method_10580("max");
                builder.setMinValue((Comparable)type.valueUntagger.apply(minValueTag));
                builder.setMaxValue((Comparable)type.valueUntagger.apply(maxValueTag));
                return builder;
            }
        };
        public static final OptionType STRING = new OptionType(3){

            @Override
            public <T extends Comparable<T>> void serializeExtra(PlayerConfigOptionSpec<T> o, ValueType<T> type, class_2487 entryTag) {
                PlayerConfigStringOptionSpec option = (PlayerConfigStringOptionSpec)o;
                entryTag.method_10569("ml", option.getMaxLength());
            }

            @Override
            public <T extends Comparable<T>> PlayerConfigOptionSpec.Builder<T, ?> buildSpec(ValueType<T> type, class_2487 entryTag) {
                PlayerConfigStringOptionSpec.Builder builder = PlayerConfigStringOptionSpec.Builder.begin();
                builder.setMaxLength(entryTag.method_68083("ml", 0));
                PlayerConfigStringOptionSpec.Builder result = builder;
                return result;
            }
        };
        public static final OptionType STATIC_LIST = new OptionType(4){

            @Override
            public <T extends Comparable<T>> void serializeExtra(PlayerConfigOptionSpec<T> o, ValueType<T> type, class_2487 entryTag) {
                PlayerConfigStaticListIterationOptionSpec option = (PlayerConfigStaticListIterationOptionSpec)o;
                class_2499 iterationListTag = new class_2499();
                for (Comparable el : option.getList()) {
                    iterationListTag.add((Object)type.valueTagger.apply(el));
                }
                entryTag.method_10566("il", (class_2520)iterationListTag);
            }

            @Override
            public <T extends Comparable<T>> PlayerConfigOptionSpec.Builder<T, ?> buildSpec(ValueType<T> type, class_2487 entryTag) {
                PlayerConfigStaticListIterationOptionSpec.Builder builder = PlayerConfigStaticListIterationOptionSpec.Builder.begin(type.jType);
                class_2499 iterationListTag = (class_2499)entryTag.method_10580("il");
                ArrayList<Comparable> list = new ArrayList<Comparable>(iterationListTag.size());
                for (class_2520 elTag : iterationListTag) {
                    list.add((Comparable)type.valueUntagger.apply(elTag));
                }
                builder.setList(list);
                return builder;
            }
        };
        public static final OptionType UNSYNCABLE = new OptionType(5){

            @Override
            public <T extends Comparable<T>> void serializeExtra(PlayerConfigOptionSpec<T> option, ValueType<T> type, class_2487 entryTag) {
            }

            @Override
            public <T extends Comparable<T>> PlayerConfigOptionSpec.Builder<T, ?> buildSpec(ValueType<T> type, class_2487 entryTag) {
                return null;
            }
        };
        private final int index;

        protected OptionType(int index) {
            this.index = index;
            ALL.put(index, (Object)this);
        }

        public abstract <T extends Comparable<T>> void serializeExtra(PlayerConfigOptionSpec<T> var1, ValueType<T> var2, class_2487 var3);

        public abstract <T extends Comparable<T>> PlayerConfigOptionSpec.Builder<T, ?> buildSpec(ValueType<T> var1, class_2487 var2);
    }

    public static class ClientHandler
    implements Consumer<ClientboundPlayerConfigDynamicOptionsPacket> {
        @Override
        public void accept(ClientboundPlayerConfigDynamicOptionsPacket packet) {
            PlayerConfigDynamicOptions.Builder dynamicOptionsBuilder = PlayerConfigDynamicOptions.Builder.begin();
            packet.entries.forEach(dynamicOptionsBuilder::addOption);
            PlayerConfigDynamicOptions dynamicOptions = dynamicOptionsBuilder.build();
            IPlayerConfigClientStorageManager<IPlayerConfigClientStorage<IPlayerConfigStringableOptionClientStorage<?>>> playerConfigStorageManager = OpenPartiesAndClaims.INSTANCE.getClientDataInternal().getPlayerConfigStorageManager();
            playerConfigStorageManager.setDynamicOptions(dynamicOptions);
        }
    }

    public static class Codec
    implements BiConsumer<ClientboundPlayerConfigDynamicOptionsPacket, class_2540>,
    Function<class_2540, ClientboundPlayerConfigDynamicOptionsPacket> {
        private <T extends Comparable<T>> PlayerConfigOptionSpec<T> getEntry(OptionType optionType, class_2487 entryTag, class_2520 defaultValueTag, ValueType<T> type, String id, String translation, String[] translationArgs, String commentTranslation, String[] commentTranslationArgs, String comment, PlayerConfigOptionCategory category) {
            return ((PlayerConfigOptionSpec.Builder)((PlayerConfigOptionSpec.Builder)((PlayerConfigOptionSpec.Builder)((PlayerConfigOptionSpec.Builder)((PlayerConfigOptionSpec.Builder)((PlayerConfigOptionSpec.Builder)((PlayerConfigOptionSpec.Builder)optionType.buildSpec(type, entryTag).setId(id)).setTranslation(translation, translationArgs)).setCommentTranslation(commentTranslation, commentTranslationArgs)).setDefaultValue((Comparable)((Comparable)type.valueUntagger.apply(defaultValueTag)))).setComment(comment)).setCategory(category)).setDynamic(true)).build(null);
        }

        @Override
        public ClientboundPlayerConfigDynamicOptionsPacket apply(class_2540 friendlyByteBuf) {
            try {
                if (friendlyByteBuf.readableBytes() > 0x20000000) {
                    return null;
                }
                class_2487 tag = (class_2487)friendlyByteBuf.method_30616(class_2505.method_53898());
                if (tag == null) {
                    return null;
                }
                class_2499 entryListTag = tag.method_68569("l");
                ArrayList entries = new ArrayList(entryListTag.size());
                entryListTag.forEach(t -> {
                    class_2487 entryTag = (class_2487)t;
                    int optionTypeIndex = entryTag.method_68083("ot", 0);
                    OptionType optionType = (OptionType)OptionType.ALL.get(optionTypeIndex);
                    String id = entryTag.method_68564("i", null);
                    String translation = entryTag.method_68564("t", null);
                    String commentTranslation = entryTag.method_68564("ct", null);
                    String comment = entryTag.method_68564("c", null);
                    class_2499 translationArgsTag = entryTag.method_68569("ta");
                    String[] translationArgs = new String[translationArgsTag.size()];
                    for (int i = 0; i < translationArgs.length; ++i) {
                        translationArgs[i] = translationArgsTag.method_68577(i, null);
                    }
                    class_2499 commentTranslationArgsTag = entryTag.method_68569("cta");
                    String[] commentTranslationArgs = new String[commentTranslationArgsTag.size()];
                    for (int i = 0; i < commentTranslationArgs.length; ++i) {
                        commentTranslationArgs[i] = commentTranslationArgsTag.method_68577(i, null);
                    }
                    PlayerConfigOptionCategory category = PlayerConfigOptionCategory.values()[entryTag.method_68083("cat", 0)];
                    class_2520 defaultValueTag = entryTag.method_10580(ClientboundPlayerConfigDynamicOptionsPacket.DEFAULT_VALUE_KEY);
                    PlayerConfigOptionSpec<?> entry = null;
                    for (ValueType<?> valueType : ValueType.ALL.values()) {
                        if (!valueType.typeCheck.test(defaultValueTag)) continue;
                        entry = this.getEntry(optionType, entryTag, defaultValueTag, valueType, id, translation, translationArgs, commentTranslation, commentTranslationArgs, comment, category);
                        break;
                    }
                    if (entry != null) {
                        entries.add(entry);
                    }
                });
                return new ClientboundPlayerConfigDynamicOptionsPacket(entries);
            }
            catch (Throwable t2) {
                return null;
            }
        }

        private <T extends Comparable<T>> void handleValueAndOptionTypes(PlayerConfigOptionSpec<T> entry, class_2487 entryTag) {
            ValueType<T> valueType = ClientboundPlayerConfigDynamicOptionsPacket.getEntryValueType(entry);
            class_2520 valueTag = valueType.valueTagger.apply(entry.getDefaultValue());
            entryTag.method_10566(ClientboundPlayerConfigDynamicOptionsPacket.DEFAULT_VALUE_KEY, valueTag);
            entry.getSyncOptionType().serializeExtra(entry, valueType, entryTag);
        }

        @Override
        public void accept(ClientboundPlayerConfigDynamicOptionsPacket packet, class_2540 friendlyByteBuf) {
            class_2487 tag = new class_2487();
            class_2499 entryListTag = new class_2499();
            for (PlayerConfigOptionSpec<?> entry : packet.entries) {
                class_2487 entryTag = new class_2487();
                entryTag.method_10569("ot", entry.getSyncOptionType().index);
                entryTag.method_10582("i", entry.getId());
                entryTag.method_10582("t", entry.getTranslation());
                entryTag.method_10582("ct", entry.getCommentTranslation());
                entryTag.method_10582("c", entry.getComment());
                class_2499 translationArgsTag = new class_2499();
                for (String translationArg : entry.getTranslationArgs()) {
                    translationArgsTag.add((Object)class_2519.method_23256((String)translationArg));
                }
                entryTag.method_10566("ta", (class_2520)translationArgsTag);
                class_2499 commentTranslationArgsTag = new class_2499();
                for (String translationArg : entry.getCommentTranslationArgs()) {
                    commentTranslationArgsTag.add((Object)class_2519.method_23256((String)translationArg));
                }
                entryTag.method_10566("cta", (class_2520)commentTranslationArgsTag);
                entryTag.method_10569("cat", entry.getCategory().ordinal());
                this.handleValueAndOptionTypes(entry, entryTag);
                entryListTag.add((Object)entryTag);
            }
            tag.method_10566("l", (class_2520)entryListTag);
            friendlyByteBuf.method_10794((class_2520)tag);
        }
    }
}

