/*
 * Decompiled with CFR 0.152.
 */
package xaero.pac.common.server.claims.protection.group;

import com.mojang.datafixers.util.Either;
import java.util.regex.Pattern;
import java.util.stream.Stream;
import net.minecraft.class_6862;
import net.minecraft.server.MinecraftServer;
import xaero.pac.common.server.claims.protection.ChunkProtectionExceptionSet;
import xaero.pac.common.server.claims.protection.ChunkProtectionExceptionType;
import xaero.pac.common.server.claims.protection.ExceptionElementType;
import xaero.pac.common.server.player.config.PlayerConfigOptionCategory;
import xaero.pac.common.server.player.config.api.IPlayerConfigOptionSpecAPI;

public final class ChunkProtectionExceptionGroup<T> {
    public static final Pattern GROUP_NAME_PATTERN = Pattern.compile("[a-zA-Z\\d_\\-]{1,32}");
    private final String name;
    private final ChunkProtectionExceptionType type;
    private final ChunkProtectionExceptionSet<T> exceptionSet;
    private IPlayerConfigOptionSpecAPI<Integer> playerConfigOption;
    private final String contentString;
    private final PlayerConfigOptionCategory optionCategory;
    private final boolean ofSubjects;
    private final Class<?> subjectType;

    private ChunkProtectionExceptionGroup(String name, ChunkProtectionExceptionType type, ChunkProtectionExceptionSet<T> exceptionSet, String contentString, PlayerConfigOptionCategory optionCategory, boolean ofSubjects, Class<?> subjectType) {
        this.name = name;
        this.type = type;
        this.exceptionSet = exceptionSet;
        this.contentString = contentString;
        this.optionCategory = optionCategory;
        this.ofSubjects = ofSubjects;
        this.subjectType = subjectType;
    }

    public String getName() {
        return this.name;
    }

    public ChunkProtectionExceptionType getType() {
        return this.type;
    }

    public boolean contains(T object) {
        return this.exceptionSet.contains(object);
    }

    public void updateTagExceptions(MinecraftServer server) {
        this.exceptionSet.updateTagExceptions(server);
    }

    public void setPlayerConfigOption(IPlayerConfigOptionSpecAPI<Integer> playerConfigOption) {
        this.playerConfigOption = playerConfigOption;
    }

    public IPlayerConfigOptionSpecAPI<Integer> getPlayerConfigOption() {
        return this.playerConfigOption;
    }

    public Stream<Either<T, class_6862<T>>> stream() {
        return this.exceptionSet.stream();
    }

    public String getContentString() {
        return this.contentString;
    }

    public PlayerConfigOptionCategory getOptionCategory() {
        return this.optionCategory;
    }

    public boolean isOfSubjects() {
        return this.ofSubjects;
    }

    public ExceptionElementType<T> getElementType() {
        return this.exceptionSet.getElementType();
    }

    public Class<?> getSubjectType() {
        return this.subjectType;
    }

    public static final class Builder<T> {
        private String name;
        private ChunkProtectionExceptionType type;
        private ChunkProtectionExceptionSet.Builder<T> exceptionSetBuilder;
        private String contentString;
        private PlayerConfigOptionCategory optionCategory;
        private boolean ofSubjects;
        private ExceptionElementType<T> elementType;
        private Class<?> subjectType;

        private Builder(ExceptionElementType<T> elementType) {
            this.elementType = elementType;
            this.exceptionSetBuilder = ChunkProtectionExceptionSet.Builder.begin(elementType);
        }

        private Builder<T> setDefault() {
            this.setOfSubjects(true);
            this.setSubjectType(this.elementType.getType());
            this.setName(null);
            this.setType(null);
            this.exceptionSetBuilder.setDefault();
            return this;
        }

        public Builder<T> setSubjectType(Class<?> subjectType) {
            this.subjectType = subjectType;
            return this;
        }

        public Builder<T> setOfSubjects(boolean ofSubjects) {
            this.ofSubjects = ofSubjects;
            return this;
        }

        public Builder<T> setName(String name) {
            this.name = name;
            return this;
        }

        public Builder<T> setType(ChunkProtectionExceptionType type) {
            this.type = type;
            return this;
        }

        public Builder<T> setContentString(String contentString) {
            this.contentString = contentString;
            return this;
        }

        public Builder<T> addException(Either<T, class_6862<T>> e) {
            this.exceptionSetBuilder.addEither(e);
            return this;
        }

        public Builder<T> setOptionCategory(PlayerConfigOptionCategory optionCategory) {
            this.optionCategory = optionCategory;
            return this;
        }

        public ChunkProtectionExceptionGroup<T> build() {
            if (this.name == null || this.type == null || this.contentString == null || this.optionCategory == null) {
                throw new IllegalStateException();
            }
            if (!GROUP_NAME_PATTERN.matcher(this.name).matches()) {
                throw new IllegalArgumentException("Exception group name must consist of A - Z, numbers or the - and _ characters: " + this.name);
            }
            return new ChunkProtectionExceptionGroup<T>(this.name, this.type, this.exceptionSetBuilder.build(), this.contentString, this.optionCategory, this.ofSubjects, this.subjectType);
        }

        public static <T> Builder<T> begin(ExceptionElementType<T> elementType) {
            return new Builder<T>(elementType).setDefault();
        }
    }
}

