/*
 * Decompiled with CFR 0.152.
 */
package xaero.pac.common.server.player.config.sync.task;

import java.util.Deque;
import java.util.Iterator;
import java.util.LinkedList;
import net.minecraft.class_3222;
import xaero.pac.common.claims.player.IPlayerChunkClaim;
import xaero.pac.common.claims.player.IPlayerClaimPosList;
import xaero.pac.common.claims.player.IPlayerDimensionClaims;
import xaero.pac.common.parties.party.IPartyPlayerInfo;
import xaero.pac.common.parties.party.ally.IPartyAlly;
import xaero.pac.common.parties.party.member.IPartyMember;
import xaero.pac.common.server.IServerData;
import xaero.pac.common.server.claims.IServerClaimsManager;
import xaero.pac.common.server.claims.IServerDimensionClaimsManager;
import xaero.pac.common.server.claims.IServerRegionClaims;
import xaero.pac.common.server.claims.player.IServerPlayerClaimInfo;
import xaero.pac.common.server.parties.party.IServerParty;
import xaero.pac.common.server.player.config.IPlayerConfig;
import xaero.pac.common.server.player.config.PlayerConfig;
import xaero.pac.common.server.player.config.sub.PlayerSubConfig;
import xaero.pac.common.server.player.config.sync.PlayerConfigSynchronizer;
import xaero.pac.common.server.task.player.ServerPlayerSpreadoutTask;

public final class PlayerConfigSyncSpreadoutTask
extends ServerPlayerSpreadoutTask<PlayerConfigSyncSpreadoutTask> {
    private final Deque<IPlayerConfig> configsToSync;
    private Iterator<IPlayerConfig> currentSubIterator;

    private PlayerConfigSyncSpreadoutTask(Deque<IPlayerConfig> configsToSync) {
        this.configsToSync = configsToSync;
    }

    public void addConfigToSync(IPlayerConfig config) {
        if (this.configsToSync.contains(config)) {
            return;
        }
        this.configsToSync.addLast(config);
    }

    public boolean stillNeedsSyncing(IPlayerConfig config) {
        return this.configsToSync.contains(config);
    }

    @Override
    public boolean shouldWork(IServerData<IServerClaimsManager<IPlayerChunkClaim, IServerPlayerClaimInfo<IPlayerDimensionClaims<IPlayerClaimPosList>>, IServerDimensionClaimsManager<IServerRegionClaims>>, IServerParty<IPartyMember, IPartyPlayerInfo, IPartyAlly>> serverData, class_3222 player) {
        return !this.configsToSync.isEmpty();
    }

    @Override
    public boolean shouldDrop(IServerData<IServerClaimsManager<IPlayerChunkClaim, IServerPlayerClaimInfo<IPlayerDimensionClaims<IPlayerClaimPosList>>, IServerDimensionClaimsManager<IServerRegionClaims>>, IServerParty<IPartyMember, IPartyPlayerInfo, IPartyAlly>> serverData, class_3222 player) {
        return false;
    }

    @Override
    public void onTick(IServerData<IServerClaimsManager<IPlayerChunkClaim, IServerPlayerClaimInfo<IPlayerDimensionClaims<IPlayerClaimPosList>>, IServerDimensionClaimsManager<IServerRegionClaims>>, IServerParty<IPartyMember, IPartyPlayerInfo, IPartyAlly>> serverData, class_3222 player, int perTick) {
        int toSync = perTick;
        while (toSync > 0 && !this.configsToSync.isEmpty()) {
            PlayerConfigSynchronizer synchronizer = (PlayerConfigSynchronizer)serverData.getPlayerConfigs().getSynchronizer();
            PlayerConfig config = (PlayerConfig)this.configsToSync.getFirst();
            if (this.currentSubIterator == null) {
                --toSync;
                synchronizer.sendSyncState(player, config, true);
                synchronizer.syncToClient(player, config, true);
                this.currentSubIterator = config.getSubConfigIterator();
            }
            while (toSync > 0 && this.currentSubIterator.hasNext()) {
                --toSync;
                PlayerSubConfig subConfigToSync = (PlayerSubConfig)this.currentSubIterator.next();
                synchronizer.syncToClient(player, subConfigToSync, true);
            }
            if (this.currentSubIterator.hasNext()) continue;
            synchronizer.sendSyncState(player, config, false);
            this.configsToSync.removeFirst();
            this.currentSubIterator = null;
        }
    }

    public static final class Builder {
        private Builder() {
        }

        public Builder setDefault() {
            return this;
        }

        public PlayerConfigSyncSpreadoutTask build() {
            return new PlayerConfigSyncSpreadoutTask(new LinkedList<IPlayerConfig>());
        }

        public static Builder begin() {
            return new Builder().setDefault();
        }
    }
}

