/*
 * Decompiled with CFR 0.152.
 */
package com.hypherionmc.craterlib.network;

import com.hypherionmc.craterlib.api.networking.CommonPacketWrapper;
import com.hypherionmc.craterlib.core.networking.PacketRegistry;
import com.hypherionmc.craterlib.core.networking.data.PacketContext;
import com.hypherionmc.craterlib.core.networking.data.PacketHolder;
import com.hypherionmc.craterlib.core.networking.data.PacketSide;
import com.hypherionmc.craterlib.nojang.world.entity.player.BridgedPlayer;
import net.fabricmc.fabric.api.client.networking.v1.ClientPlayNetworking;
import net.fabricmc.fabric.api.networking.v1.PayloadTypeRegistry;
import net.fabricmc.fabric.api.networking.v1.ServerPlayNetworking;
import net.minecraft.class_1657;
import net.minecraft.class_2960;
import net.minecraft.class_3222;

public class CraterFabricNetworkHandler
extends PacketRegistry {
    public CraterFabricNetworkHandler(PacketSide side) {
        super(side);
    }

    @Override
    protected <T> void registerPacket(PacketHolder<T> holder) {
        try {
            PayloadTypeRegistry.playC2S().register(holder.getType(), holder.getCodec());
            PayloadTypeRegistry.playS2C().register(holder.getType(), holder.getCodec());
        }
        catch (IllegalArgumentException illegalArgumentException) {
            // empty catch block
        }
        if (PacketSide.CLIENT.equals((Object)this.side)) {
            ClientPlayNetworking.registerGlobalReceiver(holder.getType(), (payload, context) -> context.client().execute(() -> holder.handler().accept(new PacketContext(payload.packet(), this.side))));
        }
        ServerPlayNetworking.registerGlobalReceiver(holder.getType(), (payload, context) -> context.server().execute(() -> holder.handler().accept(new PacketContext(BridgedPlayer.of((class_1657)context.player()), payload.packet(), this.side))));
    }

    @Override
    public <T> void sendToServer(T packet) {
        this.sendToServer(packet, false);
    }

    @Override
    public <T> void sendToServer(T packet, boolean ignoreCheck) {
        PacketHolder container = (PacketHolder)this.PACKET_MAP.get(packet.getClass());
        if (container != null && (ignoreCheck || ClientPlayNetworking.canSend((class_2960)container.type().comp_2242()))) {
            ClientPlayNetworking.send(new CommonPacketWrapper<T>(container, packet));
        }
    }

    @Override
    public <T> void sendToClient(T packet, BridgedPlayer player) {
        PacketHolder container = (PacketHolder)this.PACKET_MAP.get(packet.getClass());
        if (container != null && ServerPlayNetworking.canSend((class_3222)player.toMojangServerPlayer(), (class_2960)container.type().comp_2242())) {
            ServerPlayNetworking.send((class_3222)player.toMojangServerPlayer(), new CommonPacketWrapper<T>(container, packet));
        }
    }
}

