/*
 * Decompiled with CFR 0.152.
 */
package com.hypherionmc.simplerpc.jodd.util;

import com.hypherionmc.simplerpc.jodd.util.CharUtil;
import java.util.concurrent.ThreadLocalRandom;

public class MathUtil {
    public static int parseDigit(char digit) {
        if (digit >= '0' && digit <= '9') {
            return digit - 48;
        }
        if (CharUtil.isLowercaseAlpha(digit)) {
            return 10 + digit - 97;
        }
        return 10 + digit - 65;
    }

    public static long randomLong(long min, long max) {
        return min + (long)(ThreadLocalRandom.current().nextDouble() * (double)(max - min));
    }

    public static int randomInt(int min, int max) {
        return min + (int)(ThreadLocalRandom.current().nextDouble() * (double)(max - min));
    }

    public static boolean isEven(int x) {
        return x % 2 == 0;
    }

    public static boolean isOdd(int x) {
        return x % 2 != 0;
    }

    public static String humanReadableByteCount(long bytes, boolean useSi) {
        int unit;
        int n = unit = useSi ? 1000 : 1024;
        if (bytes < (long)unit) {
            return bytes + " B";
        }
        int exp = (int)(Math.log(bytes) / Math.log(unit));
        String pre = (useSi ? "kMGTPE" : "KMGTPE").charAt(exp - 1) + (useSi ? "" : "i");
        return String.format("%.1f %sB", (double)bytes / Math.pow(unit, exp), pre);
    }
}

