/*
 * Decompiled with CFR 0.152.
 */
package com.hypherionmc.simplerpc.rpcsdk.models;

import com.google.gson.JsonArray;
import com.google.gson.JsonElement;
import com.google.gson.JsonObject;
import com.hypherionmc.simplerpc.rpcsdk.enums.ActivityType;
import com.hypherionmc.simplerpc.rpcsdk.enums.PartyPrivacy;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.stream.Collectors;

public class DiscordRichPresence {
    private String state;
    private String details;
    private long startTimestamp;
    private long endTimestamp;
    private String largeImageKey;
    private String largeImageText;
    private String smallImageKey;
    private String smallImageText;
    private String partyId;
    private int partySize;
    private int partyMax;
    private String matchSecret;
    private String joinSecret;
    private String spectateSecret;
    private boolean instance;
    private PartyPrivacy privacy;
    private ActivityType activityType;
    private List<RPCButton> buttons = new ArrayList<RPCButton>();

    public void addButton(String label, String url) {
        if (this.buttons.size() + 1 > 2) {
            return;
        }
        this.buttons.add(new RPCButton(label, url));
    }

    public void clearButtons() {
        this.buttons.clear();
    }

    public JsonObject toJson(long pid, long nonce) {
        JsonObject data = new JsonObject();
        data.addProperty("nonce", (Number)nonce);
        data.addProperty("cmd", "SET_ACTIVITY");
        JsonObject args = new JsonObject();
        args.addProperty("pid", (Number)pid);
        JsonObject activity = new JsonObject();
        if (this.isNotNullOrEmpty(this.state)) {
            activity.addProperty("state", this.state);
        }
        if (this.isNotNullOrEmpty(this.details)) {
            activity.addProperty("details", this.details);
        }
        if (this.startTimestamp != 0L || this.endTimestamp != 0L) {
            JsonObject timestamps = new JsonObject();
            if (this.startTimestamp != 0L) {
                timestamps.addProperty("start", (Number)this.startTimestamp);
            }
            if (this.endTimestamp != 0L) {
                timestamps.addProperty("end", (Number)this.endTimestamp);
            }
            activity.add("timestamps", (JsonElement)timestamps);
        }
        if (this.isNotNullOrEmpty(this.largeImageKey) || this.isNotNullOrEmpty(this.largeImageText) || this.isNotNullOrEmpty(this.smallImageKey) || this.isNotNullOrEmpty(this.smallImageText)) {
            JsonObject assets = new JsonObject();
            if (this.isNotNullOrEmpty(this.largeImageKey)) {
                assets.addProperty("large_image", this.largeImageKey);
            }
            if (this.isNotNullOrEmpty(this.largeImageText)) {
                assets.addProperty("large_text", this.largeImageText);
            }
            if (this.isNotNullOrEmpty(this.smallImageKey)) {
                assets.addProperty("small_image", this.smallImageKey);
            }
            if (this.isNotNullOrEmpty(this.smallImageText)) {
                assets.addProperty("small_text", this.smallImageText);
            }
            activity.add("assets", (JsonElement)assets);
        }
        if (this.isNotNullOrEmpty(this.partyId) || this.partySize > 0 || this.partyMax > 0) {
            JsonObject party = new JsonObject();
            if (this.isNotNullOrEmpty(this.partyId)) {
                party.addProperty("id", this.partyId);
            }
            if (this.partySize != 0) {
                JsonArray size = new JsonArray();
                size.add((Number)this.partySize);
                if (this.partyMax > 0) {
                    size.add((Number)this.partyMax);
                }
                party.add("size", (JsonElement)size);
            }
            party.addProperty("privacy", (Number)this.privacy.ordinal());
            activity.add("party", (JsonElement)party);
        }
        if (this.isNotNullOrEmpty(this.matchSecret) || this.isNotNullOrEmpty(this.spectateSecret) || this.isNotNullOrEmpty(this.joinSecret)) {
            JsonObject secrets = new JsonObject();
            if (this.isNotNullOrEmpty(this.matchSecret)) {
                secrets.addProperty("match", this.matchSecret);
            }
            if (this.isNotNullOrEmpty(this.joinSecret)) {
                secrets.addProperty("join", this.joinSecret);
            }
            if (this.isNotNullOrEmpty(this.spectateSecret)) {
                secrets.addProperty("spectate", this.spectateSecret);
            }
            activity.add("secrets", (JsonElement)secrets);
        }
        if (!this.buttons.isEmpty()) {
            List<RPCButton> finalButtons = this.buttons.stream().filter(RPCButton::isValid).collect(Collectors.toList());
            if (finalButtons.size() > 2) {
                finalButtons = finalButtons.subList(0, 2);
            }
            JsonArray btns = new JsonArray();
            finalButtons.forEach(b -> btns.add((JsonElement)b.toJson()));
            activity.add("buttons", (JsonElement)btns);
        }
        activity.addProperty("type", (Number)this.activityType.ordinal());
        activity.addProperty("instance", Boolean.valueOf(this.instance));
        args.add("activity", (JsonElement)activity);
        data.add("args", (JsonElement)args);
        return data;
    }

    private boolean isNotNullOrEmpty(String input) {
        return input != null && !input.trim().isEmpty();
    }

    private static PartyPrivacy $default$privacy() {
        return PartyPrivacy.PRIVATE;
    }

    private static ActivityType $default$activityType() {
        return ActivityType.PLAYING;
    }

    public static DiscordRichPresenceBuilder builder() {
        return new DiscordRichPresenceBuilder();
    }

    private DiscordRichPresence() {
        this.privacy = DiscordRichPresence.$default$privacy();
        this.activityType = DiscordRichPresence.$default$activityType();
    }

    DiscordRichPresence(String state, String details, long startTimestamp, long endTimestamp, String largeImageKey, String largeImageText, String smallImageKey, String smallImageText, String partyId, int partySize, int partyMax, String matchSecret, String joinSecret, String spectateSecret, boolean instance, PartyPrivacy privacy, ActivityType activityType, List<RPCButton> buttons) {
        this.state = state;
        this.details = details;
        this.startTimestamp = startTimestamp;
        this.endTimestamp = endTimestamp;
        this.largeImageKey = largeImageKey;
        this.largeImageText = largeImageText;
        this.smallImageKey = smallImageKey;
        this.smallImageText = smallImageText;
        this.partyId = partyId;
        this.partySize = partySize;
        this.partyMax = partyMax;
        this.matchSecret = matchSecret;
        this.joinSecret = joinSecret;
        this.spectateSecret = spectateSecret;
        this.instance = instance;
        this.privacy = privacy;
        this.activityType = activityType;
        this.buttons = buttons;
    }

    public String getState() {
        return this.state;
    }

    public String getDetails() {
        return this.details;
    }

    public long getStartTimestamp() {
        return this.startTimestamp;
    }

    public long getEndTimestamp() {
        return this.endTimestamp;
    }

    public String getLargeImageKey() {
        return this.largeImageKey;
    }

    public String getLargeImageText() {
        return this.largeImageText;
    }

    public String getSmallImageKey() {
        return this.smallImageKey;
    }

    public String getSmallImageText() {
        return this.smallImageText;
    }

    public String getPartyId() {
        return this.partyId;
    }

    public int getPartySize() {
        return this.partySize;
    }

    public int getPartyMax() {
        return this.partyMax;
    }

    public String getMatchSecret() {
        return this.matchSecret;
    }

    public String getJoinSecret() {
        return this.joinSecret;
    }

    public String getSpectateSecret() {
        return this.spectateSecret;
    }

    public boolean isInstance() {
        return this.instance;
    }

    public PartyPrivacy getPrivacy() {
        return this.privacy;
    }

    public ActivityType getActivityType() {
        return this.activityType;
    }

    public List<RPCButton> getButtons() {
        return this.buttons;
    }

    public static class RPCButton {
        private final String label;
        private final String url;

        public boolean isValid() {
            return this.label != null && !this.label.isEmpty() && this.url != null && !this.url.isEmpty();
        }

        public JsonObject toJson() {
            JsonObject button = new JsonObject();
            button.addProperty("label", this.label.substring(0, Math.min(this.label.length(), 32)));
            button.addProperty("url", this.url);
            return button;
        }

        private RPCButton(String label, String url) {
            this.label = label;
            this.url = url;
        }

        public static RPCButton of(String label, String url) {
            return new RPCButton(label, url);
        }

        public String getLabel() {
            return this.label;
        }

        public String getUrl() {
            return this.url;
        }
    }

    public static class DiscordRichPresenceBuilder {
        private String state;
        private String details;
        private long startTimestamp;
        private long endTimestamp;
        private String largeImageKey;
        private String largeImageText;
        private String smallImageKey;
        private String smallImageText;
        private String partyId;
        private int partySize;
        private int partyMax;
        private String matchSecret;
        private String joinSecret;
        private String spectateSecret;
        private boolean instance;
        private boolean privacy$set;
        private PartyPrivacy privacy$value;
        private boolean activityType$set;
        private ActivityType activityType$value;
        private ArrayList<RPCButton> buttons;

        DiscordRichPresenceBuilder() {
        }

        public DiscordRichPresenceBuilder state(String state) {
            this.state = state;
            return this;
        }

        public DiscordRichPresenceBuilder details(String details) {
            this.details = details;
            return this;
        }

        public DiscordRichPresenceBuilder startTimestamp(long startTimestamp) {
            this.startTimestamp = startTimestamp;
            return this;
        }

        public DiscordRichPresenceBuilder endTimestamp(long endTimestamp) {
            this.endTimestamp = endTimestamp;
            return this;
        }

        public DiscordRichPresenceBuilder largeImageKey(String largeImageKey) {
            this.largeImageKey = largeImageKey;
            return this;
        }

        public DiscordRichPresenceBuilder largeImageText(String largeImageText) {
            this.largeImageText = largeImageText;
            return this;
        }

        public DiscordRichPresenceBuilder smallImageKey(String smallImageKey) {
            this.smallImageKey = smallImageKey;
            return this;
        }

        public DiscordRichPresenceBuilder smallImageText(String smallImageText) {
            this.smallImageText = smallImageText;
            return this;
        }

        public DiscordRichPresenceBuilder partyId(String partyId) {
            this.partyId = partyId;
            return this;
        }

        public DiscordRichPresenceBuilder partySize(int partySize) {
            this.partySize = partySize;
            return this;
        }

        public DiscordRichPresenceBuilder partyMax(int partyMax) {
            this.partyMax = partyMax;
            return this;
        }

        public DiscordRichPresenceBuilder matchSecret(String matchSecret) {
            this.matchSecret = matchSecret;
            return this;
        }

        public DiscordRichPresenceBuilder joinSecret(String joinSecret) {
            this.joinSecret = joinSecret;
            return this;
        }

        public DiscordRichPresenceBuilder spectateSecret(String spectateSecret) {
            this.spectateSecret = spectateSecret;
            return this;
        }

        public DiscordRichPresenceBuilder instance(boolean instance) {
            this.instance = instance;
            return this;
        }

        public DiscordRichPresenceBuilder privacy(PartyPrivacy privacy) {
            this.privacy$value = privacy;
            this.privacy$set = true;
            return this;
        }

        public DiscordRichPresenceBuilder activityType(ActivityType activityType) {
            this.activityType$value = activityType;
            this.activityType$set = true;
            return this;
        }

        public DiscordRichPresenceBuilder button(RPCButton button) {
            if (this.buttons == null) {
                this.buttons = new ArrayList();
            }
            this.buttons.add(button);
            return this;
        }

        public DiscordRichPresenceBuilder buttons(Collection<? extends RPCButton> buttons) {
            if (buttons == null) {
                throw new NullPointerException("buttons cannot be null");
            }
            if (this.buttons == null) {
                this.buttons = new ArrayList();
            }
            this.buttons.addAll(buttons);
            return this;
        }

        public DiscordRichPresenceBuilder clearButtons() {
            if (this.buttons != null) {
                this.buttons.clear();
            }
            return this;
        }

        public DiscordRichPresence build() {
            List<RPCButton> buttons = switch (this.buttons == null ? 0 : this.buttons.size()) {
                case 0 -> Collections.emptyList();
                case 1 -> Collections.singletonList(this.buttons.get(0));
                default -> Collections.unmodifiableList(new ArrayList<RPCButton>(this.buttons));
            };
            PartyPrivacy privacy$value = this.privacy$value;
            if (!this.privacy$set) {
                privacy$value = DiscordRichPresence.$default$privacy();
            }
            ActivityType activityType$value = this.activityType$value;
            if (!this.activityType$set) {
                activityType$value = DiscordRichPresence.$default$activityType();
            }
            return new DiscordRichPresence(this.state, this.details, this.startTimestamp, this.endTimestamp, this.largeImageKey, this.largeImageText, this.smallImageKey, this.smallImageText, this.partyId, this.partySize, this.partyMax, this.matchSecret, this.joinSecret, this.spectateSecret, this.instance, privacy$value, activityType$value, buttons);
        }

        public String toString() {
            return "DiscordRichPresence.DiscordRichPresenceBuilder(state=" + this.state + ", details=" + this.details + ", startTimestamp=" + this.startTimestamp + ", endTimestamp=" + this.endTimestamp + ", largeImageKey=" + this.largeImageKey + ", largeImageText=" + this.largeImageText + ", smallImageKey=" + this.smallImageKey + ", smallImageText=" + this.smallImageText + ", partyId=" + this.partyId + ", partySize=" + this.partySize + ", partyMax=" + this.partyMax + ", matchSecret=" + this.matchSecret + ", joinSecret=" + this.joinSecret + ", spectateSecret=" + this.spectateSecret + ", instance=" + this.instance + ", privacy$value=" + String.valueOf((Object)this.privacy$value) + ", activityType$value=" + String.valueOf((Object)this.activityType$value) + ", buttons=" + String.valueOf(this.buttons) + ")";
        }
    }
}

