/*
 * Decompiled with CFR 0.152.
 */
package com.hypherionmc.simplerpc.util.rpcavatar;

import com.google.gson.Gson;
import com.hypherionmc.simplerpc.RPCConstants;
import com.hypherionmc.simplerpc.jodd.http.HttpRequest;
import com.hypherionmc.simplerpc.jodd.http.HttpResponse;
import com.hypherionmc.simplerpc.util.rpcavatar.StandardResponse;
import java.io.File;
import java.util.Collection;
import java.util.Collections;
import java.util.HashSet;
import java.util.List;
import java.util.Set;

final class APIClient {
    private final Gson gson = new Gson();
    private final String apiUrl;

    APIClient(String apiUrl) {
        this.apiUrl = apiUrl;
    }

    Set<String> checkHashes(Collection<String> hashes) {
        try {
            HttpResponse response = ((HttpRequest)((HttpRequest)HttpRequest.post(this.apiUrl + "/check-hashes").header("Content-Type", "application/json; charset=utf-8")).bodyText(this.gson.toJson(Collections.singletonMap("hashes", hashes)))).send();
            if (response.statusCode() != 200 || response.bodyText() == null) {
                RPCConstants.logger.error("Failed to check local image hashes against API: {}", (Object)response.statusCode());
                return new HashSet<String>();
            }
            return (Set)this.gson.fromJson(response.bodyText(), Set.class);
        }
        catch (Exception e) {
            RPCConstants.logger.error("Failed to check local image hashes against API", (Throwable)e);
            return new HashSet<String>();
        }
    }

    void uploadFiles(List<File> files) {
        try {
            HttpRequest request = HttpRequest.post(this.apiUrl + "/upload").multipart(true);
            for (File file : files) {
                request.form("files", file);
            }
            HttpResponse response = request.send();
            if (response.statusCode() != 200 || response.bodyText() == null) {
                RPCConstants.logger.error("Failed to upload local images to RPC Image Server: {}", (Object)response.statusCode());
                return;
            }
            StandardResponse reply = (StandardResponse)this.gson.fromJson(response.bodyText(), StandardResponse.class);
            if (reply.error) {
                RPCConstants.logger.error("Failed to upload local images to RPC Image Server: {}", (Object)reply.message);
                if (reply.data != null) {
                    RPCConstants.logger.error(reply.data);
                }
            } else {
                RPCConstants.logger.info("RPCImageServer: {}", (Object)reply.message);
            }
        }
        catch (Exception e) {
            RPCConstants.logger.error("Failed to upload local images to RPC Image Server", (Throwable)e);
        }
    }
}

