/*
 * Decompiled with CFR 0.152.
 */
package pigcart.cosycritters.particle;

import java.util.List;
import java.util.Optional;
import net.minecraft.class_1297;
import net.minecraft.class_2338;
import net.minecraft.class_2374;
import net.minecraft.class_238;
import net.minecraft.class_2400;
import net.minecraft.class_243;
import net.minecraft.class_2680;
import net.minecraft.class_310;
import net.minecraft.class_3532;
import net.minecraft.class_4002;
import net.minecraft.class_5878;
import net.minecraft.class_638;
import net.minecraft.class_703;
import org.joml.Math;
import org.joml.Vector2f;
import org.joml.Vector3f;
import pigcart.cosycritters.Util;
import pigcart.cosycritters.config.ConfigManager;
import pigcart.cosycritters.particle.CritterParticle;

public class BirdParticle
extends CritterParticle {
    int spawnAnimationLength;
    int spawnAnimationTime;
    class_243 spawnAnimationStart;
    class_243 spawnAnimationEnd;
    Vector3f facing;
    Behaviour behaviour;
    class_2680 perch;

    private BirdParticle(class_638 level, double x, double y, double z, double landAtX, double landAtY, double landAtZ) {
        super(level, x, y, z, Util.getSprite("crow_left"));
        this.spawnAnimationTime = this.spawnAnimationLength = 40;
        if (this.entitiesNearby(new class_243(landAtX, landAtY, landAtZ))) {
            this.method_3085();
        }
        this.field_3862 = false;
        this.field_17867 = 0.0f;
        this.field_3847 = 6000;
        this.facing = new Vector3f(this.field_3840.method_43057() - 0.5f, this.field_3840.method_43057(), this.field_3840.method_43057() - 0.5f).normalize().mul(0.5f);
        this.spawnAnimationStart = new class_243(x, y, z);
        this.spawnAnimationEnd = new class_243(landAtX, landAtY, landAtZ);
        this.setBehaviour(Behaviour.SPAWNING);
    }

    public Optional<class_5878> method_34019() {
        return Optional.of(ConfigManager.birdGroup);
    }

    private void setBehaviour(Behaviour behaviour) {
        this.behaviour = behaviour;
        switch (behaviour.ordinal()) {
            case 1: {
                this.perch = this.field_3851.method_8320(class_2338.method_49637((double)this.field_3874, (double)(this.field_3854 - 0.5), (double)this.field_3871));
                break;
            }
            case 3: {
                this.field_3847 = 100;
                this.field_3866 = 0;
                this.method_3063(this.spawnAnimationEnd.field_1352, this.spawnAnimationEnd.field_1351, this.spawnAnimationEnd.field_1350);
            }
        }
    }

    private String getRelativeDirection() {
        float b;
        Vector2f birdFacing = new Vector2f(this.facing.x, this.facing.z).normalize();
        class_243 camPos = class_310.method_1551().field_1773.method_19418().method_19326();
        Vector2f relativeDirection = new Vector2f((float)(this.field_3874 - camPos.method_10216()), (float)(this.field_3871 - camPos.method_10215())).normalize();
        float a = Math.atan2((float)relativeDirection.y, (float)relativeDirection.x);
        float c = a - (b = Math.atan2((float)birdFacing.y, (float)birdFacing.x));
        if (c > (float)java.lang.Math.PI) {
            c -= (float)java.lang.Math.PI * 2;
        } else if (c < (float)(-java.lang.Math.PI)) {
            c += (float)java.lang.Math.PI * 2;
        }
        if (c < 0.0f) {
            return "right";
        }
        return "left";
    }

    private void reactToDisturbances() {
        if (!this.perch.equals((Object)this.field_3851.method_8320(class_2338.method_49637((double)this.field_3874, (double)(this.field_3854 - 0.5), (double)this.field_3871)))) {
            this.setBehaviour(Behaviour.FLY_UP_AWAY_TO_THE_SUN_LIKE_A_FEATHERY_PIECE_OF_GARGBAGE);
        } else if (this.field_3866 % ConfigManager.config.birdReactionSpeed == 0) {
            class_243 birdPos = new class_243(this.field_3874, this.field_3854, this.field_3871);
            if (this.entitiesNearby(birdPos)) {
                this.setBehaviour(Behaviour.FLY_UP_AWAY_TO_THE_SUN_LIKE_A_FEATHERY_PIECE_OF_GARGBAGE);
            } else if (!Util.getCameraPos().method_24802((class_2374)birdPos, (double)ConfigManager.config.birdDespawnDistance)) {
                this.method_3085();
            }
        }
    }

    private boolean entitiesNearby(class_243 pos) {
        List nearbyEntities = this.field_3851.method_18467(class_1297.class, class_238.method_30048((class_243)pos, (double)ConfigManager.config.birdReactionDistance, (double)ConfigManager.config.birdReactionDistance, (double)ConfigManager.config.birdReactionDistance));
        return !nearbyEntities.isEmpty();
    }

    public void method_3070() {
        super.method_3070();
        switch (this.behaviour.ordinal()) {
            case 0: {
                this.method_74307(Util.getSprite("crow_flying_%s_%d".formatted(this.getRelativeDirection(), this.field_3866 / 2 % 2)));
                if (this.spawnAnimationTime != 0) {
                    --this.spawnAnimationTime;
                    this.field_3874 = class_3532.method_16436((double)((double)this.spawnAnimationTime / (double)this.spawnAnimationLength), (double)this.spawnAnimationEnd.field_1352, (double)this.spawnAnimationStart.field_1352);
                    this.field_3854 = class_3532.method_16436((double)((double)this.spawnAnimationTime / (double)this.spawnAnimationLength), (double)this.spawnAnimationEnd.field_1351, (double)this.spawnAnimationStart.field_1351);
                    this.field_3871 = class_3532.method_16436((double)((double)this.spawnAnimationTime / (double)this.spawnAnimationLength), (double)this.spawnAnimationEnd.field_1350, (double)this.spawnAnimationStart.field_1350);
                    this.field_17867 = class_3532.method_16439((float)((float)this.spawnAnimationTime / (float)this.spawnAnimationLength), (float)0.5f, (float)0.0f);
                    break;
                }
                this.setBehaviour(Behaviour.PERCHED);
                break;
            }
            case 1: {
                if ((double)this.field_3840.method_43057() < 0.01) {
                    this.setBehaviour(Behaviour.CHECKING);
                }
                this.method_74307(Util.getSprite("crow_" + this.getRelativeDirection()));
                this.reactToDisturbances();
                break;
            }
            case 2: {
                if ((double)this.field_3840.method_43057() < 0.02) {
                    this.setBehaviour(Behaviour.PERCHED);
                }
                this.method_74307(Util.getSprite("crow_checking_" + this.getRelativeDirection()));
                this.reactToDisturbances();
                break;
            }
            case 3: {
                this.method_74307(Util.getSprite("crow_flying_%s_%d".formatted(this.getRelativeDirection(), this.field_3866 / 2 % 2)));
                this.field_17867 = class_3532.method_16439((float)((float)this.field_3866 / (float)this.field_3847), (float)0.5f, (float)0.0f);
                this.field_3852 = this.facing.x;
                this.field_3869 = this.facing.y;
                this.field_3850 = this.facing.z;
            }
        }
    }

    private static enum Behaviour {
        SPAWNING,
        PERCHED,
        CHECKING,
        FLY_UP_AWAY_TO_THE_SUN_LIKE_A_FEATHERY_PIECE_OF_GARGBAGE;

    }

    public static class Provider
    extends CritterParticle.CritterProvider {
        public Provider(class_4002 spriteSet) {
            super(spriteSet);
        }

        @Override
        public class_703 createParticle(class_2400 type, class_638 level, double x, double y, double z, double velocityX, double velocityY, double velocityZ) {
            return new BirdParticle(level, x, y, z, velocityX, velocityY, velocityZ);
        }
    }
}

