/*
 * Decompiled with CFR 0.152.
 */
package org.bukkit.event.block;

import java.util.ArrayList;
import java.util.List;
import net.kyori.adventure.text.Component;
import net.kyori.adventure.text.serializer.legacy.LegacyComponentSerializer;
import org.bukkit.block.Block;
import org.bukkit.block.sign.Side;
import org.bukkit.entity.Player;
import org.bukkit.event.Cancellable;
import org.bukkit.event.HandlerList;
import org.bukkit.event.block.BlockEvent;
import org.jetbrains.annotations.ApiStatus;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class SignChangeEvent
extends BlockEvent
implements Cancellable {
    private static final HandlerList HANDLER_LIST = new HandlerList();
    private final Player player;
    private final List<Component> adventure$lines;
    private final Side side;
    private boolean cancelled;

    @ApiStatus.Internal
    public SignChangeEvent(@NotNull Block sign, @NotNull Player player, @NotNull List<Component> adventure$lines, @NotNull Side side) {
        super(sign);
        this.player = player;
        this.adventure$lines = adventure$lines;
        this.side = side;
    }

    @Deprecated(forRemoval=true)
    @ApiStatus.Internal
    public SignChangeEvent(@NotNull Block sign, @NotNull Player player, @NotNull List<Component> adventure$lines) {
        this(sign, player, adventure$lines, Side.FRONT);
    }

    @Deprecated(since="1.19.4", forRemoval=true)
    @ApiStatus.Internal
    public SignChangeEvent(@NotNull Block sign, @NotNull Player thePlayer, @NotNull String[] theLines) {
        this(sign, thePlayer, theLines, Side.FRONT);
    }

    @Deprecated(forRemoval=true)
    @ApiStatus.Internal
    public SignChangeEvent(@NotNull Block sign, @NotNull Player thePlayer, @NotNull String[] theLines, @NotNull Side side) {
        super(sign);
        this.player = thePlayer;
        this.adventure$lines = new ArrayList<Component>();
        for (String theLine : theLines) {
            this.adventure$lines.add((Component)LegacyComponentSerializer.legacySection().deserialize(theLine));
        }
        this.side = side;
    }

    @NotNull
    public Player getPlayer() {
        return this.player;
    }

    @NotNull
    public List<Component> lines() {
        return this.adventure$lines;
    }

    public @Nullable Component line(int index) throws IndexOutOfBoundsException {
        return this.adventure$lines.get(index);
    }

    public void line(int index, @Nullable Component line) throws IndexOutOfBoundsException {
        this.adventure$lines.set(index, line);
    }

    @Deprecated
    @NotNull
    public String[] getLines() {
        return (String[])this.adventure$lines.stream().map(arg_0 -> ((LegacyComponentSerializer)LegacyComponentSerializer.legacySection()).serialize(arg_0)).toArray(String[]::new);
    }

    @Deprecated
    @Nullable
    public String getLine(int index) throws IndexOutOfBoundsException {
        return LegacyComponentSerializer.legacySection().serialize(this.adventure$lines.get(index));
    }

    @Deprecated
    public void setLine(int index, @Nullable String line) throws IndexOutOfBoundsException {
        this.adventure$lines.set(index, (Component)(line != null ? LegacyComponentSerializer.legacySection().deserialize(line) : null));
    }

    @NotNull
    public Side getSide() {
        return this.side;
    }

    @Override
    public boolean isCancelled() {
        return this.cancelled;
    }

    @Override
    public void setCancelled(boolean cancel) {
        this.cancelled = cancel;
    }

    @Override
    @NotNull
    public HandlerList getHandlers() {
        return HANDLER_LIST;
    }

    @NotNull
    public static HandlerList getHandlerList() {
        return HANDLER_LIST;
    }
}

