/*
 * Decompiled with CFR 0.152.
 */
package org.bukkit.event.player;

import com.google.common.base.Preconditions;
import java.util.HashSet;
import java.util.Set;
import org.bukkit.entity.Player;
import org.bukkit.event.Cancellable;
import org.bukkit.event.HandlerList;
import org.bukkit.event.player.PlayerEvent;
import org.jetbrains.annotations.ApiStatus;
import org.jetbrains.annotations.NotNull;

public class PlayerCommandPreprocessEvent
extends PlayerEvent
implements Cancellable {
    private static final HandlerList HANDLER_LIST = new HandlerList();
    private String message;
    private final Set<Player> recipients;
    private boolean cancelled;

    @ApiStatus.Internal
    public PlayerCommandPreprocessEvent(@NotNull Player player, @NotNull String message) {
        super(player);
        this.recipients = new HashSet<Player>(player.getServer().getOnlinePlayers());
        this.message = message;
    }

    @ApiStatus.Internal
    public PlayerCommandPreprocessEvent(@NotNull Player player, @NotNull String message, @NotNull Set<Player> recipients) {
        super(player);
        this.recipients = recipients;
        this.message = message;
    }

    @NotNull
    public String getMessage() {
        return this.message;
    }

    public void setMessage(@NotNull String command) throws IllegalArgumentException {
        Preconditions.checkArgument((command != null ? 1 : 0) != 0, (Object)"Command cannot be null");
        Preconditions.checkArgument((!command.isEmpty() ? 1 : 0) != 0, (Object)"Command cannot be empty");
        this.message = command;
    }

    @Deprecated(since="1.3.1", forRemoval=true)
    @NotNull
    public Set<Player> getRecipients() {
        return this.recipients;
    }

    @Deprecated(forRemoval=true)
    public void setPlayer(@NotNull Player player) throws IllegalArgumentException {
        Preconditions.checkArgument((player != null ? 1 : 0) != 0, (Object)"Player cannot be null");
        this.player = player;
    }

    @Override
    public boolean isCancelled() {
        return this.cancelled;
    }

    @Override
    public void setCancelled(boolean cancel) {
        this.cancelled = cancel;
    }

    @Override
    @NotNull
    public HandlerList getHandlers() {
        return HANDLER_LIST;
    }

    @NotNull
    public static HandlerList getHandlerList() {
        return HANDLER_LIST;
    }
}

