/*
 * Decompiled with CFR 0.152.
 */
package dynamic_fps.impl.config.option;

import dynamic_fps.impl.config.DynamicFPSConfig;
import dynamic_fps.impl.feature.battery.BatteryTracker;
import net.lostluma.battery.api.State;

public enum BatteryIndicatorCondition {
    DISABLED(() -> false),
    DRAINING(() -> BatteryTracker.status() == State.DISCHARGING),
    CRITICAL(() -> {
        int critical = DynamicFPSConfig.INSTANCE.batteryTracker().criticalLevel();
        return DRAINING.isConditionMet() && BatteryTracker.charge() <= critical;
    }),
    CONSTANT(() -> true);

    private final Condition condition;

    private BatteryIndicatorCondition(Condition condition) {
        this.condition = condition;
    }

    public boolean isConditionMet() {
        return this.condition.isMet();
    }

    @FunctionalInterface
    private static interface Condition {
        public boolean isMet();
    }
}

