/*
 * Decompiled with CFR 0.152.
 */
package su.plo.lib.mod.client.render.texture;

import com.google.common.cache.Cache;
import com.google.common.cache.CacheBuilder;
import com.mojang.authlib.GameProfile;
import com.mojang.authlib.properties.Property;
import com.mojang.authlib.yggdrasil.ProfileResult;
import java.util.Optional;
import java.util.UUID;
import java.util.concurrent.ScheduledExecutorService;
import java.util.concurrent.TimeUnit;
import java.util.function.Supplier;
import net.minecraft.class_1068;
import net.minecraft.class_2960;
import net.minecraft.class_310;
import net.minecraft.class_640;
import net.minecraft.class_8685;
import org.jetbrains.annotations.NotNull;
import su.plo.slib.api.entity.player.McGameProfile;

public final class ModPlayerSkins {
    private static final Cache<UUID, Supplier<class_2960>> SKINS = CacheBuilder.newBuilder().expireAfterAccess(15L, TimeUnit.SECONDS).build();

    public static synchronized void loadSkin(@NotNull UUID playerId, @NotNull String nick, @NotNull ScheduledExecutorService backgroundExecutor) {
        class_640 playerInfo = class_310.method_1551().method_1562().method_2871(playerId);
        if (playerInfo != null) {
            return;
        }
        Supplier skinLocation = (Supplier)SKINS.getIfPresent((Object)playerId);
        if (skinLocation != null) {
            return;
        }
        backgroundExecutor.execute(() -> {
            GameProfile profile = Optional.ofNullable(class_310.method_1551().method_73361().comp_837().fetchProfile(playerId, false)).map(ProfileResult::profile).orElse(new GameProfile(playerId, nick));
            SKINS.put((Object)profile.id(), ModPlayerSkins.getInsecureSkinLocation(profile));
        });
    }

    public static synchronized void loadSkin(@NotNull McGameProfile gameProfile) {
        class_640 playerInfo = class_310.method_1551().method_1562().method_2871(gameProfile.getId());
        if (playerInfo != null) {
            return;
        }
        Supplier<class_2960> skinLocation = (Supplier<class_2960>)SKINS.getIfPresent((Object)gameProfile.getId());
        if (skinLocation != null) {
            return;
        }
        GameProfile profile = new GameProfile(gameProfile.getId(), gameProfile.getName());
        gameProfile.getProperties().forEach(property -> profile.properties().put((Object)property.getName(), (Object)new Property(property.getName(), property.getValue(), property.getSignature())));
        skinLocation = ModPlayerSkins.getInsecureSkinLocation(profile);
        SKINS.put((Object)gameProfile.getId(), skinLocation);
    }

    private static Supplier<class_2960> getInsecureSkinLocation(GameProfile gameProfile) {
        Supplier skinSupplier = class_310.method_1551().method_1582().method_73544(gameProfile, false);
        return () -> ModPlayerSkins.lambda$getInsecureSkinLocation$2((Supplier)skinSupplier);
    }

    @NotNull
    public static synchronized class_2960 getSkin(@NotNull UUID playerId, @NotNull String nick) {
        class_640 playerInfo = class_310.method_1551().method_1562().method_2871(playerId);
        if (playerInfo != null) {
            return playerInfo.method_52810().comp_1626().comp_3627();
        }
        Supplier skinLocation = (Supplier)SKINS.getIfPresent((Object)playerId);
        if (skinLocation != null) {
            return (class_2960)skinLocation.get();
        }
        return ModPlayerSkins.getDefaultSkin(playerId);
    }

    @NotNull
    public static class_2960 getDefaultSkin(@NotNull UUID playerId) {
        return class_1068.method_4648((UUID)playerId).comp_1626().comp_3627();
    }

    private ModPlayerSkins() {
    }

    private static /* synthetic */ class_2960 lambda$getInsecureSkinLocation$2(Supplier skinSupplier) {
        class_2960 skinLocation = ((class_8685)skinSupplier.get()).comp_1626().comp_3627();
        class_310.method_1551().method_1531().method_4619(skinLocation).method_4527(false, true);
        return skinLocation;
    }
}

