/*
 * Decompiled with CFR 0.152.
 */
package su.plo.voice.client.gui.settings;

import java.util.Optional;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import su.plo.lib.mod.client.gui.screen.ScreenWrapper;
import su.plo.voice.api.client.socket.UdpClient;
import su.plo.voice.client.BaseVoiceClient;
import su.plo.voice.client.gui.settings.VoiceNotAvailableScreen;
import su.plo.voice.client.gui.settings.VoiceSettingsScreen;
import su.plo.voice.libs.kotlin.Metadata;
import su.plo.voice.libs.kotlin.jvm.internal.Intrinsics;
import su.plo.voice.libs.kotlin.jvm.optionals.OptionalsKt;

@Metadata(mv={2, 0, 0}, k=1, xi=48, d1={"\u0000 \n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\b\u00c6\u0002\u0018\u00002\u00020\u0001B\t\b\u0002\u00a2\u0006\u0004\b\u0002\u0010\u0003J\u000e\u0010\u0006\u001a\u00020\u00072\u0006\u0010\b\u001a\u00020\tJ\u000e\u0010\n\u001a\u00020\u00072\u0006\u0010\b\u001a\u00020\tR\u0010\u0010\u0004\u001a\u0004\u0018\u00010\u0005X\u0082\u000e\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u000b"}, d2={"Lsu/plo/voice/client/gui/settings/VoiceScreens;", "", "<init>", "()V", "settingsScreen", "Lsu/plo/voice/client/gui/settings/VoiceSettingsScreen;", "openSettings", "", "voiceClient", "Lsu/plo/voice/client/BaseVoiceClient;", "openNotAvailable", "plasmovoice-fabric-1.21.9"})
public final class VoiceScreens {
    @NotNull
    public static final VoiceScreens INSTANCE = new VoiceScreens();
    @Nullable
    private static VoiceSettingsScreen settingsScreen;

    private VoiceScreens() {
    }

    public final void openSettings(@NotNull BaseVoiceClient voiceClient) {
        Intrinsics.checkNotNullParameter(voiceClient, "voiceClient");
        Optional<ScreenWrapper> wrappedScreen = ScreenWrapper.getCurrentWrappedScreen();
        Intrinsics.checkNotNull(wrappedScreen);
        ScreenWrapper screenWrapper = OptionalsKt.getOrNull(wrappedScreen);
        if ((screenWrapper != null ? screenWrapper.getScreen() : null) instanceof VoiceSettingsScreen) {
            ScreenWrapper.openScreen(null);
            return;
        }
        if (!voiceClient.getUdpClientManager().isConnected()) {
            this.openNotAvailable(voiceClient);
            return;
        }
        if (settingsScreen == null) {
            settingsScreen = new VoiceSettingsScreen(voiceClient);
        }
        ScreenWrapper.openScreen(settingsScreen);
    }

    public final void openNotAvailable(@NotNull BaseVoiceClient voiceClient) {
        Intrinsics.checkNotNullParameter(voiceClient, "voiceClient");
        VoiceNotAvailableScreen notAvailableScreen = new VoiceNotAvailableScreen(voiceClient);
        Optional<UdpClient> optional = voiceClient.getUdpClientManager().getClient();
        Intrinsics.checkNotNullExpressionValue(optional, "getClient(...)");
        Optional<UdpClient> udpClient = optional;
        if (udpClient.isPresent()) {
            if (udpClient.get().isClosed()) {
                notAvailableScreen.setCannotConnect();
            } else {
                notAvailableScreen.setConnecting();
            }
        }
        ScreenWrapper.openScreen(notAvailableScreen);
    }
}

