/*
 * Decompiled with CFR 0.152.
 */
package com.seibel.distanthorizons.core.util;

import com.seibel.distanthorizons.core.util.threading.DhThreadFactory;
import java.util.concurrent.LinkedBlockingQueue;
import java.util.concurrent.ThreadPoolExecutor;
import java.util.concurrent.TimeUnit;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;

public class ThreadUtil {
    private static final Logger LOGGER = LogManager.getLogger();
    public static final String THREAD_NAME_PREFIX = "DH-";

    public static ThreadPoolExecutor makeThreadPool(int poolSize, String name, int priority, boolean isDaemon) {
        return new ThreadPoolExecutor(poolSize, poolSize, 0L, TimeUnit.MILLISECONDS, new LinkedBlockingQueue<Runnable>(), new DhThreadFactory(name, priority, isDaemon));
    }

    public static ThreadPoolExecutor makeThreadPool(int poolSize, Class<?> clazz, int priority) {
        return ThreadUtil.makeThreadPool(poolSize, clazz.getSimpleName(), priority, false);
    }

    public static ThreadPoolExecutor makeThreadPool(int poolSize, String name) {
        return ThreadUtil.makeThreadPool(poolSize, name, 5, false);
    }

    public static ThreadPoolExecutor makeThreadPool(int poolSize, Class<?> clazz) {
        return ThreadUtil.makeThreadPool(poolSize, clazz.getSimpleName(), 5, false);
    }

    public static ThreadPoolExecutor makeSingleThreadPool(String name, int priority) {
        return ThreadUtil.makeThreadPool(1, name, priority, false);
    }

    public static ThreadPoolExecutor makeSingleThreadPool(Class<?> clazz, int priority) {
        return ThreadUtil.makeThreadPool(1, clazz.getSimpleName(), priority, false);
    }

    public static ThreadPoolExecutor makeSingleThreadPool(String name) {
        return ThreadUtil.makeThreadPool(1, name, 5, false);
    }

    public static ThreadPoolExecutor makeSingleThreadPool(Class<?> clazz) {
        return ThreadUtil.makeThreadPool(1, clazz.getSimpleName(), 5, false);
    }

    public static ThreadPoolExecutor makeSingleDaemonThreadPool(String name) {
        return ThreadUtil.makeThreadPool(1, name, 5, true);
    }
}

