/*
 * Decompiled with CFR 0.152.
 */
package net.clayborn.accurateblockplacement.config;

import java.io.File;
import java.io.FileReader;
import java.io.FileWriter;
import java.io.IOException;
import java.util.Properties;
import net.clayborn.accurateblockplacement.AccurateBlockPlacementMod;
import net.fabricmc.loader.api.FabricLoader;

public class AccurateBlockPlacementConfig {
    private static final String PLACEMENT_KEY = "accurateplace-enabled";
    private static final String BREAKING_KEY = "fastbreak-enabled";
    public static final boolean DEFAULT_ACCURATE_PLACEMENT_ENABLED = true;
    public static final boolean DEFAULT_FAST_BREAKING_ENABLED = false;
    private static final String CONFIRMATION_KEY = "confirmation";
    public static final boolean DEFAULT_CONFIRMATION = true;
    public static boolean confirmation;
    private static final String CONFIRMATION_TYPE_KEY = "confirmationType";
    public static final boolean DEFAULT_CONFIRMATION_TYPE = true;
    public static boolean confirmationType;

    public static void save() {
        File configFile = FabricLoader.getInstance().getConfigDir().resolve("accurateblockplacement.properties").toFile();
        try (FileWriter writer = new FileWriter(configFile);){
            Properties properties = new Properties();
            properties.setProperty(PLACEMENT_KEY, Boolean.toString(AccurateBlockPlacementMod.isAccurateBlockPlacementEnabled));
            properties.setProperty(BREAKING_KEY, Boolean.toString(AccurateBlockPlacementMod.isFastBlockBreakingEnabled));
            properties.setProperty(CONFIRMATION_KEY, String.valueOf(confirmation));
            properties.setProperty(CONFIRMATION_TYPE_KEY, String.valueOf(confirmationType));
            properties.store(writer, null);
        }
        catch (IOException e) {
            throw new RuntimeException(e);
        }
    }

    public static void load() {
        Properties properties;
        File configFile = FabricLoader.getInstance().getConfigDir().resolve("accurateblockplacement.properties").toFile();
        if (!configFile.exists()) {
            try (FileWriter writer = new FileWriter(configFile);){
                properties = new Properties();
                properties.setProperty(PLACEMENT_KEY, Boolean.toString(true));
                properties.setProperty(BREAKING_KEY, Boolean.toString(false));
                properties.setProperty(CONFIRMATION_KEY, String.valueOf(true));
                properties.setProperty(CONFIRMATION_TYPE_KEY, String.valueOf(true));
                properties.store(writer, null);
            }
            catch (IOException e) {
                throw new RuntimeException(e);
            }
        }
        try (FileReader reader = new FileReader(configFile);){
            properties = new Properties();
            properties.load(reader);
            AccurateBlockPlacementMod.isAccurateBlockPlacementEnabled = Boolean.parseBoolean(properties.getProperty(PLACEMENT_KEY, String.valueOf(true)));
            AccurateBlockPlacementMod.isFastBlockBreakingEnabled = Boolean.parseBoolean(properties.getProperty(BREAKING_KEY, String.valueOf(false)));
            confirmation = Boolean.parseBoolean(properties.getProperty(CONFIRMATION_KEY, String.valueOf(true)));
            confirmationType = Boolean.parseBoolean(properties.getProperty(CONFIRMATION_TYPE_KEY, String.valueOf(true)));
        }
        catch (IOException e) {
            throw new RuntimeException(e);
        }
        catch (IllegalStateException e) {
            AccurateBlockPlacementConfig.save();
        }
    }
}

