/*
 * Decompiled with CFR 0.152.
 */
package net.caffeinemc.mods.sodium.client.render.chunk.tree;

public abstract class Tree {
    public static final int OUT_OF_BOUNDS = -1;
    public static final int NOT_PRESENT = 0;
    public static final int PRESENT = 1;
    protected final long[] tree = new long[4096];
    protected final int offsetX;
    protected final int offsetY;
    protected final int offsetZ;

    public Tree(int offsetX, int offsetY, int offsetZ) {
        this.offsetX = offsetX;
        this.offsetY = offsetY;
        this.offsetZ = offsetZ;
    }

    public static boolean isOutOfBounds(int x, int y, int z) {
        return x > 63 || y > 63 || z > 63 || x < 0 || y < 0 || z < 0;
    }

    protected static int interleave6x3(int x, int y, int z) {
        return Tree.interleave6(x) | Tree.interleave6(y) << 1 | Tree.interleave6(z) << 2;
    }

    private static int interleave6(int n) {
        n &= 0x3F;
        n = (n | n << 4 | n << 8) & 0x30C3;
        n = (n | n << 2) & 0x9249;
        return n;
    }

    protected static int deinterleave6(int n) {
        n &= 0x9249;
        n = (n | n >> 2) & 0x30C3;
        n = (n | n >> 4 | n >> 8) & 0x3F;
        return n;
    }

    public boolean add(int x, int y, int z) {
        if (Tree.isOutOfBounds(x -= this.offsetX, y -= this.offsetY, z -= this.offsetZ)) {
            return false;
        }
        int bitIndex = Tree.interleave6x3(x, y, z);
        int n = bitIndex >> 6;
        this.tree[n] = this.tree[n] | 1L << (bitIndex & 0x3F);
        return true;
    }

    public abstract int getPresence(int var1, int var2, int var3);
}

