/*
 * Decompiled with CFR 0.152.
 */
package com.tiviacz.travelersbackpack.common;

import com.tiviacz.travelersbackpack.blockentity.BackpackBlockEntity;
import com.tiviacz.travelersbackpack.blocks.SleepingBagBlock;
import com.tiviacz.travelersbackpack.common.BackpackAbilities;
import com.tiviacz.travelersbackpack.component.ComponentUtils;
import com.tiviacz.travelersbackpack.config.TravelersBackpackConfig;
import com.tiviacz.travelersbackpack.fluids.EffectFluidRegistry;
import com.tiviacz.travelersbackpack.init.ModAdvancements;
import com.tiviacz.travelersbackpack.init.ModDataComponents;
import com.tiviacz.travelersbackpack.init.ModItems;
import com.tiviacz.travelersbackpack.inventory.BackpackContainer;
import com.tiviacz.travelersbackpack.inventory.BackpackSettingsContainer;
import com.tiviacz.travelersbackpack.inventory.BackpackWrapper;
import com.tiviacz.travelersbackpack.inventory.FluidTank;
import com.tiviacz.travelersbackpack.inventory.FluidVariantWrapper;
import com.tiviacz.travelersbackpack.inventory.handler.ItemStackHandler;
import com.tiviacz.travelersbackpack.inventory.menu.BackpackBaseMenu;
import com.tiviacz.travelersbackpack.inventory.menu.BackpackItemMenu;
import com.tiviacz.travelersbackpack.inventory.menu.BackpackSettingsMenu;
import com.tiviacz.travelersbackpack.inventory.sorter.ContainerSorter;
import com.tiviacz.travelersbackpack.inventory.upgrades.IEnable;
import com.tiviacz.travelersbackpack.item.HoseItem;
import com.tiviacz.travelersbackpack.item.TravelersBackpackItem;
import com.tiviacz.travelersbackpack.network.ClientboundSyncItemStackPacket;
import com.tiviacz.travelersbackpack.util.InventoryHelper;
import com.tiviacz.travelersbackpack.util.ItemStackUtils;
import com.tiviacz.travelersbackpack.util.PacketDistributor;
import java.util.List;
import java.util.Optional;
import net.minecraft.class_10690;
import net.minecraft.class_10691;
import net.minecraft.class_1268;
import net.minecraft.class_1297;
import net.minecraft.class_1309;
import net.minecraft.class_1657;
import net.minecraft.class_1676;
import net.minecraft.class_1703;
import net.minecraft.class_1767;
import net.minecraft.class_1799;
import net.minecraft.class_1802;
import net.minecraft.class_1935;
import net.minecraft.class_1937;
import net.minecraft.class_2244;
import net.minecraft.class_2246;
import net.minecraft.class_2338;
import net.minecraft.class_2350;
import net.minecraft.class_2404;
import net.minecraft.class_2561;
import net.minecraft.class_2586;
import net.minecraft.class_2680;
import net.minecraft.class_2742;
import net.minecraft.class_2769;
import net.minecraft.class_3218;
import net.minecraft.class_3222;
import net.minecraft.class_3414;
import net.minecraft.class_3417;
import net.minecraft.class_3419;
import net.minecraft.class_3908;
import net.minecraft.class_4537;
import net.minecraft.class_9331;

public class ServerActions {
    public static final int TAB_OPEN = 0;
    public static final int UPGRADE_ENABLED = 1;
    public static final int SHIFT_CLICK_TO_BACKPACK = 2;
    public static final int PLAY_RECORD = 3;

    public static void swapTool(class_1657 player, double scrollDelta) {
        if (ComponentUtils.isWearingBackpack(player)) {
            int i;
            BackpackWrapper wrapper = ComponentUtils.getBackpackWrapper(player, ComponentUtils.TOOLS_ONLY);
            ItemStackHandler inv = wrapper.getTools();
            if (InventoryHelper.isEmpty(inv)) {
                return;
            }
            int toolSlots = inv.getSlots();
            int lastSlot = toolSlots - 1;
            int j = 0;
            for (int i2 = 0; i2 <= lastSlot; ++i2) {
                if (inv.getStackInSlot(i2).method_7960()) continue;
                ++j;
            }
            class_1799[] tools = new class_1799[j];
            int slot = 0;
            for (i = 0; i <= j - 1; ++i) {
                tools[slot] = inv.getStackInSlot(i).method_7972();
                ++slot;
            }
            ServerActions.swapTool(scrollDelta, tools, player);
            slot = 0;
            for (i = 0; i <= j - 1; ++i) {
                inv.setStackInSlot(i, tools[slot]);
                ++slot;
            }
            if (player instanceof class_3222) {
                class_3222 serverPlayer = (class_3222)player;
                ModAdvancements.ACTION_TRIGGER.trigger(serverPlayer, "swap_tools");
            }
            wrapper.sendDataToClients(ModDataComponents.TOOLS_CONTAINER);
        }
    }

    public static void swapTool(double delta, class_1799[] tools, class_1657 player) {
        int i;
        class_1799 tempStack;
        if (delta > 0.0) {
            tempStack = tools[0];
            for (i = 0; i <= tools.length - 1; ++i) {
                if (i + 1 > tools.length - 1) {
                    tools[tools.length - 1] = player.method_6047();
                    player.method_6122(class_1268.field_5808, tempStack);
                    continue;
                }
                tools[i] = tools[i + 1];
            }
        }
        if (delta < 0.0) {
            tempStack = tools[tools.length - 1];
            for (i = tools.length - 1; i >= 0; --i) {
                if (i - 1 < 0) {
                    tools[0] = player.method_6047();
                    player.method_6122(class_1268.field_5808, tempStack);
                    continue;
                }
                tools[i] = tools[i - 1];
            }
        }
    }

    public static void equipBackpack(class_1657 player, boolean equip) {
        if (equip) {
            ServerActions.handleEquipBackpack(player);
        } else {
            ServerActions.handleUnequipBackpack(player);
        }
    }

    public static boolean swapBackpack(class_1657 player) {
        class_1937 level = player.method_73183();
        if (level.method_8608() || !ComponentUtils.isWearingBackpack(player)) {
            return false;
        }
        if (player.field_7512 instanceof BackpackItemMenu) {
            ((class_3222)player).method_7346();
        }
        class_1799 equippedBackpack = ComponentUtils.getWearingBackpack(player).method_7972();
        class_1799 newBackpack = player.method_6047().method_7972();
        ComponentUtils.getComponent(player).ifPresent(attachment -> {
            attachment.equipBackpack(newBackpack);
            attachment.synchronise();
        });
        ServerActions.runAbilitiesRemoval(player);
        player.method_6047().method_7934(1);
        player.method_31548().method_7394(equippedBackpack);
        return true;
    }

    public static void runAbilitiesRemoval(class_1657 player) {
        BackpackAbilities.ABILITIES.armorAbilityRemovals(player);
    }

    public static boolean equipBackpack(class_1657 player) {
        class_1937 level = player.method_73183();
        if (level.method_8608()) {
            return false;
        }
        if (ComponentUtils.isWearingBackpack(player)) {
            return ServerActions.swapBackpack(player);
        }
        if (player.field_7512 instanceof BackpackItemMenu) {
            ((class_3222)player).method_7346();
        }
        class_1799 stack = player.method_6047().method_7972();
        ComponentUtils.getComponent(player).ifPresent(attachment -> {
            attachment.equipBackpack(stack);
            attachment.synchronise();
        });
        player.method_6047().method_7934(1);
        return true;
    }

    public static void handleEquipBackpack(class_1657 player) {
        if (!ServerActions.equipBackpack(player)) {
            return;
        }
        ServerActions.playEquippingSound(player);
    }

    public static boolean unequipBackpack(class_1657 player) {
        class_1937 level = player.method_73183();
        if (level.method_8608() || !ComponentUtils.isWearingBackpack(player)) {
            return false;
        }
        if (player.field_7512 instanceof BackpackItemMenu) {
            ((class_3222)player).method_7346();
        }
        class_1799 backpack = ComponentUtils.getWearingBackpack(player).method_7972();
        int index = player.method_31548().method_7390(backpack);
        if (index == -1) {
            index = player.method_31548().method_7376();
        }
        if (index == -1) {
            if (player instanceof class_3222) {
                class_3222 serverPlayer = (class_3222)player;
                serverPlayer.method_64398((class_2561)class_2561.method_43471((String)"action.travelersbackpack.unequip_nospace"));
            }
            return false;
        }
        player.method_31548().method_7398(backpack);
        ComponentUtils.getComponent(player).ifPresent(attachment -> {
            attachment.equipBackpack(new class_1799((class_1935)class_1802.field_8162, 0));
            attachment.synchronise();
        });
        return true;
    }

    public static void handleUnequipBackpack(class_1657 player) {
        if (!ServerActions.unequipBackpack(player)) {
            return;
        }
        ServerActions.playEquippingSound(player);
    }

    private static void playEquippingSound(class_1657 player) {
        player.method_73183().method_8396(null, player.method_24515(), (class_3414)class_3417.field_14581.comp_349(), class_3419.field_15248, 1.05f, (1.0f + (player.method_73183().method_8409().method_43057() - player.method_73183().method_8409().method_43057()) * 0.2f) * 0.7f);
    }

    public static void openBackpackFromSlot(class_3222 player, int index, boolean fromSlot) {
        class_1799 backpackStack;
        if (index >= 0 && index < player.method_31548().method_67533().size() && (backpackStack = (class_1799)player.method_31548().method_67533().get(index)).method_7909() instanceof TravelersBackpackItem && !TravelersBackpackConfig.getConfig().backpackSettings.allowOnlyEquippedBackpack && (!fromSlot || TravelersBackpackConfig.getConfig().backpackSettings.allowOpeningFromSlot)) {
            BackpackContainer.openBackpack(player, backpackStack, 1, index);
        }
    }

    public static void openBackpackSettings(class_3222 player, int entityId, boolean open) {
        if (player.method_5628() == entityId) {
            class_1703 class_17032 = player.field_7512;
            if (class_17032 instanceof BackpackBaseMenu) {
                BackpackBaseMenu menu = (BackpackBaseMenu)class_17032;
                if (open) {
                    if (menu.getWrapper().getScreenID() == 3) {
                        class_2586 class_25862 = player.method_51469().method_8321(menu.getWrapper().getBackpackPos());
                        if (class_25862 instanceof BackpackBlockEntity) {
                            backpackBlockEntity = (BackpackBlockEntity)class_25862;
                            ((BackpackBlockEntity)((Object)backpackBlockEntity)).openSettings((class_1657)player, (class_3908)backpackBlockEntity, menu.getWrapper().getBackpackPos());
                        }
                    } else {
                        BackpackSettingsContainer.openSettings(player, menu.getWrapper().getBackpackStack(), menu.getWrapper().getScreenID(), menu.getWrapper().getBackpackSlotIndex());
                    }
                }
            } else {
                backpackBlockEntity = player.field_7512;
                if (backpackBlockEntity instanceof BackpackSettingsMenu) {
                    BackpackSettingsMenu menu = (BackpackSettingsMenu)((Object)backpackBlockEntity);
                    if (!open) {
                        if (menu.getWrapper().getScreenID() == 3) {
                            class_2586 class_25863 = player.method_51469().method_8321(menu.getWrapper().getBackpackPos());
                            if (class_25863 instanceof BackpackBlockEntity) {
                                backpackBlockEntity = (BackpackBlockEntity)class_25863;
                                ((BackpackBlockEntity)((Object)backpackBlockEntity)).openBackpack((class_1657)player, (class_3908)backpackBlockEntity, menu.getWrapper().getBackpackPos());
                            }
                        } else {
                            BackpackContainer.openBackpack(player, menu.getWrapper().getBackpackStack(), menu.getWrapper().getScreenID(), menu.getWrapper().getBackpackSlotIndex());
                        }
                    }
                }
            }
        }
    }

    public static void modifyUpgradeTab(class_3222 player, int slot, boolean open, int packetType) {
        BackpackBaseMenu menu;
        class_1799 upgradeStack;
        class_1703 class_17032 = player.field_7512;
        if (class_17032 instanceof BackpackBaseMenu && !(upgradeStack = (menu = (BackpackBaseMenu)class_17032).getWrapper().getUpgrades().getStackInSlot(slot)).method_7960()) {
            class_1799 updateStack = upgradeStack.method_7972();
            updateStack.method_57379(ServerActions.getPacketType(packetType), (Object)open);
            menu.getWrapper().getUpgrades().setStackInSlot(slot, updateStack);
            if (packetType == 1 && menu.getWrapper().getUpgradeManager().hasUpgradeInSlot(slot)) {
                ((Optional)menu.getWrapper().getUpgradeManager().mappedUpgrades.get((Object)slot)).ifPresent(upgradeBase -> {
                    if (upgradeBase instanceof IEnable) {
                        IEnable upg = (IEnable)((Object)upgradeBase);
                        upg.setEnabled(open);
                    }
                });
            }
        }
    }

    public static class_9331 getPacketType(int type) {
        return switch (type) {
            case 0 -> ModDataComponents.TAB_OPEN;
            case 1 -> ModDataComponents.UPGRADE_ENABLED;
            case 2 -> ModDataComponents.SHIFT_CLICK_TO_BACKPACK;
            case 3 -> ModDataComponents.IS_PLAYING;
            default -> ModDataComponents.TAB_OPEN;
        };
    }

    public static void removeBackpackUpgrade(class_3222 player, int slot) {
        BackpackBaseMenu menu;
        BackpackWrapper wrapper;
        class_1703 class_17032 = player.field_7512;
        if (class_17032 instanceof BackpackBaseMenu && !(wrapper = (menu = (BackpackBaseMenu)class_17032).getWrapper()).getUpgrades().getStackInSlot(slot).method_7960()) {
            Optional upgrade = (Optional)wrapper.getUpgradeManager().mappedUpgrades.get((Object)slot);
            class_1799 upgradeStack = wrapper.getUpgrades().getStackInSlot(slot).method_7972();
            upgradeStack.method_57379(ModDataComponents.TAB_OPEN, (Object)false);
            wrapper.getUpgrades().setStackInSlot(slot, class_1799.field_8037);
            upgrade.ifPresent(upgradeBase -> upgradeBase.onUpgradeRemoved(upgradeStack, (class_1657)player));
            if (!player.method_31548().method_7394(upgradeStack)) {
                player.method_7328(upgradeStack, true);
            }
            wrapper.saveHandler.run();
        }
    }

    public static void switchAbilitySlider(class_3222 player, boolean sliderValue) {
        BackpackWrapper wrapper = ComponentUtils.getBackpackWrapperArtificial((class_1657)player);
        class_1703 class_17032 = player.field_7512;
        if (class_17032 instanceof BackpackBaseMenu) {
            BackpackBaseMenu menu = (BackpackBaseMenu)class_17032;
            wrapper = menu.getWrapper();
        }
        wrapper.setDataAndSync(ModDataComponents.ABILITY_ENABLED, sliderValue);
        if (wrapper.getBackpackOwner() != null) {
            if (BackpackAbilities.isOnList(BackpackAbilities.ITEM_ABILITIES_REMOVAL_LIST, wrapper.getBackpackStack()) && !sliderValue) {
                BackpackAbilities.ABILITIES.abilityRemoval(wrapper.getBackpackStack(), wrapper.getBackpackOwner());
            }
            if (wrapper.getBackpackStack().method_7909() == ModItems.CHICKEN_TRAVELERS_BACKPACK && wrapper.getCooldown() <= 0) {
                BackpackAbilities.ABILITIES.chickenAbility(wrapper.getBackpackStack(), wrapper.getBackpackOwner(), true);
            }
        }
    }

    public static void showToolSlots(class_3222 player, boolean show) {
        class_1703 class_17032 = player.field_7512;
        if (class_17032 instanceof BackpackBaseMenu) {
            BackpackBaseMenu menu = (BackpackBaseMenu)class_17032;
            menu.getWrapper().setDataAndSync(ModDataComponents.SHOW_TOOL_SLOTS, show);
        }
    }

    public static void sortBackpack(class_3222 player, int button, boolean shiftPressed) {
        class_1703 class_17032 = player.field_7512;
        if (class_17032 instanceof BackpackBaseMenu) {
            BackpackBaseMenu menu = (BackpackBaseMenu)class_17032;
            ContainerSorter.selectSort(menu.getWrapper(), (class_1657)player, button, shiftPressed);
        }
    }

    public static void toggleVisibility(class_1657 player) {
        class_1703 class_17032 = player.field_7512;
        if (class_17032 instanceof BackpackSettingsMenu) {
            BackpackSettingsMenu menu = (BackpackSettingsMenu)class_17032;
            boolean visibility = (Boolean)menu.getWrapper().getBackpackStack().method_58695(ModDataComponents.IS_VISIBLE, (Object)true);
            menu.getWrapper().setDataAndSync(ModDataComponents.IS_VISIBLE, !visibility);
        }
    }

    public static void toggleButtonsVisibility(class_1657 player) {
        class_1703 class_17032 = player.field_7512;
        if (class_17032 instanceof BackpackBaseMenu) {
            BackpackBaseMenu menu = (BackpackBaseMenu)class_17032;
            boolean current = menu.getWrapper().showMoreButtons();
            menu.getWrapper().setDataAndSync(ModDataComponents.SHOW_MORE_BUTTONS, !current);
        }
    }

    public static void toggleSleepingBag(class_1657 player, class_2338 pos) {
        class_1937 level = player.method_73183();
        class_2586 class_25862 = level.method_8321(pos);
        if (class_25862 instanceof BackpackBlockEntity) {
            BackpackBlockEntity blockEntity = (BackpackBlockEntity)class_25862;
            if (!blockEntity.isSleepingBagDeployed()) {
                if (!blockEntity.deploySleepingBag(level, pos) && player instanceof class_3222) {
                    class_3222 serverPlayer = (class_3222)player;
                    serverPlayer.method_64398((class_2561)class_2561.method_43471((String)"action.travelersbackpack.deploy_sleeping_bag"));
                }
            } else {
                blockEntity.removeSleepingBag(level, blockEntity.getBlockDirection());
            }
            if (!level.method_8608()) {
                ((class_3222)player).method_7346();
            }
        }
    }

    public static void toggleSleepingBag(class_1657 player, class_2338 pos, boolean isEquipped) {
        class_1937 level = player.method_73183();
        if (isEquipped) {
            class_2338 sleepingBagPos2;
            class_2338 sleepingBagPos1 = pos.method_10093(player.method_5735());
            boolean canPlace = ServerActions.placeAndUseSleepingBag(player, sleepingBagPos1, sleepingBagPos2 = sleepingBagPos1.method_10093(player.method_5735()), pos, level, player.method_5735());
            if (!canPlace) {
                if (player instanceof class_3222) {
                    class_3222 serverPlayer = (class_3222)player;
                    serverPlayer.method_64398((class_2561)class_2561.method_43471((String)"action.travelersbackpack.deploy_sleeping_bag"));
                    serverPlayer.method_7346();
                }
                return;
            }
            if (!level.method_8608() && player instanceof class_3222) {
                class_3222 serverPlayer = (class_3222)player;
                player.method_7269(pos.method_10093(player.method_5735()).method_10093(player.method_5735())).ifLeft(bedSleepingProblem -> {
                    if (bedSleepingProblem.method_19206() != null) {
                        player.method_7353(bedSleepingProblem.method_19206(), true);
                        if (level.method_8320(sleepingBagPos1).method_26204() instanceof SleepingBagBlock) {
                            level.method_8501(sleepingBagPos1, class_2246.field_10124.method_9564());
                        }
                        if (level.method_8320(sleepingBagPos2).method_26204() instanceof SleepingBagBlock) {
                            level.method_8501(sleepingBagPos2, class_2246.field_10124.method_9564());
                        }
                    }
                });
                ModAdvancements.ACTION_TRIGGER.trigger(serverPlayer, "use_sleeping_bag");
                serverPlayer.method_7346();
            }
        } else {
            class_2586 sleepingBagPos2 = level.method_8321(pos);
            if (sleepingBagPos2 instanceof BackpackBlockEntity) {
                BackpackBlockEntity blockEntity = (BackpackBlockEntity)sleepingBagPos2;
                if (!blockEntity.isSleepingBagDeployed()) {
                    if (!blockEntity.deploySleepingBag(level, pos) && player instanceof class_3222) {
                        class_3222 serverPlayer = (class_3222)player;
                        serverPlayer.method_64398((class_2561)class_2561.method_43471((String)"action.travelersbackpack.deploy_sleeping_bag"));
                    }
                } else {
                    blockEntity.removeSleepingBag(level, blockEntity.getBlockDirection());
                }
                if (!level.method_8608()) {
                    ((class_3222)player).method_7346();
                }
            }
        }
    }

    public static boolean placeAndUseSleepingBag(class_1657 player, class_2338 sleepingBagPos1, class_2338 sleepingBagPos2, class_2338 pos, class_1937 level, class_2350 direction) {
        if (!player.method_24828() || level.method_8320(sleepingBagPos1.method_10074()).method_26215() || level.method_8320(sleepingBagPos1.method_10074()).method_26204() instanceof class_2404 || !class_2244.method_27352((class_1937)level)) {
            return false;
        }
        class_1799 backpack = ComponentUtils.getWearingBackpack(player);
        if (BackpackBlockEntity.canPlaceSleepingBag(sleepingBagPos2, level) && BackpackBlockEntity.canPlaceSleepingBag(sleepingBagPos1, level)) {
            level.method_8396(null, sleepingBagPos2, class_3417.field_15226, class_3419.field_15245, 0.5f, 1.0f);
            if (!level.method_8608()) {
                class_2680 sleepingBagState = BackpackBlockEntity.getProperSleepingBag((Integer)backpack.method_58695(ModDataComponents.SLEEPING_BAG_COLOR, (Object)class_1767.field_7964.method_7789()));
                level.method_8652(sleepingBagPos1, (class_2680)((class_2680)((class_2680)sleepingBagState.method_11657((class_2769)SleepingBagBlock.field_11177, (Comparable)direction)).method_11657(SleepingBagBlock.PART, (Comparable)class_2742.field_12557)).method_11657((class_2769)SleepingBagBlock.CAN_DROP, (Comparable)Boolean.valueOf(false)), 3);
                level.method_8652(sleepingBagPos2, (class_2680)((class_2680)((class_2680)sleepingBagState.method_11657((class_2769)SleepingBagBlock.field_11177, (Comparable)direction)).method_11657(SleepingBagBlock.PART, (Comparable)class_2742.field_12560)).method_11657((class_2769)SleepingBagBlock.CAN_DROP, (Comparable)Boolean.valueOf(false)), 3);
                level.method_8408(pos, sleepingBagState.method_26204());
                level.method_8408(sleepingBagPos2, sleepingBagState.method_26204());
            }
            return true;
        }
        return false;
    }

    public static long throwPotion(class_1937 level, class_1657 player, class_1799 potionStack, boolean isSplash) {
        level.method_43128(null, player.method_23317(), player.method_23318(), player.method_23321(), isSplash ? class_3417.field_14910 : class_3417.field_14767, class_3419.field_15254, 0.5f, 0.4f / (level.method_8409().method_43057() * 0.4f + 0.8f));
        if (level instanceof class_3218) {
            class_3218 serverlevel = (class_3218)level;
            class_1676.method_61549((class_1676.class_9876)(isSplash ? class_10691::new : class_10690::new), (class_3218)serverlevel, (class_1799)potionStack, (class_1309)player, (float)-20.0f, (float)class_4537.field_55046, (float)1.0f);
        }
        if (!player.method_31549().field_7477) {
            return 27000L;
        }
        return 0L;
    }

    public static boolean setFluidEffect(class_1937 level, class_1657 player, FluidTank tank) {
        FluidVariantWrapper fluidStack = tank.getFluid();
        boolean done = false;
        if (EffectFluidRegistry.hasExecutableEffects(fluidStack, level, (class_1297)player)) {
            done = EffectFluidRegistry.executeEffects(fluidStack, (class_1297)player, level);
        }
        return done;
    }

    public static void switchHoseMode(class_1657 player, double scrollDelta) {
        class_1799 hose = player.method_6047();
        if (hose.method_7909() instanceof HoseItem) {
            List settings = (List)hose.method_58695(ModDataComponents.HOSE_MODES, List.of(Integer.valueOf(1), Integer.valueOf(1)));
            if (scrollDelta > 0.0) {
                int nextMode = (Integer)settings.get(0) + 1;
                hose.method_57379(ModDataComponents.HOSE_MODES, List.of(Integer.valueOf(nextMode == 4 ? 1 : nextMode), (Integer)settings.get(1)));
            } else if (scrollDelta < 0.0) {
                int nextMode = (Integer)settings.get(0) - 1;
                hose.method_57379(ModDataComponents.HOSE_MODES, List.of(Integer.valueOf(nextMode == 0 ? 3 : nextMode), (Integer)settings.get(1)));
            }
        }
        if (!player.method_73183().method_8608()) {
            PacketDistributor.sendToPlayer((class_3222)player, new ClientboundSyncItemStackPacket(player.method_5628(), player.method_31548().method_67532(), hose, ItemStackUtils.createDataComponentMap(hose, ModDataComponents.HOSE_MODES)));
        }
    }

    public static void toggleHoseTank(class_1657 player) {
        class_1799 hose = player.method_6047();
        if (hose.method_7909() instanceof HoseItem) {
            List settings = (List)hose.method_58695(ModDataComponents.HOSE_MODES, List.of(Integer.valueOf(1), Integer.valueOf(1)));
            if ((Integer)settings.get(1) == 1) {
                hose.method_57379(ModDataComponents.HOSE_MODES, List.of((Integer)settings.get(0), Integer.valueOf(2)));
            } else {
                hose.method_57379(ModDataComponents.HOSE_MODES, List.of((Integer)settings.get(0), Integer.valueOf(1)));
            }
        }
        if (!player.method_73183().method_8608()) {
            PacketDistributor.sendToPlayer((class_3222)player, new ClientboundSyncItemStackPacket(player.method_5628(), player.method_31548().method_67532(), hose, ItemStackUtils.createDataComponentMap(hose, ModDataComponents.HOSE_MODES)));
        }
    }
}

