/*
 * Decompiled with CFR 0.152.
 */
package com.tiviacz.travelersbackpack.item.upgrades;

import com.tiviacz.travelersbackpack.components.Fluids;
import com.tiviacz.travelersbackpack.components.RenderInfo;
import com.tiviacz.travelersbackpack.config.TravelersBackpackConfig;
import com.tiviacz.travelersbackpack.init.ModDataComponents;
import com.tiviacz.travelersbackpack.inventory.FluidVariantWrapper;
import com.tiviacz.travelersbackpack.inventory.UpgradeManager;
import com.tiviacz.travelersbackpack.inventory.upgrades.UpgradeBase;
import com.tiviacz.travelersbackpack.inventory.upgrades.tanks.TanksUpgrade;
import com.tiviacz.travelersbackpack.item.upgrades.UpgradeItem;
import com.tiviacz.travelersbackpack.util.FluidTypeHelper;
import java.util.Optional;
import java.util.function.Consumer;
import net.fabricmc.api.EnvType;
import net.fabricmc.api.Environment;
import net.minecraft.class_10712;
import net.minecraft.class_124;
import net.minecraft.class_1792;
import net.minecraft.class_1799;
import net.minecraft.class_1836;
import net.minecraft.class_2487;
import net.minecraft.class_2520;
import net.minecraft.class_2561;
import net.minecraft.class_7699;
import org.apache.commons.lang3.function.TriFunction;

public class TanksUpgradeItem
extends UpgradeItem {
    public TanksUpgradeItem(class_1792.class_1793 pProperties) {
        super(pProperties.method_57349(ModDataComponents.FLUIDS, (Object)Fluids.empty()), "tanks_upgrade");
    }

    public boolean method_45382(class_7699 enabledFeatures) {
        return TravelersBackpackConfig.getConfig().backpackUpgrades.enableTanksUpgrade && super.method_45382(enabledFeatures);
    }

    public static boolean canBePutInBackpack(long backpackFluidStorageSize, class_1799 tanksUpgrade) {
        long[] fluidTanks = new long[]{0L, 0L};
        if (tanksUpgrade.method_57826(ModDataComponents.FLUIDS)) {
            Fluids fluidTanks2 = (Fluids)tanksUpgrade.method_58694(ModDataComponents.FLUIDS);
            fluidTanks[0] = fluidTanks2.leftFluidStack().getAmount();
            fluidTanks[1] = fluidTanks2.rightFluidStack().getAmount();
        }
        return backpackFluidStorageSize >= fluidTanks[0] && backpackFluidStorageSize >= fluidTanks[1];
    }

    public static FluidVariantWrapper getLeftFluidStack(class_1799 tanksUpgrade) {
        if (tanksUpgrade.method_57826(ModDataComponents.FLUIDS)) {
            Fluids fluidTanks2 = (Fluids)tanksUpgrade.method_58694(ModDataComponents.FLUIDS);
            return fluidTanks2.leftFluidStack();
        }
        return FluidVariantWrapper.blank();
    }

    public static FluidVariantWrapper getRightFluidStack(class_1799 tanksUpgrade) {
        if (tanksUpgrade.method_57826(ModDataComponents.FLUIDS)) {
            Fluids fluidTanks2 = (Fluids)tanksUpgrade.method_58694(ModDataComponents.FLUIDS);
            return fluidTanks2.rightFluidStack();
        }
        return FluidVariantWrapper.blank();
    }

    public static RenderInfo writeToRenderData() {
        class_2487 tag = new class_2487();
        tag.method_10566("LeftTank", (class_2520)new class_2487());
        tag.method_10566("RightTank", (class_2520)new class_2487());
        return new RenderInfo(tag);
    }

    @Override
    @Environment(value=EnvType.CLIENT)
    public void method_67187(class_1799 stack, class_1792.class_9635 context, class_10712 tooltipDisplay, Consumer<class_2561> componentConsumer, class_1836 tooltipFlag) {
        super.method_67187(stack, context, tooltipDisplay, componentConsumer, tooltipFlag);
        if (stack.method_57826(ModDataComponents.FLUIDS)) {
            Fluids fluidTanks = (Fluids)stack.method_58694(ModDataComponents.FLUIDS);
            FluidVariantWrapper leftFluidStack = fluidTanks.leftFluidStack();
            FluidVariantWrapper rightFluidStack = fluidTanks.rightFluidStack();
            if (!leftFluidStack.isEmpty()) {
                componentConsumer.accept((class_2561)class_2561.method_43470((String)(FluidTypeHelper.getFluidVariantName(leftFluidStack.fluidVariant()).getString() + ": " + leftFluidStack.getAmount() + "mB")).method_27692(class_124.field_1078));
            }
            if (!rightFluidStack.isEmpty()) {
                componentConsumer.accept((class_2561)class_2561.method_43470((String)(FluidTypeHelper.getFluidVariantName(rightFluidStack.fluidVariant()).getString() + ": " + rightFluidStack.getAmount() + "mB")).method_27692(class_124.field_1078));
            }
        }
    }

    @Override
    public boolean requiresEquippedBackpack() {
        return false;
    }

    @Override
    public Class<? extends UpgradeBase<?>> getUpgradeClass() {
        return TanksUpgrade.class;
    }

    @Override
    public TriFunction<UpgradeManager, Integer, class_1799, Optional<? extends UpgradeBase<?>>> getUpgrade() {
        return (upgradeManager, dataHolderSlot, provider) -> {
            Fluids fluids = (Fluids)provider.method_58695(ModDataComponents.FLUIDS, (Object)new Fluids(FluidVariantWrapper.blank(), FluidVariantWrapper.blank()));
            return Optional.of(new TanksUpgrade((UpgradeManager)upgradeManager, (int)dataHolderSlot, fluids));
        };
    }
}

