/*
 * Decompiled with CFR 0.152.
 */
package me.lucko.luckperms.common.actionlog;

import com.google.common.collect.ImmutableList;
import java.util.ArrayList;
import java.util.List;
import java.util.Objects;
import me.lucko.luckperms.common.actionlog.LoggedAction;
import me.lucko.luckperms.common.filter.PageParameters;
import org.checkerframework.checker.nullness.qual.Nullable;

public class LogPage {
    private final List<LoggedAction> content;
    private final @Nullable PageParameters params;
    private final int totalEntries;

    public static LogPage of(List<LoggedAction> content, @Nullable PageParameters params, int totalEntries) {
        return new LogPage(content, params, totalEntries);
    }

    LogPage(List<LoggedAction> content, @Nullable PageParameters params, int totalEntries) {
        this.content = ImmutableList.copyOf(content);
        this.params = params;
        this.totalEntries = totalEntries;
    }

    public List<LoggedAction> getContent() {
        return this.content;
    }

    public List<Entry<LoggedAction>> getNumberedContent() {
        int startIndex = this.params != null ? this.params.pageSize() * (this.params.pageNumber() - 1) : 0;
        ArrayList<Entry<LoggedAction>> numberedContent = new ArrayList<Entry<LoggedAction>>();
        for (int i = 0; i < this.content.size(); ++i) {
            int index = startIndex + i + 1;
            numberedContent.add(new Entry<LoggedAction>(index, this.content.get(i)));
        }
        return numberedContent;
    }

    public int getTotalEntries() {
        return this.totalEntries;
    }

    public static final class Entry<T> {
        private final int position;
        private final T value;

        public Entry(int position, T value) {
            this.position = position;
            this.value = value;
        }

        public int position() {
            return this.position;
        }

        public T value() {
            return this.value;
        }

        public String toString() {
            return this.position + ": " + String.valueOf(this.value);
        }

        public boolean equals(Object o) {
            if (this == o) {
                return true;
            }
            if (!(o instanceof Entry)) {
                return false;
            }
            Entry entry = (Entry)o;
            return this.position == entry.position && Objects.equals(this.value, entry.value);
        }

        public int hashCode() {
            return Objects.hash(this.position, this.value);
        }
    }
}

