/*
 * Decompiled with CFR 0.152.
 */
package me.lucko.luckperms.common.api.implementation;

import java.util.List;
import java.util.Objects;
import java.util.concurrent.CompletableFuture;
import me.lucko.luckperms.common.actionlog.LogDispatcher;
import me.lucko.luckperms.common.actionlog.LogPage;
import me.lucko.luckperms.common.actionlog.LoggedAction;
import me.lucko.luckperms.common.actionlog.filter.ActionFilters;
import me.lucko.luckperms.common.api.implementation.ApiActionFilter;
import me.lucko.luckperms.common.api.implementation.ApiActionLog;
import me.lucko.luckperms.common.filter.FilterList;
import me.lucko.luckperms.common.filter.PageParameters;
import me.lucko.luckperms.common.plugin.LuckPermsPlugin;
import net.luckperms.api.actionlog.Action;
import net.luckperms.api.actionlog.ActionLog;
import net.luckperms.api.actionlog.ActionLogger;
import net.luckperms.api.actionlog.filter.ActionFilter;
import net.luckperms.api.util.Page;
import org.checkerframework.checker.nullness.qual.NonNull;

public class ApiActionLogger
implements ActionLogger {
    private final LuckPermsPlugin plugin;

    public ApiActionLogger(LuckPermsPlugin plugin) {
        this.plugin = plugin;
    }

    @Override
    public @NonNull Action.Builder actionBuilder() {
        return LoggedAction.build();
    }

    @Override
    @Deprecated
    public @NonNull CompletableFuture<ActionLog> getLog() {
        return this.plugin.getStorage().getLogPage(ActionFilters.all(), null).thenApply(result -> new ApiActionLog(result.getContent()));
    }

    @Override
    public @NonNull CompletableFuture<List<Action>> queryActions(@NonNull ActionFilter filter) {
        return ((CompletableFuture)this.plugin.getStorage().getLogPage(ApiActionLogger.getFilterList(filter), null).thenApply(x$0 -> new ActionPage((LogPage)x$0))).thenApply(Page::entries);
    }

    @Override
    public @NonNull CompletableFuture<Page<Action>> queryActions(@NonNull ActionFilter filter, int pageSize, int pageNumber) {
        return this.plugin.getStorage().getLogPage(ApiActionLogger.getFilterList(filter), new PageParameters(pageSize, pageNumber)).thenApply(x$0 -> new ActionPage((LogPage)x$0));
    }

    @Override
    public @NonNull CompletableFuture<Void> submit(@NonNull Action entry) {
        return this.plugin.getLogDispatcher().dispatchFromApi((LoggedAction)entry);
    }

    @Override
    public @NonNull CompletableFuture<Void> submitToStorage(@NonNull Action entry) {
        return this.plugin.getLogDispatcher().logToStorage((LoggedAction)entry);
    }

    @Override
    public @NonNull CompletableFuture<Void> broadcastAction(@NonNull Action entry) {
        LogDispatcher dispatcher = this.plugin.getLogDispatcher();
        CompletableFuture<Void> messagingFuture = dispatcher.logToStorage((LoggedAction)entry);
        dispatcher.broadcastFromApi((LoggedAction)entry);
        return messagingFuture;
    }

    private static FilterList<Action> getFilterList(ActionFilter filter) {
        Objects.requireNonNull(filter, "filter");
        if (filter instanceof ApiActionFilter) {
            return ((ApiActionFilter)filter).getFilter();
        }
        throw new IllegalArgumentException("Unknown filter type: " + String.valueOf(filter.getClass()));
    }

    private static final class ActionPage
    implements Page<Action> {
        private final LogPage page;

        private ActionPage(LogPage page) {
            this.page = page;
        }

        @Override
        public @NonNull List<Action> entries() {
            return this.page.getContent();
        }

        @Override
        public int overallSize() {
            return this.page.getTotalEntries();
        }
    }
}

