/*
 * Decompiled with CFR 0.152.
 */
package me.lucko.luckperms.common.bulkupdate.action;

import me.lucko.luckperms.common.bulkupdate.BulkUpdateField;
import me.lucko.luckperms.common.bulkupdate.action.BulkUpdateAction;
import me.lucko.luckperms.common.node.factory.NodeBuilders;
import net.luckperms.api.context.MutableContextSet;
import net.luckperms.api.node.Node;

public class UpdateAction
implements BulkUpdateAction {
    private final BulkUpdateField field;
    private final String newValue;

    public static UpdateAction of(BulkUpdateField field, String value) {
        return new UpdateAction(field, value);
    }

    private UpdateAction(BulkUpdateField field, String newValue) {
        this.field = field;
        this.newValue = newValue;
    }

    @Override
    public String getName() {
        return "update";
    }

    public BulkUpdateField getField() {
        return this.field;
    }

    public String getNewValue() {
        return this.newValue;
    }

    @Override
    public Node apply(Node from) {
        switch (this.field) {
            case PERMISSION: {
                return NodeBuilders.determineMostApplicable(this.newValue).value(from.getValue()).expiry(from.getExpiry()).context(from.getContexts()).build();
            }
            case SERVER: {
                MutableContextSet contexts = from.getContexts().mutableCopy();
                contexts.removeAll("server");
                if (!this.newValue.equals("global")) {
                    contexts.add("server", this.newValue);
                }
                return from.toBuilder().context(contexts).build();
            }
            case WORLD: {
                MutableContextSet contexts = from.getContexts().mutableCopy();
                contexts.removeAll("world");
                if (!this.newValue.equals("global")) {
                    contexts.add("world", this.newValue);
                }
                return from.toBuilder().context(contexts).build();
            }
        }
        throw new RuntimeException();
    }
}

