/*
 * Decompiled with CFR 0.152.
 */
package me.lucko.luckperms.common.cacheddata.type;

import com.google.common.collect.ForwardingMap;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import me.lucko.luckperms.common.cacheddata.CacheMetadata;
import me.lucko.luckperms.common.cacheddata.result.IntegerResult;
import me.lucko.luckperms.common.cacheddata.result.StringResult;
import me.lucko.luckperms.common.cacheddata.type.MetaAccumulator;
import me.lucko.luckperms.common.cacheddata.type.MetaCache;
import me.lucko.luckperms.common.plugin.LuckPermsPlugin;
import me.lucko.luckperms.common.verbose.event.CheckOrigin;
import net.luckperms.api.cacheddata.CachedMetaData;
import net.luckperms.api.node.types.MetaNode;
import net.luckperms.api.node.types.PrefixNode;
import net.luckperms.api.node.types.SuffixNode;
import net.luckperms.api.node.types.WeightNode;
import net.luckperms.api.query.QueryOptions;
import org.checkerframework.checker.nullness.qual.NonNull;
import org.checkerframework.checker.nullness.qual.Nullable;

public class MonitoredMetaCache
extends MetaCache
implements CachedMetaData {
    private final LuckPermsPlugin plugin;
    private final CacheMetadata metadata;

    public MonitoredMetaCache(LuckPermsPlugin plugin, QueryOptions queryOptions, CacheMetadata metadata, MetaAccumulator sourceMeta) {
        super(plugin, queryOptions, sourceMeta);
        this.plugin = plugin;
        this.metadata = metadata;
    }

    @Override
    public @NonNull StringResult<MetaNode> getMetaValue(String key, CheckOrigin origin) {
        StringResult<MetaNode> value = super.getMetaValue(key, origin);
        this.plugin.getVerboseHandler().offerMetaCheckEvent(origin, this.metadata.getVerboseCheckInfo(), this.metadata.getQueryOptions(), key, value);
        return value;
    }

    @Override
    public @NonNull StringResult<PrefixNode> getPrefix(CheckOrigin origin) {
        StringResult<PrefixNode> value = super.getPrefix(origin);
        this.plugin.getVerboseHandler().offerMetaCheckEvent(origin, this.metadata.getVerboseCheckInfo(), this.metadata.getQueryOptions(), "prefix", value);
        return value;
    }

    @Override
    public @NonNull StringResult<SuffixNode> getSuffix(CheckOrigin origin) {
        StringResult<SuffixNode> value = super.getSuffix(origin);
        this.plugin.getVerboseHandler().offerMetaCheckEvent(origin, this.metadata.getVerboseCheckInfo(), this.metadata.getQueryOptions(), "suffix", value);
        return value;
    }

    @Override
    public @NonNull Map<String, List<StringResult<MetaNode>>> getMetaResults(CheckOrigin origin) {
        return new MonitoredMetaMap(super.getMetaResults(origin), origin);
    }

    @Override
    public @NonNull IntegerResult<WeightNode> getWeight(CheckOrigin origin) {
        IntegerResult<WeightNode> value = super.getWeight(origin);
        this.plugin.getVerboseHandler().offerMetaCheckEvent(origin, this.metadata.getVerboseCheckInfo(), this.metadata.getQueryOptions(), "weight", value.asStringResult());
        return value;
    }

    @Override
    public @Nullable String getPrimaryGroup(CheckOrigin origin) {
        String value = super.getPrimaryGroup(origin);
        this.plugin.getVerboseHandler().offerMetaCheckEvent(origin, this.metadata.getVerboseCheckInfo(), this.metadata.getQueryOptions(), "primarygroup", StringResult.of(value));
        return value;
    }

    private final class MonitoredMetaMap
    extends ForwardingMap<String, List<StringResult<MetaNode>>> {
        private final Map<String, List<StringResult<MetaNode>>> delegate;
        private final CheckOrigin origin;

        private MonitoredMetaMap(Map<String, List<StringResult<MetaNode>>> delegate, CheckOrigin origin) {
            this.delegate = delegate;
            this.origin = origin;
        }

        protected Map<String, List<StringResult<MetaNode>>> delegate() {
            return this.delegate;
        }

        public List<StringResult<MetaNode>> get(Object k) {
            if (k == null) {
                return null;
            }
            String key = (String)k;
            List values = (List)super.get((Object)key);
            if (values == null || values.isEmpty()) {
                MonitoredMetaCache.this.plugin.getVerboseHandler().offerMetaCheckEvent(this.origin, MonitoredMetaCache.this.metadata.getVerboseCheckInfo(), MonitoredMetaCache.this.metadata.getQueryOptions(), key, StringResult.nullResult());
            } else {
                StringResult result;
                Iterator it = values.iterator();
                StringResult root = result = ((StringResult)it.next()).copy();
                while (it.hasNext()) {
                    StringResult nested = ((StringResult)it.next()).copy();
                    root.setOverriddenResult(nested);
                    root = nested;
                }
                MonitoredMetaCache.this.plugin.getVerboseHandler().offerMetaCheckEvent(this.origin, MonitoredMetaCache.this.metadata.getVerboseCheckInfo(), MonitoredMetaCache.this.metadata.getQueryOptions(), key, result);
            }
            return values;
        }
    }
}

