/*
 * Decompiled with CFR 0.152.
 */
package me.lucko.luckperms.common.command;

import com.mojang.brigadier.Command;
import com.mojang.brigadier.context.CommandContext;
import com.mojang.brigadier.exceptions.CommandSyntaxException;
import com.mojang.brigadier.suggestion.SuggestionProvider;
import com.mojang.brigadier.suggestion.Suggestions;
import com.mojang.brigadier.suggestion.SuggestionsBuilder;
import java.util.ArrayList;
import java.util.List;
import java.util.concurrent.CompletableFuture;
import me.lucko.luckperms.common.command.CommandManager;
import me.lucko.luckperms.common.command.utils.ArgumentTokenizer;
import me.lucko.luckperms.common.config.ConfigKeys;
import me.lucko.luckperms.common.plugin.LuckPermsPlugin;
import me.lucko.luckperms.common.sender.Sender;

public abstract class BrigadierCommandExecutor<S>
extends CommandManager
implements Command<S>,
SuggestionProvider<S> {
    protected static final String[] COMMAND_ALIASES = new String[]{"luckperms", "lp", "perm", "perms", "permission", "permissions"};
    private final LuckPermsPlugin plugin;

    protected BrigadierCommandExecutor(LuckPermsPlugin plugin) {
        super(plugin);
        this.plugin = plugin;
    }

    public abstract Sender getSender(S var1);

    public abstract List<String> resolveSelectors(S var1, List<String> var2);

    public int run(CommandContext<S> context) throws CommandSyntaxException {
        Object source = context.getSource();
        Sender sender = this.getSender(source);
        int start = context.getRange().getStart();
        String buffer = context.getInput().substring(start);
        List<String> arguments = this.plugin.getConfiguration().get(ConfigKeys.RESOLVE_COMMAND_SELECTORS) != false ? this.resolveSelectors(source, ArgumentTokenizer.EXECUTE.tokenizeInput(buffer)) : ArgumentTokenizer.EXECUTE.tokenizeInput(buffer);
        String label = arguments.remove(0);
        if (label.startsWith("/")) {
            label = label.substring(1);
        }
        this.executeCommand(sender, label, arguments);
        return 1;
    }

    public CompletableFuture<Suggestions> getSuggestions(CommandContext<S> context, SuggestionsBuilder builder) throws CommandSyntaxException {
        Object source = context.getSource();
        Sender sender = this.getSender(source);
        int idx = builder.getStart();
        String buffer = builder.getInput().substring(idx);
        idx += buffer.length();
        List<String> arguments = ArgumentTokenizer.TAB_COMPLETE.tokenizeInput(buffer);
        List<String> resolvedArguments = this.plugin.getConfiguration().get(ConfigKeys.RESOLVE_COMMAND_SELECTORS) != false ? this.resolveSelectors(source, new ArrayList<String>(arguments)) : arguments;
        if (!arguments.isEmpty() && !resolvedArguments.isEmpty()) {
            idx -= arguments.get(arguments.size() - 1).length();
        }
        List<String> completions = this.tabCompleteCommand(sender, resolvedArguments);
        builder = builder.createOffset(idx);
        for (String completion : completions) {
            builder.suggest(completion);
        }
        return builder.buildFuture();
    }
}

