/*
 * Decompiled with CFR 0.152.
 */
package me.lucko.luckperms.common.command.abstraction;

import java.util.Collections;
import java.util.List;
import java.util.Locale;
import java.util.concurrent.locks.ReentrantLock;
import java.util.stream.Collectors;
import me.lucko.luckperms.common.command.abstraction.Command;
import me.lucko.luckperms.common.command.abstraction.CommandException;
import me.lucko.luckperms.common.command.spec.CommandSpec;
import me.lucko.luckperms.common.command.tabcomplete.CompletionSupplier;
import me.lucko.luckperms.common.command.tabcomplete.TabCompleter;
import me.lucko.luckperms.common.command.utils.ArgumentList;
import me.lucko.luckperms.common.locale.Message;
import me.lucko.luckperms.common.plugin.LuckPermsPlugin;
import me.lucko.luckperms.common.sender.Sender;
import me.lucko.luckperms.common.util.Predicates;
import org.checkerframework.checker.nullness.qual.NonNull;

public abstract class ParentCommand<T, I>
extends Command<Void> {
    private final List<Command<T>> children;
    private final Type type;

    public ParentCommand(CommandSpec spec, String name, Type type, List<Command<T>> children) {
        super(spec, name, null, Predicates.alwaysFalse());
        this.children = children;
        this.type = type;
    }

    public @NonNull List<Command<T>> getChildren() {
        return this.children;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void execute(LuckPermsPlugin plugin, Sender sender, Void ignored, ArgumentList args, String label) {
        if (args.size() < this.type.minArgs) {
            this.sendUsage(sender, label);
            return;
        }
        Command sub = this.getChildren().stream().filter(s -> s.getName().equalsIgnoreCase(args.get(this.type.cmdIndex))).findFirst().orElse(null);
        if (sub == null) {
            Message.COMMAND_NOT_RECOGNISED.send(sender);
            return;
        }
        if (!sub.isAuthorized(sender)) {
            Message.COMMAND_NO_PERMISSION.send(sender);
            return;
        }
        if (sub.getArgumentCheck().test(args.size() - this.type.minArgs)) {
            sub.sendDetailedUsage(sender, label);
            return;
        }
        if (this.type == Type.TARGETED) {
            String targetArgument = args.get(0);
            I targetId = this.parseTarget(targetArgument, plugin, sender);
            if (targetId == null) {
                return;
            }
            ReentrantLock lock = this.getLockForTarget(targetId);
            lock.lock();
            try {
                T target = this.getTarget(targetId, plugin, sender);
                if (target == null) {
                    return;
                }
                try {
                    sub.execute(plugin, sender, target, args.subList(this.type.minArgs, args.size()), label);
                }
                catch (CommandException e) {
                    e.handle(sender, label, sub);
                }
                this.cleanup(target, plugin);
            }
            finally {
                lock.unlock();
            }
        }
        try {
            sub.execute(plugin, sender, null, args.subList(this.type.minArgs, args.size()), label);
        }
        catch (CommandException e) {
            e.handle(sender, label, sub);
        }
    }

    @Override
    public List<String> tabComplete(LuckPermsPlugin plugin, Sender sender, ArgumentList args) {
        switch (this.type.ordinal()) {
            case 1: {
                return TabCompleter.create().at(0, CompletionSupplier.startsWith(() -> this.getTargets(plugin).stream())).at(1, CompletionSupplier.startsWith(() -> this.getChildren().stream().filter(s -> s.isAuthorized(sender)).map(s -> s.getName().toLowerCase(Locale.ROOT)))).from(2, partial -> this.getChildren().stream().filter(s -> s.isAuthorized(sender)).filter(s -> s.getName().equalsIgnoreCase(args.get(1))).findFirst().map(cmd -> cmd.tabComplete(plugin, sender, args.subList(2, args.size()))).orElse(Collections.emptyList())).complete((List<String>)((Object)args));
            }
            case 0: {
                return TabCompleter.create().at(0, CompletionSupplier.startsWith(() -> this.getChildren().stream().filter(s -> s.isAuthorized(sender)).map(s -> s.getName().toLowerCase(Locale.ROOT)))).from(1, partial -> this.getChildren().stream().filter(s -> s.isAuthorized(sender)).filter(s -> s.getName().equalsIgnoreCase(args.get(0))).findFirst().map(cmd -> cmd.tabComplete(plugin, sender, args.subList(1, args.size()))).orElse(Collections.emptyList())).complete((List<String>)((Object)args));
            }
        }
        throw new AssertionError((Object)this.type);
    }

    @Override
    public void sendUsage(Sender sender, String label) {
        List subs = this.getChildren().stream().filter(s -> s.isAuthorized(sender)).collect(Collectors.toList());
        if (!subs.isEmpty()) {
            Message.MAIN_COMMAND_USAGE_HEADER.send(sender, this.getName(), String.format(this.getUsage(), label));
            for (Command s2 : subs) {
                s2.sendUsage(sender, label);
            }
        } else {
            Message.COMMAND_NO_PERMISSION.send(sender);
        }
    }

    @Override
    public void sendDetailedUsage(Sender sender, String label) {
        this.sendUsage(sender, label);
    }

    @Override
    public boolean isAuthorized(Sender sender) {
        return this.getChildren().stream().anyMatch(sc -> sc.isAuthorized(sender));
    }

    protected List<String> getTargets(LuckPermsPlugin plugin) {
        throw new UnsupportedOperationException();
    }

    protected I parseTarget(String target, LuckPermsPlugin plugin, Sender sender) {
        throw new UnsupportedOperationException();
    }

    protected ReentrantLock getLockForTarget(I target) {
        throw new UnsupportedOperationException();
    }

    protected T getTarget(I target, LuckPermsPlugin plugin, Sender sender) {
        throw new UnsupportedOperationException();
    }

    protected void cleanup(T t, LuckPermsPlugin plugin) {
        throw new UnsupportedOperationException();
    }

    public static enum Type {
        NOT_TARGETED(0),
        TARGETED(1);

        private final int cmdIndex;
        private final int minArgs;

        private Type(int cmdIndex) {
            this.cmdIndex = cmdIndex;
            this.minArgs = cmdIndex + 1;
        }
    }
}

