/*
 * Decompiled with CFR 0.152.
 */
package me.lucko.luckperms.common.command.access;

import java.util.function.BiFunction;
import java.util.function.Function;
import me.lucko.luckperms.common.cacheddata.result.TristateResult;
import me.lucko.luckperms.common.cacheddata.type.PermissionCache;
import me.lucko.luckperms.common.calculator.processor.DirectProcessor;
import me.lucko.luckperms.common.command.access.CommandPermission;
import me.lucko.luckperms.common.config.ConfigKeys;
import me.lucko.luckperms.common.model.Group;
import me.lucko.luckperms.common.model.HolderType;
import me.lucko.luckperms.common.model.PermissionHolder;
import me.lucko.luckperms.common.model.Track;
import me.lucko.luckperms.common.model.User;
import me.lucko.luckperms.common.node.types.Inheritance;
import me.lucko.luckperms.common.plugin.LuckPermsPlugin;
import me.lucko.luckperms.common.query.QueryOptionsImpl;
import me.lucko.luckperms.common.sender.Sender;
import me.lucko.luckperms.common.verbose.event.CheckOrigin;
import net.luckperms.api.context.Context;
import net.luckperms.api.context.ContextSet;
import net.luckperms.api.util.Tristate;

public final class ArgumentPermissions {
    private static final String USER_MODIFY_SELF = "luckperms.modify.user.self";
    private static final String USER_MODIFY_OTHERS = "luckperms.modify.user.others";
    private static final Function<String, String> GROUP_MODIFY = s -> "luckperms.modify.group." + s;
    private static final Function<String, String> TRACK_MODIFY = s -> "luckperms.modify.track." + s;
    private static final String USER_VIEW_SELF = "luckperms.view.user.self";
    private static final String USER_VIEW_OTHERS = "luckperms.view.user.others";
    private static final Function<String, String> GROUP_VIEW = s -> "luckperms.view.group." + s;
    private static final Function<String, String> TRACK_VIEW = s -> "luckperms.view.track." + s;
    private static final String CONTEXT_USE_GLOBAL = "luckperms.usecontext.global";
    private static final BiFunction<String, String, String> CONTEXT_USE = (k, v) -> "luckperms.usecontext." + k + "." + v;

    private ArgumentPermissions() {
    }

    public static boolean checkArguments(LuckPermsPlugin plugin, Sender sender, CommandPermission base, String ... args) {
        if (!plugin.getConfiguration().get(ConfigKeys.USE_ARGUMENT_BASED_COMMAND_PERMISSIONS).booleanValue()) {
            return false;
        }
        if (args.length == 0) {
            throw new IllegalStateException();
        }
        StringBuilder permission = new StringBuilder(base.getPermission());
        for (String arg : args) {
            permission.append(".").append(arg);
        }
        return !sender.hasPermission(permission.toString());
    }

    public static boolean checkModifyPerms(LuckPermsPlugin plugin, Sender sender, CommandPermission base, Object target) {
        if (!plugin.getConfiguration().get(ConfigKeys.USE_ARGUMENT_BASED_COMMAND_PERMISSIONS).booleanValue()) {
            return false;
        }
        if (target instanceof User) {
            User targetUser = (User)target;
            if (targetUser.getUniqueId().equals(sender.getUniqueId())) {
                Tristate state = sender.getPermissionValue(base.getPermission() + ".modify.self");
                if (state != Tristate.UNDEFINED) {
                    return !state.asBoolean();
                }
                Tristate globalState = sender.getPermissionValue(USER_MODIFY_SELF);
                return !globalState.asBoolean();
            }
            Tristate state = sender.getPermissionValue(base.getPermission() + ".modify.others");
            if (state != Tristate.UNDEFINED) {
                return !state.asBoolean();
            }
            Tristate globalState = sender.getPermissionValue(USER_MODIFY_OTHERS);
            return !globalState.asBoolean();
        }
        if (target instanceof Group) {
            Group targetGroup = (Group)target;
            Tristate state = sender.getPermissionValue(base.getPermission() + ".modify." + targetGroup.getName());
            if (state != Tristate.UNDEFINED) {
                return !state.asBoolean();
            }
            Tristate globalState = sender.getPermissionValue(GROUP_MODIFY.apply(targetGroup.getName()));
            return !globalState.asBoolean();
        }
        if (target instanceof Track) {
            Track targetTrack = (Track)target;
            Tristate state = sender.getPermissionValue(base.getPermission() + ".modify." + targetTrack.getName());
            if (state != Tristate.UNDEFINED) {
                return !state.asBoolean();
            }
            Tristate globalState = sender.getPermissionValue(TRACK_MODIFY.apply(targetTrack.getName()));
            return !globalState.asBoolean();
        }
        throw new IllegalStateException();
    }

    public static boolean checkViewPerms(LuckPermsPlugin plugin, Sender sender, CommandPermission base, Object target) {
        if (!plugin.getConfiguration().get(ConfigKeys.USE_ARGUMENT_BASED_COMMAND_PERMISSIONS).booleanValue()) {
            return false;
        }
        if (target instanceof User) {
            User targetUser = (User)target;
            if (targetUser.getUniqueId().equals(sender.getUniqueId())) {
                Tristate state = sender.getPermissionValue(base.getPermission() + ".view.self");
                if (state != Tristate.UNDEFINED) {
                    return !state.asBoolean();
                }
                Tristate globalState = sender.getPermissionValue(USER_VIEW_SELF);
                return !globalState.asBoolean();
            }
            Tristate state = sender.getPermissionValue(base.getPermission() + ".view.others");
            if (state != Tristate.UNDEFINED) {
                return !state.asBoolean();
            }
            Tristate globalState = sender.getPermissionValue(USER_VIEW_OTHERS);
            return !globalState.asBoolean();
        }
        if (target instanceof Group) {
            Group targetGroup = (Group)target;
            Tristate state = sender.getPermissionValue(base.getPermission() + ".view." + targetGroup.getName());
            if (state != Tristate.UNDEFINED) {
                return !state.asBoolean();
            }
            Tristate globalState = sender.getPermissionValue(GROUP_VIEW.apply(targetGroup.getName()));
            return !globalState.asBoolean();
        }
        if (target instanceof Track) {
            Track targetTrack = (Track)target;
            Tristate state = sender.getPermissionValue(base.getPermission() + ".view." + targetTrack.getName());
            if (state != Tristate.UNDEFINED) {
                return !state.asBoolean();
            }
            Tristate globalState = sender.getPermissionValue(TRACK_VIEW.apply(targetTrack.getName()));
            return !globalState.asBoolean();
        }
        return false;
    }

    public static boolean checkContext(LuckPermsPlugin plugin, Sender sender, CommandPermission base, ContextSet contextSet) {
        if (!plugin.getConfiguration().get(ConfigKeys.USE_ARGUMENT_BASED_COMMAND_PERMISSIONS).booleanValue()) {
            return false;
        }
        if (contextSet.isEmpty()) {
            Tristate state = sender.getPermissionValue(base.getPermission() + ".usecontext.global");
            if (state != Tristate.UNDEFINED) {
                return !state.asBoolean();
            }
            Tristate globalState = sender.getPermissionValue(CONTEXT_USE_GLOBAL);
            return !globalState.asBoolean();
        }
        for (Context context : contextSet) {
            Tristate globalState;
            Tristate state = sender.getPermissionValue(base.getPermission() + ".usecontext." + context.getKey() + "." + context.getValue());
            if (!(state != Tristate.UNDEFINED ? state == Tristate.FALSE : (globalState = sender.getPermissionValue(CONTEXT_USE.apply(context.getKey(), context.getValue()))) == Tristate.FALSE)) continue;
            return true;
        }
        return false;
    }

    public static boolean checkGroup(LuckPermsPlugin plugin, Sender sender, PermissionHolder holder, ContextSet contextSet) {
        if (holder.getType() == HolderType.GROUP) {
            return ArgumentPermissions.checkGroup(plugin, sender, ((Group)holder).getName(), contextSet);
        }
        return false;
    }

    public static boolean checkGroup(LuckPermsPlugin plugin, Sender sender, String targetGroupName, ContextSet contextSet) {
        if (!plugin.getConfiguration().get(ConfigKeys.REQUIRE_SENDER_GROUP_MEMBERSHIP_TO_MODIFY).booleanValue()) {
            return false;
        }
        if (sender.isConsole()) {
            return false;
        }
        User user = (User)plugin.getUserManager().getIfLoaded(sender.getUniqueId());
        if (user == null) {
            throw new IllegalStateException("Unable to get a User for " + String.valueOf(sender.getUniqueId()) + " - " + sender.getName());
        }
        PermissionCache permissionData = user.getCachedData().getPermissionData(QueryOptionsImpl.DEFAULT_CONTEXTUAL.toBuilder().context(contextSet).build());
        TristateResult result = permissionData.checkPermission(Inheritance.key(targetGroupName), CheckOrigin.INTERNAL);
        return result.result() != Tristate.TRUE || result.processorClass() != DirectProcessor.class;
    }
}

