/*
 * Decompiled with CFR 0.152.
 */
package me.lucko.luckperms.common.commands.group;

import com.google.common.collect.ImmutableList;
import java.util.ArrayList;
import java.util.List;
import java.util.Locale;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.locks.ReentrantLock;
import me.lucko.luckperms.common.command.abstraction.ParentCommand;
import me.lucko.luckperms.common.command.spec.CommandSpec;
import me.lucko.luckperms.common.command.utils.StorageAssistant;
import me.lucko.luckperms.common.commands.generic.meta.CommandMeta;
import me.lucko.luckperms.common.commands.generic.other.HolderClear;
import me.lucko.luckperms.common.commands.generic.other.HolderEditor;
import me.lucko.luckperms.common.commands.generic.other.HolderShowTracks;
import me.lucko.luckperms.common.commands.generic.parent.CommandParent;
import me.lucko.luckperms.common.commands.generic.permission.CommandPermission;
import me.lucko.luckperms.common.commands.group.GroupClone;
import me.lucko.luckperms.common.commands.group.GroupInfo;
import me.lucko.luckperms.common.commands.group.GroupListMembers;
import me.lucko.luckperms.common.commands.group.GroupRename;
import me.lucko.luckperms.common.commands.group.GroupSetDisplayName;
import me.lucko.luckperms.common.commands.group.GroupSetWeight;
import me.lucko.luckperms.common.model.Group;
import me.lucko.luckperms.common.model.HolderType;
import me.lucko.luckperms.common.plugin.LuckPermsPlugin;
import me.lucko.luckperms.common.sender.Sender;
import me.lucko.luckperms.common.util.CaffeineFactory;
import me.lucko.luckperms.lib.caffeine.cache.LoadingCache;

public class GroupParentCommand
extends ParentCommand<Group, String> {
    private final LoadingCache<String, ReentrantLock> locks = CaffeineFactory.newBuilder().expireAfterAccess(1L, TimeUnit.HOURS).build(key -> new ReentrantLock());

    public GroupParentCommand() {
        super(CommandSpec.GROUP, "Group", ParentCommand.Type.TARGETED, ImmutableList.builder().add((Object)new GroupInfo()).add(new CommandPermission(HolderType.GROUP)).add(new CommandParent(HolderType.GROUP)).add(new CommandMeta(HolderType.GROUP)).add(new HolderEditor(HolderType.GROUP)).add((Object)new GroupListMembers()).add((Object)new GroupSetWeight()).add((Object)new GroupSetDisplayName()).add(new HolderShowTracks(HolderType.GROUP)).add(new HolderClear(HolderType.GROUP)).add((Object)new GroupRename()).add((Object)new GroupClone()).build());
    }

    @Override
    protected String parseTarget(String target, LuckPermsPlugin plugin, Sender sender) {
        Group group = plugin.getGroupManager().getByDisplayName(target);
        if (group != null) {
            return group.getName();
        }
        return target.toLowerCase(Locale.ROOT);
    }

    @Override
    protected Group getTarget(String target, LuckPermsPlugin plugin, Sender sender) {
        return StorageAssistant.loadGroup(target, sender, plugin, true);
    }

    @Override
    protected ReentrantLock getLockForTarget(String target) {
        return (ReentrantLock)this.locks.get((Object)target);
    }

    @Override
    protected void cleanup(Group group, LuckPermsPlugin plugin) {
    }

    @Override
    protected List<String> getTargets(LuckPermsPlugin plugin) {
        return new ArrayList<String>(plugin.getGroupManager().getAll().keySet());
    }
}

