/*
 * Decompiled with CFR 0.152.
 */
package me.lucko.luckperms.common.commands.log;

import java.util.List;
import me.lucko.luckperms.common.actionlog.LogPage;
import me.lucko.luckperms.common.actionlog.LoggedAction;
import me.lucko.luckperms.common.actionlog.filter.ActionFilters;
import me.lucko.luckperms.common.command.abstraction.ChildCommand;
import me.lucko.luckperms.common.command.access.CommandPermission;
import me.lucko.luckperms.common.command.spec.CommandSpec;
import me.lucko.luckperms.common.command.utils.ArgumentList;
import me.lucko.luckperms.common.filter.PageParameters;
import me.lucko.luckperms.common.locale.Message;
import me.lucko.luckperms.common.plugin.LuckPermsPlugin;
import me.lucko.luckperms.common.sender.Sender;
import me.lucko.luckperms.common.util.Predicates;

public class LogSearch
extends ChildCommand<Void> {
    private static final int ENTRIES_PER_PAGE = 10;

    public LogSearch() {
        super(CommandSpec.LOG_SEARCH, "search", CommandPermission.LOG_SEARCH, Predicates.is(0));
    }

    @Override
    public void execute(LuckPermsPlugin plugin, Sender sender, Void ignored, ArgumentList args, String label) {
        int page = 1;
        if (args.size() > 1) {
            try {
                page = Integer.parseInt(args.get(args.size() - 1));
                args.remove(args.size() - 1);
            }
            catch (NumberFormatException numberFormatException) {
                // empty catch block
            }
        }
        String query = String.join((CharSequence)" ", (Iterable<? extends CharSequence>)((Object)args));
        PageParameters pageParams = new PageParameters(10, page);
        LogPage log = plugin.getStorage().getLogPage(ActionFilters.search(query), pageParams).join();
        int maxPage = pageParams.getMaxPage(log.getTotalEntries());
        if (log.getTotalEntries() == 0) {
            Message.LOG_NO_ENTRIES.send(sender);
            return;
        }
        if (page < 1 || page > maxPage) {
            Message.LOG_INVALID_PAGE_RANGE.send(sender, maxPage);
            return;
        }
        List<LogPage.Entry<LoggedAction>> entries = log.getNumberedContent();
        Message.LOG_SEARCH_HEADER.send(sender, query, page, maxPage);
        for (LogPage.Entry<LoggedAction> e : entries) {
            Message.LOG_ENTRY.send(sender, e.position(), e.value());
        }
    }
}

