/*
 * Decompiled with CFR 0.152.
 */
package me.lucko.luckperms.common.config;

import com.google.gson.GsonBuilder;
import com.google.gson.JsonElement;
import com.google.gson.JsonObject;
import java.io.BufferedReader;
import java.io.BufferedWriter;
import java.io.IOException;
import java.io.Reader;
import java.nio.charset.StandardCharsets;
import java.nio.file.Files;
import java.nio.file.LinkOption;
import java.nio.file.OpenOption;
import java.nio.file.Path;
import me.lucko.luckperms.common.config.LuckPermsConfiguration;
import me.lucko.luckperms.common.context.ImmutableContextSetImpl;
import me.lucko.luckperms.common.context.serializer.ContextSetJsonSerializer;
import me.lucko.luckperms.common.util.gson.GsonProvider;
import net.luckperms.api.context.ImmutableContextSet;

public class ContextsFile {
    private final LuckPermsConfiguration configuration;
    private ImmutableContextSet staticContexts = ImmutableContextSetImpl.EMPTY;
    private ImmutableContextSet defaultContexts = ImmutableContextSetImpl.EMPTY;

    public ContextsFile(LuckPermsConfiguration configuration) {
        this.configuration = configuration;
    }

    public void load() {
        Path file = this.configuration.getPlugin().getBootstrap().getDataDirectory().resolve("contexts.json");
        if (!Files.exists(file, new LinkOption[0])) {
            this.save();
            return;
        }
        try (BufferedReader reader = Files.newBufferedReader(file, StandardCharsets.UTF_8);){
            JsonObject data = (JsonObject)GsonProvider.normal().fromJson((Reader)reader, JsonObject.class);
            if (data == null) {
                return;
            }
            if (data.has("static-contexts")) {
                this.staticContexts = ContextSetJsonSerializer.deserialize((JsonElement)data.get("static-contexts").getAsJsonObject()).immutableCopy();
            }
            if (data.has("default-contexts")) {
                this.defaultContexts = ContextSetJsonSerializer.deserialize((JsonElement)data.get("default-contexts").getAsJsonObject()).immutableCopy();
            }
        }
        catch (IOException e) {
            e.printStackTrace();
        }
    }

    public void save() {
        Path file = this.configuration.getPlugin().getBootstrap().getDataDirectory().resolve("contexts.json");
        try (BufferedWriter writer = Files.newBufferedWriter(file, StandardCharsets.UTF_8, new OpenOption[0]);){
            JsonObject data = new JsonObject();
            data.add("static-contexts", (JsonElement)ContextSetJsonSerializer.serialize(this.staticContexts));
            data.add("default-contexts", (JsonElement)ContextSetJsonSerializer.serialize(this.defaultContexts));
            new GsonBuilder().setPrettyPrinting().create().toJson((JsonElement)data, (Appendable)writer);
            writer.flush();
        }
        catch (IOException e) {
            e.printStackTrace();
        }
    }

    public ImmutableContextSet getStaticContexts() {
        return this.staticContexts;
    }

    public ImmutableContextSet getDefaultContexts() {
        return this.defaultContexts;
    }
}

