/*
 * Decompiled with CFR 0.152.
 */
package me.lucko.luckperms.common.config.generic.adapter;

import com.google.common.base.Splitter;
import java.util.List;
import java.util.Map;
import me.lucko.luckperms.common.config.generic.adapter.ConfigurationAdapter;
import org.checkerframework.checker.nullness.qual.Nullable;

public abstract class StringBasedConfigurationAdapter
implements ConfigurationAdapter {
    private static final Splitter LIST_SPLITTER = Splitter.on((char)',');
    private static final Splitter.MapSplitter MAP_SPLITTER = Splitter.on((char)',').withKeyValueSeparator('=');

    protected abstract @Nullable String resolveValue(String var1);

    @Override
    public String getString(String path, String def) {
        String value = this.resolveValue(path);
        if (value == null) {
            return def;
        }
        return value;
    }

    @Override
    public int getInteger(String path, int def) {
        String value = this.resolveValue(path);
        if (value == null) {
            return def;
        }
        try {
            return Integer.parseInt(value);
        }
        catch (IllegalArgumentException e) {
            return def;
        }
    }

    @Override
    public boolean getBoolean(String path, boolean def) {
        String value = this.resolveValue(path);
        if (value == null) {
            return def;
        }
        try {
            return Boolean.parseBoolean(value);
        }
        catch (IllegalArgumentException e) {
            return def;
        }
    }

    @Override
    public List<String> getStringList(String path, List<String> def) {
        String value = this.resolveValue(path);
        if (value == null) {
            return def;
        }
        return LIST_SPLITTER.splitToList((CharSequence)value);
    }

    @Override
    public Map<String, String> getStringMap(String path, Map<String, String> def) {
        String value = this.resolveValue(path);
        if (value == null) {
            return def;
        }
        return MAP_SPLITTER.split((CharSequence)value);
    }
}

