/*
 * Decompiled with CFR 0.152.
 */
package me.lucko.luckperms.common.filter;

import java.util.Collections;
import java.util.List;
import java.util.stream.Stream;

public class PageParameters {
    private final int pageSize;
    private final int pageNumber;

    public PageParameters(int pageSize, int pageNumber) {
        if (pageSize < 1) {
            throw new IllegalArgumentException("pageSize cannot be less than 1: " + pageSize);
        }
        if (pageNumber < 1) {
            throw new IllegalArgumentException("pageNumber cannot be less than 1: " + pageNumber);
        }
        this.pageSize = pageSize;
        this.pageNumber = pageNumber;
    }

    public int pageSize() {
        return this.pageSize;
    }

    public int pageNumber() {
        return this.pageNumber;
    }

    public <T> List<T> paginate(List<T> input) {
        int fromIndex = this.pageSize * (this.pageNumber - 1);
        if (fromIndex >= input.size()) {
            return Collections.emptyList();
        }
        int toIndex = Math.min(fromIndex + this.pageSize, input.size());
        return input.subList(fromIndex, toIndex);
    }

    public <T> Stream<T> paginate(Stream<T> input) {
        return input.skip((long)this.pageSize * (long)(this.pageNumber - 1)).limit(this.pageSize);
    }

    public int getMaxPage(int totalEntries) {
        if (totalEntries == 0) {
            return 0;
        }
        return (totalEntries + this.pageSize - 1) / this.pageSize;
    }
}

