/*
 * Decompiled with CFR 0.152.
 */
package me.lucko.luckperms.common.filter.mongo;

import java.util.regex.Pattern;
import me.lucko.luckperms.common.filter.Comparison;
import me.lucko.luckperms.common.filter.Constraint;
import me.lucko.luckperms.common.filter.PageParameters;
import me.lucko.luckperms.lib.bson.conversions.Bson;
import me.lucko.luckperms.lib.mongodb.client.FindIterable;
import me.lucko.luckperms.lib.mongodb.client.model.Filters;
import org.checkerframework.checker.nullness.qual.Nullable;

public class ConstraintMongoBuilder {
    public static final ConstraintMongoBuilder INSTANCE = new ConstraintMongoBuilder();

    protected ConstraintMongoBuilder() {
    }

    public Object mapConstraintValue(Object value) {
        return value;
    }

    public Bson make(Constraint<?> constraint, String fieldName) {
        Comparison comparison = constraint.comparison();
        Object value = this.mapConstraintValue(constraint.value());
        switch (comparison) {
            case EQUAL: {
                return Filters.eq((String)fieldName, (Object)value);
            }
            case NOT_EQUAL: {
                return Filters.ne((String)fieldName, (Object)value);
            }
            case SIMILAR: {
                if (!(value instanceof String)) {
                    throw new IllegalArgumentException("Unable to create SIMILAR comparison for non-string type: " + value.getClass().getName());
                }
                Pattern pattern = Comparison.compilePatternForLikeSyntax((String)value);
                return Filters.regex((String)fieldName, (Pattern)pattern);
            }
            case NOT_SIMILAR: {
                if (!(value instanceof String)) {
                    throw new IllegalArgumentException("Unable to create NOT_SIMILAR comparison for non-string type: " + value.getClass().getName());
                }
                Pattern pattern = Comparison.compilePatternForLikeSyntax((String)value);
                return Filters.not((Bson)Filters.regex((String)fieldName, (Pattern)pattern));
            }
        }
        throw new AssertionError((Object)comparison);
    }

    public static <R> FindIterable<R> page(@Nullable PageParameters params, FindIterable<R> iterable) {
        if (params == null) {
            return iterable;
        }
        int pageSize = params.pageSize();
        int pageNumber = params.pageNumber();
        return iterable.limit(pageSize).skip((pageNumber - 1) * pageSize);
    }
}

